/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.persistence.model;

import java.time.Instant;
import javax.persistence.MappedSuperclass;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Transient;
import org.omnifaces.persistence.model.BaseEntity;
import org.omnifaces.persistence.model.Timestamped;

@MappedSuperclass
public abstract class TimestampedEntity<T>
extends BaseEntity<T>
implements Timestamped {
    private static final long serialVersionUID = 1L;
    @Transient
    private boolean skipAdjustLastModified;

    @PrePersist
    public void onPrePersist() {
        Instant timestamp = Instant.now();
        this.setCreated(timestamp);
        this.setLastModified(timestamp);
    }

    @PreUpdate
    public void onPreUpdate() {
        if (!this.skipAdjustLastModified) {
            Instant timestamp = Instant.now();
            this.setLastModified(timestamp);
        }
    }

    public void skipAdjustLastModified() {
        this.skipAdjustLastModified = true;
    }
}

