/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.persistence.listener;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PreUpdate;
import org.omnifaces.persistence.event.Created;
import org.omnifaces.persistence.event.Deleted;
import org.omnifaces.persistence.event.Updated;
import org.omnifaces.utils.annotation.Annotations;

public class PersistenceEventEntityListener {
    @Inject
    private BeanManager beanManager;

    @PostPersist
    public void onPostPersist(Object entity) {
        this.beanManager.fireEvent(entity, new Annotation[]{Annotations.createAnnotationInstance(Created.class)});
    }

    @PreUpdate
    public void onPreUpdate(Object entity) {
        this.beanManager.fireEvent(entity, new Annotation[]{Annotations.createAnnotationInstance(Updated.class)});
    }

    @PostRemove
    public void onPostRemove(Object entity) {
        this.beanManager.fireEvent(entity, new Annotation[]{Annotations.createAnnotationInstance(Deleted.class)});
    }
}

