/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.persistence.datasource;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import javax.sql.CommonDataSource;
import org.omnifaces.persistence.datasource.CommonDataSourceWrapper;
import org.omnifaces.persistence.datasource.PropertiesFileLoader;
import org.omnifaces.utils.properties.PropertiesUtils;

public class SwitchableCommonDataSource
extends CommonDataSourceWrapper {
    private boolean init;
    private String configFile;
    private Map<String, Object> tempValues = new HashMap<String, Object>();

    @Override
    public void set(String name, Object value) {
        if (this.init) {
            super.set(name, value);
        } else {
            this.tempValues.put(name, value);
        }
    }

    @Override
    public <T> T get(String name) {
        if (this.init) {
            return super.get(name);
        }
        return (T)this.tempValues.get(name);
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
        this.doInit();
    }

    public void doInit() {
        ServiceLoader<PropertiesFileLoader> loader = ServiceLoader.load(PropertiesFileLoader.class);
        if (!loader.iterator().hasNext()) {
            loader = ServiceLoader.load(PropertiesFileLoader.class, SwitchableCommonDataSource.class.getClassLoader());
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        if (!loader.iterator().hasNext()) {
            properties.putAll(PropertiesUtils.loadPropertiesFromClasspath((String)("META-INF/" + this.configFile)));
        } else {
            for (PropertiesFileLoader propertiesFileLoader : loader) {
                properties.putAll(propertiesFileLoader.loadFromFile(this.configFile));
            }
        }
        String className = (String)properties.get("className");
        if (className == null) {
            throw new IllegalStateException("Required parameter 'className' missing.");
        }
        this.initDataSource(this.newInstance(className));
        for (Map.Entry<String, Object> entry : this.tempValues.entrySet()) {
            super.set(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            if (entry.getKey().equals("className")) continue;
            this.setWithConversion(entry.getKey(), (String)entry.getValue());
        }
        this.init = true;
    }

    private CommonDataSource newInstance(String className) {
        try {
            return (CommonDataSource)Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }
}

