/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.client;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.XmlRpcRequestConfig;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientException;
import org.apache.xmlrpc.client.XmlRpcLocalClientConfig;
import org.apache.xmlrpc.client.XmlRpcTransportImpl;
import org.apache.xmlrpc.common.TypeConverter;
import org.apache.xmlrpc.common.TypeConverterFactory;
import org.apache.xmlrpc.common.XmlRpcExtensionException;
import org.apache.xmlrpc.common.XmlRpcRequestProcessor;

public class XmlRpcLocalTransport
extends XmlRpcTransportImpl {
    public XmlRpcLocalTransport(XmlRpcClient pClient) {
        super(pClient);
    }

    private boolean isExtensionType(Object pObject) {
        if (pObject == null) {
            return true;
        }
        if (pObject instanceof Object[]) {
            Object[] objects = (Object[])pObject;
            for (int i = 0; i < objects.length; ++i) {
                if (!this.isExtensionType(objects[i])) continue;
                return true;
            }
            return false;
        }
        if (pObject instanceof Collection) {
            Iterator iter = ((Collection)pObject).iterator();
            while (iter.hasNext()) {
                if (!this.isExtensionType(iter.next())) continue;
                return true;
            }
            return false;
        }
        if (pObject instanceof Map) {
            Map map = (Map)pObject;
            for (Map.Entry entry : map.entrySet()) {
                if (!this.isExtensionType(entry.getKey()) && !this.isExtensionType(entry.getValue())) continue;
                return true;
            }
            return false;
        }
        return !(pObject instanceof Integer) && !(pObject instanceof Date) && !(pObject instanceof String) && !(pObject instanceof byte[]) && !(pObject instanceof Double);
    }

    @Override
    public Object sendRequest(XmlRpcRequest pRequest) throws XmlRpcException {
        Object result;
        XmlRpcRequestConfig config = pRequest.getConfig();
        if (!config.isEnabledForExtensions()) {
            for (int i = 0; i < pRequest.getParameterCount(); ++i) {
                if (!this.isExtensionType(pRequest.getParameter(i))) continue;
                throw new XmlRpcExtensionException("Parameter " + i + " has invalid type, if isEnabledForExtensions() == false");
            }
        }
        XmlRpcRequestProcessor server = ((XmlRpcLocalClientConfig)config).getXmlRpcServer();
        try {
            result = server.execute(pRequest);
        }
        catch (XmlRpcException t) {
            throw t;
        }
        catch (Throwable t) {
            throw new XmlRpcClientException("Failed to invoke method " + pRequest.getMethodName() + ": " + t.getMessage(), t);
        }
        if (!config.isEnabledForExtensions() && this.isExtensionType(result)) {
            throw new XmlRpcExtensionException("Result has invalid type, if isEnabledForExtensions() == false");
        }
        if (result == null) {
            return null;
        }
        TypeConverterFactory typeConverterFactory = server.getTypeConverterFactory();
        TypeConverter typeConverter = typeConverterFactory.getTypeConverter(result.getClass());
        return typeConverter.backConvert(result);
    }
}

