/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.service.tcp.mina;

import java.net.SocketAddress;
import java.nio.charset.Charset;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.service.IoConnector;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.textline.TextLineCodecFactory;
import org.apache.mina.transport.socket.nio.NioDatagramAcceptor;
import org.apache.mina.transport.socket.nio.NioDatagramConnector;
import org.oiue.service.log.LogService;
import org.oiue.service.tcp.Handler;
import org.oiue.service.tcp.UdpService;
import org.oiue.service.tcp.mina.ServiceHandler;
import org.oiue.service.tcp.mina.TcpServiceImpl;

public class UdpServiceImpl
extends TcpServiceImpl
implements UdpService {
    public UdpServiceImpl(LogService logService) {
        super(logService);
        this.logger = logService.getLogger(this.getClass());
    }

    @Override
    public synchronized boolean register(SocketAddress address, Handler handler, boolean binary, int idleTime, String charsetName) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("register address = " + address + ", binary = " + binary + ", ide time = " + idleTime + "ms, charset = " + charsetName, new Object[0]);
        }
        try {
            NioDatagramAcceptor acceptor = new NioDatagramAcceptor();
            if (!binary) {
                if (charsetName == null) {
                    charsetName = "UTF-8";
                }
                TextLineCodecFactory textLineCodec = new TextLineCodecFactory(Charset.forName(charsetName));
                textLineCodec.setDecoderMaxLineLength(Integer.MAX_VALUE);
                textLineCodec.setEncoderMaxLineLength(Integer.MAX_VALUE);
                acceptor.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)textLineCodec));
            }
            acceptor.setHandler((IoHandler)new ServiceHandler(handler, binary, null, this.logService));
            acceptor.getSessionConfig().setReadBufferSize(2048);
            acceptor.getSessionConfig().setIdleTime(IdleStatus.READER_IDLE, idleTime / 1000);
            acceptor.getSessionConfig().setIdleTime(IdleStatus.WRITER_IDLE, idleTime / 1000);
            acceptor.bind(address);
            this.acceptorMap.put(address, acceptor);
            return true;
        }
        catch (Exception e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("register error", (Throwable)e);
            }
            return false;
        }
    }

    @Override
    public boolean connect(SocketAddress address, Handler handler, boolean binary, int connectTimeout, int idleTime, String charsetName) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("connect address = " + address + ", binary = " + binary + ", ide time = " + idleTime + "ms, charset = " + charsetName, new Object[0]);
        }
        try {
            NioDatagramConnector connector = new NioDatagramConnector();
            connector.setConnectTimeoutMillis((long)connectTimeout);
            if (!binary) {
                if (charsetName == null) {
                    charsetName = "UTF-8";
                }
                TextLineCodecFactory textLineCodec = new TextLineCodecFactory(Charset.forName(charsetName));
                textLineCodec.setDecoderMaxLineLength(Integer.MAX_VALUE);
                textLineCodec.setEncoderMaxLineLength(Integer.MAX_VALUE);
                connector.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)textLineCodec));
            }
            ServiceHandler serviceHandler = new ServiceHandler(handler, binary, (IoConnector)connector, this.logService);
            connector.setHandler((IoHandler)serviceHandler);
            connector.getSessionConfig().setReadBufferSize(4096);
            connector.getSessionConfig().setIdleTime(IdleStatus.READER_IDLE, idleTime / 1000);
            connector.getSessionConfig().setIdleTime(IdleStatus.WRITER_IDLE, idleTime / 1000);
            ConnectFuture future = connector.connect(address);
            future.addListener((IoFutureListener)new ConnectFutureListener(serviceHandler));
            return true;
        }
        catch (Exception e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("connect error", (Throwable)e);
            }
            return false;
        }
    }

    private class ConnectFutureListener
    implements IoFutureListener<ConnectFuture> {
        private ServiceHandler handler;

        public ConnectFutureListener(ServiceHandler handler) {
            this.handler = handler;
        }

        public void operationComplete(ConnectFuture future) {
            if (!future.isConnected()) {
                try {
                    this.handler.sessionClosed(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

