/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.service.tcp.mina;

import java.io.Serializable;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.service.IoConnector;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.oiue.service.log.LogService;
import org.oiue.service.log.Logger;
import org.oiue.service.tcp.Handler;
import org.oiue.service.tcp.Session;
import org.oiue.service.tcp.mina.SessionImpl;

public class ServiceHandler
extends IoHandlerAdapter
implements Serializable {
    private Logger logger = null;
    public static final String SESSION_NAME = "SERVICE_TCP_SESSION";
    public static final String REMOTE_ADDRESS = "SERVICE_REMOTE_ADDRESS";
    public static final String LAST_TIME = "SERVICE_LAST_TIME";
    public static final String SESSION_BINARY = "SERVICE_SESSION_BINARY";
    private Handler handler;
    private boolean binary;
    private LogService logService;
    private IoConnector connector;

    public ServiceHandler(Handler handler, boolean binary, IoConnector connector, LogService logService) {
        this.handler = handler;
        this.binary = binary;
        this.connector = connector;
        this.logService = logService;
        this.logger = logService.getLogger(this.getClass());
        this.logger.info("new service handle binary = " + binary, new Object[0]);
    }

    public String toByteString(byte[] bytes, int size) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            if (i == 0) {
                sb.append("0x");
            } else {
                sb.append(", 0x");
            }
            sb.append(this.toByteHex(bytes[i]));
        }
        return sb.toString();
    }

    private String toByteHex(byte b) {
        String temp = Integer.toHexString(0xFF & b);
        if (temp.length() < 2) {
            return "0" + temp;
        }
        return temp;
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        session.setAttribute((Object)LAST_TIME, (Object)System.currentTimeMillis());
        if (this.binary) {
            IoBuffer buffer = (IoBuffer)message;
            byte[] bytes = new byte[buffer.limit()];
            buffer.get(bytes);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("messageReceived session = " + session + ", length = " + bytes.length + ", bytes = " + this.toByteString(bytes, bytes.length), new Object[0]);
            }
            this.handler.received((Session)session.getAttribute((Object)SESSION_NAME), null, bytes);
        } else {
            String msg;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("messageReceived session = " + session + ", text = " + message, new Object[0]);
            }
            if ((msg = message.toString()) != null && !msg.startsWith("{'_t':'hb'")) {
                this.handler.received((Session)session.getAttribute((Object)SESSION_NAME), msg, null);
            }
        }
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("exceptionCaught session = " + session + ", cause message = " + cause.getMessage(), new Object[0]);
        }
    }

    public void sessionCreated(IoSession session) throws Exception {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("sessionCreated session = " + session, new Object[0]);
        }
        session.setAttribute((Object)SESSION_NAME, (Object)new SessionImpl(session, this.logService));
        session.setAttribute((Object)SESSION_BINARY, (Object)this.binary);
    }

    public void sessionClosed(IoSession session) throws Exception {
        if (this.connector != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ServiceHandler.this.connector.dispose();
                }
            }, this.getClass().getName()).start();
        }
        if (session == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("connect error", new Object[0]);
            }
            this.handler.closed(null);
        } else {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("sessionClosed session = " + session, new Object[0]);
            }
            this.handler.closed((Session)session.getAttribute((Object)SESSION_NAME));
            session.close(true);
        }
    }

    public void messageSent(IoSession session, Object message) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.info("messageSent session = " + session, new Object[0]);
        }
        session.setAttribute((Object)LAST_TIME, (Object)System.currentTimeMillis());
        this.handler.sent((Session)session.getAttribute((Object)SESSION_NAME));
    }

    public void sessionOpened(IoSession session) throws Exception {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("sessionOpened session = " + session, new Object[0]);
        }
        Session newSession = (Session)session.getAttribute((Object)SESSION_NAME);
        session.setAttribute((Object)REMOTE_ADDRESS, (Object)session.getRemoteAddress());
        session.setAttribute((Object)LAST_TIME, (Object)System.currentTimeMillis());
        this.handler.opened(newSession);
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("idled is_reader = " + (status == IdleStatus.READER_IDLE) + "|sessionIdle session = " + session, new Object[0]);
        }
        if (session.isClosing()) {
            return;
        }
        Session newSession = (Session)session.getAttribute((Object)SESSION_NAME);
        int readerIdleCount = session.getIdleCount(IdleStatus.READER_IDLE);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("idled is_reader = " + (status == IdleStatus.READER_IDLE) + "/" + readerIdleCount, new Object[0]);
        }
        if (status == IdleStatus.READER_IDLE) {
            if (readerIdleCount != 0 && this.handler.getReaderIdleCount() != 0 && readerIdleCount > this.handler.getReaderIdleCount()) {
                newSession.close();
            }
        } else {
            session.setAttribute((Object)LAST_TIME, (Object)System.currentTimeMillis());
            if (!this.binary) {
                if (this.logger.isDebugEnabled()) {
                    newSession.write("{'_t':'hb','_data':'heartbeat','_reader_idle':" + readerIdleCount + ",'_writer_idle':" + session.getIdleCount(IdleStatus.WRITER_IDLE) + ",'_system_time':" + System.currentTimeMillis() + "}");
                } else {
                    newSession.write("{'_t':'hb'}");
                }
            }
        }
        if (status == IdleStatus.WRITER_IDLE) {
            this.handler.idled(newSession);
        }
    }
}

