/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.service.tcp.mina;

import java.io.Serializable;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.oiue.service.log.LogService;
import org.oiue.service.log.Logger;
import org.oiue.service.tcp.Session;
import org.oiue.tools.exception.ExceptionUtil;

public class SessionImpl
implements Session,
Serializable {
    private IoSession session;
    private Logger logger;

    public SessionImpl(IoSession session, LogService logService) {
        this.session = session;
        this.logger = logService.getLogger(this.getClass());
    }

    public void close() {
        try {
            this.session.close(true);
        }
        catch (Throwable e) {
            this.logger.error("close session error\uff1a" + ExceptionUtil.getCausedBySrcMsg((Throwable)e), e);
        }
    }

    public Object getAttribute(String key) {
        try {
            return this.session.getAttribute((Object)key);
        }
        catch (Throwable e) {
            this.logger.error("getAttribute error\uff1a" + ExceptionUtil.getCausedBySrcMsg((Throwable)e), e);
            return null;
        }
    }

    public Object setAttribute(String key, Object attribute) {
        try {
            return this.session.setAttribute((Object)key, attribute);
        }
        catch (Throwable e) {
            this.logger.error("setAttribute error\uff1a" + ExceptionUtil.getCausedBySrcMsg((Throwable)e), e);
            return null;
        }
    }

    public String toString() {
        try {
            return this.session.toString();
        }
        catch (Throwable e) {
            this.logger.error("session toString error\uff1a" + ExceptionUtil.getCausedBySrcMsg((Throwable)e), e);
            return null;
        }
    }

    public static String toByteString(byte[] bytes, int size) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            if (i == 0) {
                sb.append("0x");
            } else {
                sb.append(", 0x");
            }
            sb.append(SessionImpl.toByteHex(bytes[i]));
        }
        return sb.toString();
    }

    private static String toByteHex(byte b) {
        String temp = Integer.toHexString(0xFF & b);
        if (temp.length() < 2) {
            return "0" + temp;
        }
        return temp;
    }

    public void write(byte[] data) {
        try {
            if (this.session.isClosing()) {
                throw new NullPointerException();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("write session = " + this.session + ", length = " + data.length + ", bytes = " + SessionImpl.toByteString(data, data.length));
            }
            this.session.write((Object)IoBuffer.wrap((byte[])data));
        }
        catch (Throwable e) {
            this.logger.error("session write byte error\uff1a" + ExceptionUtil.getCausedBySrcMsg((Throwable)e), e);
        }
    }

    public void write(String line) {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("write session = " + this.session + ", text = " + line);
            }
            this.session.write((Object)line);
        }
        catch (Throwable e) {
            this.logger.error("session write string error\uff1a" + ExceptionUtil.getCausedBySrcMsg((Throwable)e), e);
        }
    }
}

