/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.service.permission.impl;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.oiue.service.log.LogService;
import org.oiue.service.log.Logger;
import org.oiue.service.online.Online;
import org.oiue.service.permission.PermissionService;
import org.oiue.service.permission.PermissionServiceManager;
import org.oiue.tools.StatusResult;
import org.oiue.tools.string.StringUtil;

public class PermissionServiceManagerImpl
implements PermissionServiceManager,
Serializable {
    private Logger logger;
    private String permission_type = "permission_type";
    private String permission_convert_type = "permission_convert_type";
    private String def_permission = "def_permission";
    private String def_permission_convert = "def_permission_convert";
    private Map<String, PermissionService> permission = new HashMap<String, PermissionService>();

    public PermissionServiceManagerImpl(LogService logService) {
        this.logger = logService.getLogger(this.getClass());
    }

    public void updated(Dictionary<String, ?> props) {
        try {
            String permission_convert_type;
            String permission_type;
            String def_permission_convert;
            String def_permission = props.get("defaultPermission") + "";
            if (!StringUtil.isEmptys((String)def_permission)) {
                this.def_permission = def_permission;
            }
            if (!StringUtil.isEmptys((String)(def_permission_convert = props.get("defaultPermissionConvert") + ""))) {
                this.def_permission_convert = def_permission_convert;
            }
            if (!StringUtil.isEmptys((String)(permission_type = props.get("permissionKey") + ""))) {
                this.permission_type = permission_type;
            }
            if (!StringUtil.isEmptys((String)(permission_convert_type = props.get("permissionConvertKey") + ""))) {
                this.permission_convert_type = permission_convert_type;
            }
        }
        catch (Throwable e) {
            this.logger.error("config is error:" + e.getMessage(), e);
        }
    }

    public StatusResult verify(Map per, Online online) {
        if (online == null) {
            StatusResult afr = new StatusResult();
            afr.setResult(-120);
            afr.setDescription("verify error!");
            return afr;
        }
        Map data = (Map)per.get("data");
        data.put("user_id", online.getUser_id());
        data.put("domain", per.get("domain"));
        per.put("token", online.getToken());
        String type = (String)data.remove(this.permission_type);
        if (StringUtil.isEmptys((String)type)) {
            String msg = "the key[" + this.permission_type + "] con't null or empty!";
            if (this.logger.isWarnEnabled()) {
                this.logger.warn(msg + ":" + per, new Object[0]);
            }
            type = this.def_permission;
        }
        PermissionService auth = this.permission.get(type);
        per.put("_system_permission_user_key_", online);
        return auth.verify(per, online);
    }

    public StatusResult convert(Map per) {
        Map data = (Map)per.get("data");
        String type = (String)data.remove(this.permission_convert_type);
        if (StringUtil.isEmptys((String)type)) {
            String msg = "the key[" + this.permission_convert_type + "] con't null or empty!";
            this.logger.warn(msg + ":" + per, new Object[0]);
            type = this.def_permission_convert;
        }
        PermissionService auth = this.permission.get(type);
        return auth.convert(per);
    }

    public boolean registerPermissionService(String name, PermissionService verify) {
        if (this.permission.containsKey(name)) {
            return false;
        }
        this.permission.put(name, verify);
        return true;
    }

    public boolean unRegisterPermissionService(String name) {
        if (this.permission.containsKey(name)) {
            this.permission.remove(name);
            return true;
        }
        return false;
    }

    public void unregister() {
    }
}

