/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.service.online.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.text.html.CSS;
import org.oiue.service.cache.CacheServiceManager;
import org.oiue.service.cache.Type;
import org.oiue.service.log.LogService;
import org.oiue.service.log.Logger;
import org.oiue.service.online.OfflineHandler;
import org.oiue.service.online.Online;
import org.oiue.service.online.OnlineHandler;
import org.oiue.service.online.OnlineService;
import org.oiue.tools.string.StringUtil;

public class OnlineServiceImpl
implements OnlineService {
    public static final String _SYSTEM_ONLINE = "system.online";
    public static String _GLOBAL_CACHE = "redis";
    public static boolean clearClient = false;
    public static clearClient ccs = null;
    private Logger logger;
    private CacheServiceManager cache;
    private LogService logService;
    private int online_timeout = 600000;
    private Map<String, OfflineHandler> offline = new HashMap<String, OfflineHandler>();
    private Map<Integer, String> offlineSort = new TreeMap<Integer, String>();
    private Map<String, OnlineHandler> online = new HashMap<String, OnlineHandler>();
    private Map<Integer, String> onlineSort = new TreeMap<Integer, String>();

    public void updated(Dictionary props) {
        this.logger.debug("updated config for OnlineServiceImpl" + props);
        try {
            clearClient = StringUtil.isTrue((String)(props.get("online.clearClient") + ""));
            if (clearClient) {
                if (ccs == null) {
                    ccs = new clearClient(this.logService);
                    new Thread((Runnable)ccs, CSS.class.getName()).start();
                }
            } else {
                ccs = null;
            }
        }
        catch (Throwable e) {
            this.logger.error("updateConfigure is error:" + e.getMessage(), e);
        }
        try {
            String GLOBAL_CACHE = props.get("online.globalCache") + "";
            if (!StringUtil.isEmptys((String)GLOBAL_CACHE)) {
                _GLOBAL_CACHE = GLOBAL_CACHE;
            }
        }
        catch (Throwable e) {
            this.logger.error("updateConfigure[online.globalCache] is error:" + e.getMessage(), e);
        }
        try {
            String timeout = props.get("online.timeout") + "";
            if (!StringUtil.isEmptys((String)timeout)) {
                this.online_timeout = Integer.valueOf(timeout) * 1000;
            }
        }
        catch (Throwable e) {
            this.logger.error("updateConfigure[online.timeout] is error:" + e.getMessage(), e);
        }
    }

    public OnlineServiceImpl(LogService logService, CacheServiceManager cache) {
        try {
            this.logger = logService.getLogger(this.getClass());
            this.logService = logService;
            this.cache = cache;
        }
        catch (Throwable e) {
            this.logger.error("OnlineServiceImpl is error:" + e.getMessage(), e);
        }
    }

    public boolean putOnline(String token, Online online) {
        online.setLastTime(System.currentTimeMillis());
        this.cache.put(_SYSTEM_ONLINE, token, (Object)online, Type.ONE);
        return true;
    }

    public Online getOnlineByToken(String token) {
        return (Online)this.cache.get(_SYSTEM_ONLINE, token);
    }

    public boolean isOnlineByToken(String token) {
        Online online = (Online)this.cache.get(_SYSTEM_ONLINE, token);
        if (online == null) {
            return false;
        }
        online.setLastTime(System.currentTimeMillis());
        return true;
    }

    public Collection<Online> getOnlines() {
        return ((Map)this.cache.get(_SYSTEM_ONLINE)).values();
    }

    public List<Online> getOnlinesByUserID(String userId) {
        ArrayList<Online> rtnList = new ArrayList<Online>();
        Object tokens = this.cache.get(_SYSTEM_ONLINE);
        if (tokens instanceof Map) {
            Map tokenm = (Map)tokens;
            for (Online online : tokenm.values()) {
                if (online == null || !userId.equals(online.getUser_id())) continue;
                rtnList.add(online);
            }
        }
        return rtnList;
    }

    public boolean removeOnlineByToken(String token) {
        try {
            Online online;
            if (token == null) {
                return false;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("removeOnline :" + token);
            }
            if (this.offline.size() > 0 && (online = (Online)this.cache.get(_SYSTEM_ONLINE, token)) != null) {
                for (OfflineHandler handler : this.offline.values()) {
                    try {
                        handler.logout(online);
                    }
                    catch (Throwable e) {
                        this.logger.error(handler + "removeOnline [" + token + "] is error:" + e.getMessage(), e);
                    }
                }
            }
            this.cache.delete(_SYSTEM_ONLINE, new String[]{token});
            return true;
        }
        catch (Throwable e) {
            this.logger.error("removeOnline [" + token + "] is error:" + e.getMessage(), e);
            return false;
        }
    }

    public boolean removeOnlineByUserId(String userId) {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("removeOnline :" + userId);
            }
            List<Online> onlines = this.getOnlinesByUserID(userId);
            for (Online online : onlines) {
                if (online == null) continue;
                this.removeOnlineByToken(online.getToken());
            }
            return true;
        }
        catch (Throwable e) {
            this.logger.error("removeOnline [" + userId + "] is error:" + e.getMessage(), e);
            return false;
        }
    }

    public synchronized boolean registerOfflineHandler(String name, OfflineHandler handler, int index) {
        if (this.offlineSort.get(index) != null) {
            throw new RuntimeException("index conflict! name=" + name + ", old index is " + this.offlineSort.get(index));
        }
        if (this.offline.get(name) == null) {
            this.offline.put(name, handler);
            this.offlineSort.put(index, name);
            LinkedHashMap<String, OfflineHandler> offlineTemp = new LinkedHashMap<String, OfflineHandler>();
            for (String value : this.offlineSort.values()) {
                offlineTemp.put(value, this.offline.get(value));
            }
            this.offline = offlineTemp;
            return true;
        }
        return false;
    }

    public synchronized boolean registerOnlineHandler(String name, OnlineHandler handler, int index) {
        if (this.onlineSort.get(index) != null) {
            throw new RuntimeException("index conflict! name=" + name + ", old index is " + this.onlineSort.get(index));
        }
        if (this.online.get(name) == null) {
            this.online.put(name, handler);
            this.onlineSort.put(index, name);
            LinkedHashMap<String, OnlineHandler> onlineTemp = new LinkedHashMap<String, OnlineHandler>();
            for (String value : this.offlineSort.values()) {
                onlineTemp.put(value, this.online.get(value));
            }
            this.online = onlineTemp;
            return true;
        }
        return false;
    }

    public synchronized boolean unRegisterOfflineHandler(String name) {
        this.offline.remove(name);
        Iterator<String> iterator = this.offlineSort.values().iterator();
        while (iterator.hasNext()) {
            String names = iterator.next();
            if (!name.equals(names)) continue;
            iterator.remove();
        }
        return true;
    }

    public synchronized boolean unRegisterOnlineHandler(String name) {
        this.online.remove(name);
        Iterator<String> iterator = this.onlineSort.values().iterator();
        while (iterator.hasNext()) {
            String names = iterator.next();
            if (!name.equals(names)) continue;
            iterator.remove();
        }
        return true;
    }

    public class clearClient
    implements Runnable {
        private Logger logger;

        public clearClient(LogService logService) {
            this.logger = logService.getLogger(this.getClass());
        }

        @Override
        public void run() {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("clearClient start");
            }
            while (clearClient) {
                try {
                    Long timeout = System.currentTimeMillis() - (long)OnlineServiceImpl.this.online_timeout;
                    ArrayList<String> logout = new ArrayList<String>();
                    Object tokens = OnlineServiceImpl.this.cache.get(OnlineServiceImpl._SYSTEM_ONLINE);
                    if (tokens instanceof Map) {
                        Map tokenm = (Map)tokens;
                        for (Online online : tokenm.values()) {
                            if (online == null || online.getLastTime() >= timeout) continue;
                            logout.add(online.getToken());
                        }
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("clean user :" + logout);
                    }
                    for (String token : logout) {
                        OnlineServiceImpl.this.removeOnlineByToken(token);
                    }
                }
                catch (Throwable e) {
                    this.logger.error("removeOnline error :" + e.getMessage(), e);
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

