/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.service.log4j;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.oiue.service.log.LogService;
import org.oiue.service.log.Logger;
import org.oiue.service.log4j.LoggerImpl;
import org.slf4j.LoggerFactory;

public class LogServiceImpl
implements LogService,
Serializable {
    private Logger logger = null;

    public void updateConfigure(Dictionary props) {
        if (props == null) {
            LogManager.getLogManager().reset();
            PropertyConfigurator.configure((Properties)new Properties());
            return;
        }
        Enumeration e = props.keys();
        Properties properties = new Properties();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = props.get(key);
            properties.put(key, value);
        }
        if (this.logger != null) {
            this.logger.info("configure update, reset all exist loggers.");
        }
        LogManager.getLogManager().reset();
        PropertyConfigurator.configure((Properties)properties);
        this.logger = this.getLogger(this.getClass());
        this.logger.info("update configure");
    }

    public Logger getLogger(Class clazz) {
        return this.getLogger(clazz.getName());
    }

    public Logger getLogger(String name) {
        return new LoggerImpl(LoggerFactory.getLogger(name));
    }
}

