/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.service.debug.res;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Dictionary;
import org.oiue.service.debug.res.ServerHandler;
import org.oiue.service.log.LogService;
import org.oiue.service.log.Logger;
import org.oiue.service.odp.base.FactoryService;
import org.oiue.service.osgi.FrameActivator;
import org.oiue.service.osgi.MulitServiceTrackerCustomizer;
import org.oiue.service.tcp.Handler;
import org.oiue.service.tcp.TcpService;

public class Activator
extends FrameActivator {
    public void start() throws Exception {
        this.start(new MulitServiceTrackerCustomizer(){
            private FactoryService factoryService;
            private TcpService tcpService;
            private SocketAddress address;
            private Logger logger;

            public void removedService() {
                if (this.tcpService != null && this.address != null) {
                    this.tcpService.unregister(this.address);
                    this.address = null;
                }
            }

            public void addingService() {
                this.factoryService = (FactoryService)Activator.this.getService(FactoryService.class);
                this.tcpService = (TcpService)Activator.this.getService(TcpService.class);
                LogService logService = (LogService)Activator.this.getService(LogService.class);
                this.logger = logService.getLogger(((Object)((Object)this)).getClass());
            }

            public void updated(Dictionary<String, ?> props) {
                try {
                    if (props == null) {
                        return;
                    }
                    if (this.address != null) {
                        this.tcpService.unregister(this.address);
                    }
                    int listenPort = Integer.parseInt(props.get("listenPort").toString());
                    String listenAddress = props.get("listenAddress").toString();
                    int idleTime = Integer.parseInt(props.get("receiveTimeOut").toString());
                    String charset = props.get("charset").toString();
                    this.address = new InetSocketAddress(listenAddress, listenPort);
                    this.tcpService.register(this.address, (Handler)new ServerHandler(this.factoryService), false, idleTime, charset);
                }
                catch (Exception ex) {
                    this.logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }, new Class[]{LogService.class, FactoryService.class, TcpService.class});
    }

    public void stop() throws Exception {
    }
}

