/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.service.buffer.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.oiue.service.buffer.BufferService;
import org.oiue.service.buffer.KeyToMany;
import org.oiue.service.buffer.KeyToOne;
import org.oiue.service.buffer.KeyToSpatial;
import org.oiue.service.buffer.KeyToSpatialMerge;
import org.oiue.service.buffer.KeyToSpatialObject;
import org.oiue.service.buffer.KeyToTree;
import org.oiue.service.buffer.Type;
import org.oiue.service.log.LogService;
import org.oiue.service.log.Logger;

public class BufferServiceImpl
implements BufferService,
Serializable {
    private Logger logger;
    private static Map<String, Object> hmBuffer = null;

    public BufferServiceImpl(LogService logService) {
        this.logger = logService.getLogger(this.getClass());
        hmBuffer = new ConcurrentHashMap<String, Object>();
    }

    public Map<String, Object> getHashMap() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("get buffer hashmap", new Object[0]);
        }
        return hmBuffer;
    }

    public Object put(String name, Type bufferType) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("put buffer name = " + name + " ,type = " + bufferType, new Object[0]);
        }
        hmBuffer.remove(name);
        KeyToOne obj = null;
        switch (bufferType) {
            case KeyToOne: {
                obj = new KeyToOne();
                break;
            }
            case KeyToMany: {
                obj = new KeyToMany();
                break;
            }
            case KeyToSpatial: {
                obj = new KeyToSpatial();
                break;
            }
            case KeyToTree: {
                obj = new KeyToTree();
                break;
            }
            default: {
                this.logger.error("put buffer error, type not support, name = " + name + " ,type = " + bufferType, new Object[0]);
            }
        }
        if (obj != null) {
            hmBuffer.put(name, obj);
        }
        return obj;
    }

    public Object get(String name) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("get buffer name = " + name + ", result = " + hmBuffer.containsKey(name), new Object[0]);
        }
        return hmBuffer.get(name);
    }

    public Object remove(String name) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("remove buffer name = " + name, new Object[0]);
        }
        return hmBuffer.remove(name);
    }

    public void put(String name, String key, Object value) {
        Object obj;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("put name = " + name + ", key = " + key + ", value = " + value, new Object[0]);
        }
        if ((obj = hmBuffer.get(name)) instanceof KeyToOne) {
            ((KeyToOne)obj).put((Object)key, value);
        } else if (obj instanceof KeyToMany) {
            ((KeyToMany)obj).put((Object)key, value);
        } else {
            this.logger.error("buffer type not support put(key, value), name = " + name + ", key = " + key + ", value = " + value, new Object[0]);
        }
    }

    public void put(String name, String key, Object value, Type bufferType) {
        Object obj;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("put name = " + name + ", key = " + key + ", value = " + value + ", type = " + bufferType, new Object[0]);
        }
        if ((obj = hmBuffer.get(name)) == null) {
            obj = this.put(name, bufferType);
        }
        if (obj instanceof KeyToOne) {
            ((KeyToOne)obj).put((Object)key, value);
        } else if (obj instanceof KeyToMany) {
            ((KeyToMany)obj).put((Object)key, value);
        }
    }

    public void put(String name, String key, double x, double y, Object value) {
        Object obj;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("put name = " + name + ", key = " + key + ", x = " + x + ", y = " + y + ", value = " + value, new Object[0]);
        }
        if ((obj = hmBuffer.get(name)) == null) {
            obj = this.put(name, Type.KeyToSpatial);
        }
        if (obj instanceof KeyToSpatial) {
            ((KeyToSpatial)obj).put((Object)key, x, y, value);
        }
    }

    public void put(String name, String key, String parentKey, Object value) {
        Object obj;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("put name = " + name + ", key = " + key + ", parentKey = " + parentKey + ", value = " + value, new Object[0]);
        }
        if ((obj = hmBuffer.get(name)) == null) {
            obj = this.put(name, Type.KeyToTree);
        }
        if (obj instanceof KeyToTree) {
            ((KeyToTree)obj).put((Object)key, (Object)parentKey, value);
        }
    }

    public Object get(String name, String key) {
        Object obj;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("get name = " + name + ", key = " + key, new Object[0]);
        }
        if ((obj = hmBuffer.get(name)) instanceof KeyToOne) {
            return ((KeyToOne)obj).get((Object)key);
        }
        if (obj instanceof KeyToMany) {
            return ((KeyToMany)obj).get((Object)key);
        }
        if (obj instanceof KeyToSpatial) {
            return ((KeyToSpatial)obj).get((Object)key);
        }
        if (obj instanceof KeyToTree) {
            return ((KeyToTree)obj).get((Object)key);
        }
        return null;
    }

    public List<Object> get(String name, Set<Object> matchSet) {
        Object obj;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("get name = " + name + ", match count = " + matchSet.size(), new Object[0]);
        }
        if ((obj = hmBuffer.get(name)) instanceof KeyToOne) {
            return ((KeyToOne)obj).get(matchSet);
        }
        if (obj instanceof KeyToMany) {
            return ((KeyToMany)obj).get(matchSet);
        }
        if (obj instanceof KeyToSpatial) {
            return ((KeyToSpatial)obj).get(matchSet);
        }
        if (obj instanceof KeyToTree) {
            return ((KeyToTree)obj).get(matchSet);
        }
        return null;
    }

    public List<Object> get(String name, double x1, double x2, double y1, double y2, Set<Object> matchSet) {
        Object obj;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("get name = " + name + ", x1 = " + x1 + ", x2 = " + x2 + ", y1 = " + y1 + ", y2 = " + y2 + ", match count = " + matchSet.size(), new Object[0]);
        }
        if ((obj = hmBuffer.get(name)) instanceof KeyToSpatial) {
            return ((KeyToSpatial)obj).get(x1, x2, y1, y2, matchSet);
        }
        return null;
    }

    public List<Object> get(String name, double[] x1, double[] x2, double[] y1, double[] y2, Set<Object> matchSet) {
        Object obj;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("get name = " + name + ", x1 = " + this.doubleArrayToString(x1) + ", x2 = " + this.doubleArrayToString(x2) + ", y1 = " + this.doubleArrayToString(y1) + ", y2 = " + this.doubleArrayToString(y2) + ", match count = " + matchSet.size(), new Object[0]);
        }
        if ((obj = hmBuffer.get(name)) instanceof KeyToSpatial) {
            return ((KeyToSpatial)obj).get(x1, x2, y1, y2, matchSet);
        }
        return null;
    }

    public List<KeyToSpatialMerge> get(String name, double x1, double x2, double y1, double y2, double dx, double dy, Set<Object> matchSet) {
        Object obj;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("get name = " + name + ", x1 = " + x1 + ", x2 = " + x2 + ", y1 = " + y1 + ", y2 = " + y2 + ", dx = " + dx + ", dy = " + dy + ", match count = " + matchSet.size(), new Object[0]);
        }
        if ((obj = hmBuffer.get(name)) instanceof KeyToSpatial) {
            return ((KeyToSpatial)obj).get(x1, x2, y1, y2, dx, dy, matchSet);
        }
        return null;
    }

    public List<KeyToSpatialMerge> get(String name, double[] x1, double[] x2, double[] y1, double[] y2, double dx, double dy, Set<Object> matchSet) {
        Object obj;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("get name = " + name + ", x1 = " + this.doubleArrayToString(x1) + ", x2 = " + this.doubleArrayToString(x2) + ", y1 = " + this.doubleArrayToString(y1) + ", y2 = " + this.doubleArrayToString(y2) + ", dx = " + dx + ", dy = " + dy + ", match count = " + matchSet.size(), new Object[0]);
        }
        if ((obj = hmBuffer.get(name)) instanceof KeyToSpatial) {
            return ((KeyToSpatial)obj).get(x1, x2, y1, y2, dx, dy, matchSet);
        }
        return null;
    }

    public List<Object> get(String name, double x1, double x2, double y1, double y2) {
        Object obj;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("get name = " + name + ", x1 = " + x1 + ", x2 = " + x2 + ", y1 = " + y1 + ", y2 = " + y2, new Object[0]);
        }
        if ((obj = hmBuffer.get(name)) instanceof KeyToSpatial) {
            return ((KeyToSpatial)obj).get(x1, x2, y1, y2);
        }
        return null;
    }

    public List<Object> get(String name, double[] x1, double[] x2, double[] y1, double[] y2) {
        Object obj;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("get name = " + name + ", x1 = " + this.doubleArrayToString(x1) + ", x2 = " + this.doubleArrayToString(x2) + ", y1 = " + this.doubleArrayToString(y1) + ", y2 = " + this.doubleArrayToString(y2), new Object[0]);
        }
        if ((obj = hmBuffer.get(name)) instanceof KeyToSpatial) {
            return ((KeyToSpatial)obj).get(x1, x2, y1, y2);
        }
        return null;
    }

    public List<KeyToSpatialMerge> get(String name, double x1, double x2, double y1, double y2, double dx, double dy) {
        Object obj;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("get name = " + name + ", x1 = " + x1 + ", x2 = " + x2 + ", y1 = " + y1 + ", y2 = " + y2 + ", dx = " + dx + ", dy = " + dy, new Object[0]);
        }
        if ((obj = hmBuffer.get(name)) instanceof KeyToSpatial) {
            return ((KeyToSpatial)obj).get(x1, x2, y1, y2, dx, dy);
        }
        return null;
    }

    public List<KeyToSpatialMerge> get(String name, double[] x1, double[] x2, double[] y1, double[] y2, double dx, double dy) {
        Object obj;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("get name = " + name + ", x1 = " + this.doubleArrayToString(x1) + ", x2 = " + this.doubleArrayToString(x2) + ", y1 = " + this.doubleArrayToString(y1) + ", y2 = " + this.doubleArrayToString(y2) + ", dx = " + dx + ", dy = " + dy, new Object[0]);
        }
        if ((obj = hmBuffer.get(name)) instanceof KeyToSpatial) {
            return ((KeyToSpatial)obj).get(x1, x2, y1, y2, dx, dy);
        }
        return null;
    }

    public boolean contains(String name, String key) {
        Object obj = hmBuffer.get(name);
        if (obj instanceof KeyToOne) {
            return ((KeyToOne)obj).contains((Object)key);
        }
        if (obj instanceof KeyToMany) {
            return ((KeyToMany)obj).contains((Object)key);
        }
        if (obj instanceof KeyToSpatial) {
            return ((KeyToSpatial)obj).contains((Object)key);
        }
        if (obj instanceof KeyToTree) {
            return ((KeyToTree)obj).contains((Object)key);
        }
        return false;
    }

    public boolean contains(String nameKeyToMany, String key, String value) {
        Object obj = hmBuffer.get(nameKeyToMany);
        if (obj instanceof KeyToMany) {
            return ((KeyToMany)obj).contains((Object)key, (Object)value);
        }
        return false;
    }

    public List<Object> getRelation(String nameKeyToManyOrTree, String key, String name) {
        KeyToTree keyToTree;
        List matchList;
        Object obj;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("get relation key to many or tree name = " + nameKeyToManyOrTree + ", key = " + key + ", name = " + name, new Object[0]);
        }
        if ((obj = hmBuffer.get(nameKeyToManyOrTree)) instanceof KeyToMany) {
            KeyToMany oneToMany = (KeyToMany)obj;
            Set matchSet = oneToMany.get((Object)key);
            if (matchSet != null) {
                return this.get(name, matchSet);
            }
        } else if (obj instanceof KeyToTree && (matchList = (keyToTree = (KeyToTree)obj).get((Object)key)) != null) {
            HashSet<Object> matchSet = new HashSet<Object>();
            matchSet.addAll(matchList);
            return this.get(name, matchSet);
        }
        return null;
    }

    public List<Object> getRelation(String nameKeyToMany, String key, String name, double x1, double x2, double y1, double y2) {
        KeyToMany oneToMany;
        Set matchSet;
        Object obj;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("get relation key to many name = " + nameKeyToMany + ", key = " + key + ", name = " + name + ", x1 = " + x1 + ", x2 = " + x2 + ", y1 = " + y1 + ", y2 = " + y2, new Object[0]);
        }
        if ((obj = hmBuffer.get(nameKeyToMany)) instanceof KeyToMany && (matchSet = (oneToMany = (KeyToMany)obj).get((Object)key)) != null) {
            return this.get(name, x1, x2, y1, y2, (Set<Object>)matchSet);
        }
        return null;
    }

    public List<Object> getRelation(String nameKeyToMany, String key, String name, double[] x1, double[] x2, double[] y1, double[] y2) {
        KeyToMany oneToMany;
        Set matchSet;
        Object obj;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("get relation key to many name = " + nameKeyToMany + ", key = " + key + ", name = " + name + ", x1 = " + this.doubleArrayToString(x1) + ", x2 = " + this.doubleArrayToString(x2) + ", y1 = " + this.doubleArrayToString(y1) + ", y2 = " + this.doubleArrayToString(y2), new Object[0]);
        }
        if ((obj = hmBuffer.get(nameKeyToMany)) instanceof KeyToMany && (matchSet = (oneToMany = (KeyToMany)obj).get((Object)key)) != null) {
            return this.get(name, x1, x2, y1, y2, (Set<Object>)matchSet);
        }
        return null;
    }

    public List<KeyToSpatialMerge> getRelation(String nameKeyToMany, String key, String name, double x1, double x2, double y1, double y2, double dx, double dy) {
        KeyToMany oneToMany;
        Set matchSet;
        Object obj;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("get relation key to many name = " + nameKeyToMany + ", key = " + key + ", name = " + name + ", x1 = " + x1 + ", x2 = " + x2 + ", y1 = " + y1 + ", y2 = " + y2 + ", dx = " + dx + ", dy = " + dy, new Object[0]);
        }
        if ((obj = hmBuffer.get(nameKeyToMany)) instanceof KeyToMany && (matchSet = (oneToMany = (KeyToMany)obj).get((Object)key)) != null) {
            return this.get(name, x1, x2, y1, y2, dx, dy, (Set<Object>)matchSet);
        }
        return null;
    }

    public List<KeyToSpatialMerge> getRelation(String nameKeyToMany, String key, String name, double[] x1, double[] x2, double[] y1, double[] y2, double dx, double dy) {
        KeyToMany oneToMany;
        Set matchSet;
        Object obj;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("get relation key to many name = " + nameKeyToMany + ", key = " + key + ", name = " + name + ", x1 = " + this.doubleArrayToString(x1) + ", x2 = " + this.doubleArrayToString(x2) + ", y1 = " + this.doubleArrayToString(y1) + ", y2 = " + this.doubleArrayToString(y2) + ", dx = " + dx + ", dy = " + dy, new Object[0]);
        }
        if ((obj = hmBuffer.get(nameKeyToMany)) instanceof KeyToMany && (matchSet = (oneToMany = (KeyToMany)obj).get((Object)key)) != null) {
            return this.get(name, x1, x2, y1, y2, dx, dy, (Set<Object>)matchSet);
        }
        return null;
    }

    public void remove(String name, String key) {
        Object obj;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("remove name = " + name + ", key = " + key, new Object[0]);
        }
        if ((obj = hmBuffer.get(name)) instanceof KeyToOne) {
            ((KeyToOne)obj).remove((Object)key);
        } else if (obj instanceof KeyToMany) {
            ((KeyToMany)obj).remove((Object)key);
        } else if (obj instanceof KeyToSpatial) {
            ((KeyToSpatial)obj).remove((Object)key);
        } else if (obj instanceof KeyToTree) {
            ((KeyToTree)obj).remove((Object)key);
        }
    }

    public void remove(String name, Set<Object> matchSet) {
        Object obj;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("remove name = " + name + ", match count = " + matchSet.size(), new Object[0]);
        }
        if ((obj = hmBuffer.get(name)) instanceof KeyToOne) {
            ((KeyToOne)obj).remove(matchSet);
        } else if (obj instanceof KeyToMany) {
            ((KeyToMany)obj).remove(matchSet);
        } else if (obj instanceof KeyToSpatial) {
            ((KeyToSpatial)obj).remove(matchSet);
        } else if (obj instanceof KeyToTree) {
            ((KeyToTree)obj).remove(matchSet);
        }
    }

    public void remove(String name, String key, Object value) {
        Object obj;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("remove name = " + name + ", key = " + key + ", value = " + value, new Object[0]);
        }
        if ((obj = hmBuffer.get(name)) instanceof KeyToMany) {
            ((KeyToMany)obj).remove((Object)key, value);
        }
    }

    public void remove(String name, String key, Set<Object> matchSet) {
        Object obj;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("remove name = " + name + ", key = " + key + ", match count = " + matchSet.size(), new Object[0]);
        }
        if ((obj = hmBuffer.get(name)) instanceof KeyToMany) {
            ((KeyToMany)obj).remove((Object)key, matchSet);
        }
    }

    public void removeRelation(String nameKeyToMany, String key, String name) {
        KeyToMany oneToMany;
        Set matchSet;
        Object obj;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("reomve relation key to many name = " + nameKeyToMany + ", key = " + key + ", name = " + name, new Object[0]);
        }
        if ((obj = hmBuffer.get(nameKeyToMany)) instanceof KeyToMany && (matchSet = (oneToMany = (KeyToMany)obj).get((Object)key)) != null) {
            Object remove = hmBuffer.get(name);
            if (remove instanceof KeyToOne) {
                ((KeyToOne)remove).remove(matchSet);
            } else if (remove instanceof KeyToMany) {
                ((KeyToMany)remove).remove(matchSet);
            } else if (remove instanceof KeyToSpatial) {
                ((KeyToSpatial)remove).remove(matchSet);
            } else if (remove instanceof KeyToTree) {
                ((KeyToTree)remove).remove(matchSet);
            }
        }
    }

    public void removeRelation(String nameKeyToMany, String key, String removeNameKeyToMany, String removeKey) {
        Object remove;
        KeyToMany oneToMany;
        Set matchSet;
        Object obj;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("reomve relation key to many name = " + nameKeyToMany + ", key = " + key + ", remove name = " + removeNameKeyToMany + ", remove key = " + removeKey, new Object[0]);
        }
        if ((obj = hmBuffer.get(nameKeyToMany)) instanceof KeyToMany && (matchSet = (oneToMany = (KeyToMany)obj).get((Object)key)) != null && (remove = hmBuffer.get(removeNameKeyToMany)) instanceof KeyToMany) {
            ((KeyToMany)remove).remove((Object)removeKey, matchSet);
        }
    }

    public static String encodeNameOrKey(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuffer sb = new StringBuffer(len + 4);
        block6: for (int i = 0; i < len; ++i) {
            c = string.charAt(i);
            switch (c) {
                case ',': {
                    sb.append('\'');
                    continue block6;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block6;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block6;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String decodeNameOrKey(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        char b = '\u0000';
        char c = '\u0000';
        int len = string.length();
        StringBuffer sb = new StringBuffer(len + 4);
        block6: for (int i = 0; i < len; ++i) {
            b = c;
            c = string.charAt(i);
            switch (c) {
                case '\'': {
                    if (b == '\\') {
                        sb.setCharAt(sb.length() - 1, ',');
                        continue block6;
                    }
                    sb.append(c);
                    continue block6;
                }
                case '\\': {
                    if (b == '\\') {
                        c = '\u0000';
                        continue block6;
                    }
                    sb.append(c);
                    continue block6;
                }
                case 'n': {
                    if (b == '\\') {
                        sb.setCharAt(sb.length() - 1, '\n');
                        continue block6;
                    }
                    sb.append(c);
                    continue block6;
                }
                case 'r': {
                    if (b == '\\') {
                        sb.setCharAt(sb.length() - 1, '\r');
                        continue block6;
                    }
                    sb.append(c);
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String encodeValue(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuffer sb = new StringBuffer(len + 4);
        block5: for (int i = 0; i < len; ++i) {
            c = string.charAt(i);
            switch (c) {
                case '\\': {
                    sb.append("\\\\");
                    continue block5;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block5;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String decodeValue(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        char b = '\u0000';
        char c = '\u0000';
        int len = string.length();
        StringBuffer sb = new StringBuffer(len + 4);
        block5: for (int i = 0; i < len; ++i) {
            b = c;
            c = string.charAt(i);
            switch (c) {
                case '\\': {
                    if (b == '\\') {
                        c = '\u0000';
                        continue block5;
                    }
                    sb.append(c);
                    continue block5;
                }
                case 'n': {
                    if (b == '\\') {
                        sb.setCharAt(sb.length() - 1, '\n');
                        continue block5;
                    }
                    sb.append(c);
                    continue block5;
                }
                case 'r': {
                    if (b == '\\') {
                        sb.setCharAt(sb.length() - 1, '\r');
                        continue block5;
                    }
                    sb.append(c);
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static Object toObj(Object object) throws JSONException {
        if (object instanceof Iterable) {
            ArrayList<Object> rtnL = new ArrayList<Object>();
            for (Object type : (Iterable)object) {
                rtnL.add(BufferServiceImpl.toObj(type));
            }
            return rtnL;
        }
        if (object instanceof Map) {
            HashMap rtnM = new HashMap();
            for (Object key : ((Map)object).keySet()) {
                rtnM.put(key, BufferServiceImpl.toObj(((Map)object).get(key)));
            }
            return rtnM;
        }
        if (object instanceof KeyToSpatial) {
            return ((KeyToSpatial)object).toObj();
        }
        if (object instanceof KeyToSpatialMerge) {
            return ((KeyToSpatialMerge)object).toObj();
        }
        if (object instanceof KeyToSpatialObject) {
            return ((KeyToSpatialObject)object).toObj();
        }
        return object;
    }

    private String doubleArrayToString(double[] array) {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            sb.append(",");
            sb.append(array[i]);
        }
        sb.append("]");
        return sb.toString();
    }

    public void swap(String nameA, String nameB) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("swap buffer, a name = " + nameA + ", b name = " + nameB, new Object[0]);
        }
        Object a = hmBuffer.get(nameA);
        Object b = hmBuffer.get(nameB);
        if (b != null) {
            hmBuffer.put(nameA, b);
        } else {
            hmBuffer.remove(nameA);
        }
        if (a != null) {
            hmBuffer.put(nameB, a);
        } else {
            hmBuffer.remove(nameB);
        }
    }
}

