/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.service.odp.event.dmo.mysql.selects;

import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.oiue.service.log.LogService;
import org.oiue.service.log.Logger;
import org.oiue.service.odp.dmo.CallBack;
import org.oiue.service.odp.dmo.DMO;
import org.oiue.service.odp.event.api.Event;
import org.oiue.service.odp.event.api.EventConvertService;
import org.oiue.table.structure.TableModel;
import org.oiue.tools.map.MapUtil;

public class SelectEventMysqlService
extends DMO
implements Event {
    private static final long serialVersionUID = -4232372066134799100L;
    private Logger logger;
    private LogService logService;

    public SelectEventMysqlService(LogService logService) {
        this.logger = logService.getLogger(((Object)((Object)this)).getClass());
        this.logService = logService;
    }

    public Event clone() throws CloneNotSupportedException {
        return new SelectEventMysqlService(this.logService);
    }

    public List Query(TableModel tableModel) throws Throwable {
        return null;
    }

    public TableModel QueryObj(TableModel tableModel) throws Throwable {
        return null;
    }

    public Object call(Map event, Map data, CallBack callBack) throws Throwable {
        Object rtnObject;
        EventConvertService eventConvert = (EventConvertService)this.getIDMO(EventConvertService.class.getName(), new Object[0]);
        List events = eventConvert.convert(event, data);
        this.logger.debug("events:" + events + "|event:" + event + "|data:" + data, new Object[0]);
        if (events == null || events.size() == 0) {
            throw new RuntimeException("event can not found \uff01event:" + event + "|data:" + data);
        }
        if (events.size() == 1) {
            Map event_t = (Map)events.get(0);
            if (event_t == null || event_t.get("event_type") == null) {
                throw new RuntimeException("event error \uff01events:" + events + "|event:" + event + "|data:" + data);
            }
            rtnObject = this.call(event_t, callBack);
        } else {
            ArrayList<Object> rtn = new ArrayList<Object>();
            for (Map mapevent : events) {
                rtn.add(this.call(mapevent, callBack));
            }
            rtnObject = rtn;
        }
        return rtnObject;
    }

    public Object call(Map map, CallBack callBack) throws Throwable {
        if (map == null || map.isEmpty()) {
            this.logger.error("the parameter map is null", new Object[0]);
            throw new RuntimeException("the parameter map is null");
        }
        return this.executeQuery(map, callBack);
    }

    private List<Map> executeQuery(Map map, CallBack callBack) throws Throwable {
        String sql = (String)map.get("wmwfmSql");
        if (sql == null || sql.isEmpty()) {
            this.logger.error("the sql is null", new Object[0]);
            return null;
        }
        List fmConditionList = (List)map.get("wmwfmConditionList");
        ArrayList<Object> fmConditionListPrepare = null;
        if (fmConditionList != null && !fmConditionList.isEmpty()) {
            fmConditionListPrepare = new ArrayList<Object>();
            for (int i = 0; i < fmConditionList.size(); ++i) {
                fmConditionListPrepare.add(MapUtil.get((Map)map, (String)((String)fmConditionList.get(i))));
            }
        }
        this.execute(sql, fmConditionListPrepare);
        ArrayList<Map> rtn = new ArrayList<Map>();
        while (this.getRs().next()) {
            if (callBack == null) {
                rtn.add(this.getMapResult(this.getRs()));
                continue;
            }
            callBack.callBack(this.getMapResult(this.getRs()));
        }
        return rtn;
    }

    private Map getMapResult(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int sum = rsmd.getColumnCount();
        Hashtable<String, Object> row = new Hashtable<String, Object>();
        for (int i = 1; i < sum + 1; ++i) {
            Object value = rs.getObject(i);
            if (value instanceof BigDecimal) {
                value = ((BigDecimal)value).scale() == 0 ? (Number)((BigDecimal)value).longValue() : (Number)((BigDecimal)value).doubleValue();
            } else if (value instanceof Clob) {
                value = this.clobToString((Clob)value);
            }
            String key = rsmd.getColumnLabel(i);
            row.put(key, value == null ? "" : value);
        }
        return row;
    }

    private String clobToString(Clob clob) {
        if (clob == null) {
            return null;
        }
        try {
            Reader inStreamDoc = clob.getCharacterStream();
            char[] tempDoc = new char[(int)clob.length()];
            inStreamDoc.read(tempDoc);
            inStreamDoc.close();
            return new String(tempDoc);
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

