package org.oiue.service.odp.event.dmo.mysql.call;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.oiue.service.log.LogService;
import org.oiue.service.log.Logger;
import org.oiue.service.odp.dmo.DMO;
import org.oiue.service.odp.event.api.Event;
import org.oiue.service.odp.event.api.EventField;
import org.oiue.service.odp.res.dmo.CallBack;
import org.oiue.table.structure.TableModel;
import org.oiue.tools.map.MapUtil;

public class EventMysqlService extends DMO implements Event{

	private static final long serialVersionUID = -4232372066134799100L;
	private static Logger logger;

	public EventMysqlService(LogService logService) {
		logger = logService.getLogger(this.getClass());
	}

	public EventMysqlService() {

	}

	@SuppressWarnings("rawtypes")
	@Override
	public List Query(TableModel tableModel) throws Throwable {
		return null;
	}

	@Override
	public TableModel QueryObj(TableModel tableModel) throws Throwable {
		return null;
	}

	@SuppressWarnings("rawtypes")
	@Override
	public Object call(Map map) throws Throwable {
		return call(map, null);
	}

	@SuppressWarnings("rawtypes")
	@Override
	public Object call(Map map, CallBack callBack) throws Throwable {
		if(map == null || map.isEmpty()) {
			logger.error("the parameter map is null");
			throw new RuntimeException("the parameter map is null");
		}
		String countSql = (String) map.get(EventField.contentCount);
		if(countSql != null) {
			return executeQuery(map, callBack);
		}else {
			return executeUpdate(map);
		}
	}

	@SuppressWarnings({"unchecked", "rawtypes"})
	private Map executeQuery(Map map, CallBack callBack) throws Throwable {
		String sql = (String) map.get(EventField.content);
		if(sql == null || sql.isEmpty() ){
			logger.error("the sql is null");
			return null;
		}
		List<String> fmConditionList = (List<String>) map.get(EventField.contentList);
		stmt = this.getConn().prepareCall(sql);
		if(fmConditionList != null && !fmConditionList.isEmpty()) {
			for(int i = 0; i < fmConditionList.size(); i++) {
				stmt.setObject(i + 1, MapUtil.get(map,fmConditionList.get(i)));
			}
		}
		boolean hadResults = stmt.execute();
		while (hadResults) {
		}
		Map result = new HashMap();
		return result;
	}

	@SuppressWarnings({"rawtypes", "unchecked"})
	public Map executeUpdate(Map map) throws Throwable {
		return this.executeQuery(map, null);
	}


}
