/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.service.action.tcp.bytes;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.oiue.service.action.api.ActionService;
import org.oiue.service.bytes.api.BytesRuleField;
import org.oiue.service.bytes.api.BytesService;
import org.oiue.service.log.LogService;
import org.oiue.service.log.Logger;
import org.oiue.service.online.Online;
import org.oiue.service.online.OnlineDataField;
import org.oiue.service.online.OnlineService;
import org.oiue.service.online.Type;
import org.oiue.service.tcp.Handler;
import org.oiue.service.tcp.Session;
import org.oiue.tools.bytes.ByteUtil;
import org.oiue.tools.bytes.Crc;
import org.oiue.tools.exception.ExceptionUtil;
import org.oiue.tools.json.JSONUtil;
import org.oiue.tools.map.MapUtil;
import org.oiue.tools.string.StringUtil;

public class ServerHandler
implements Handler {
    private ActionService actionService;
    private Logger logger;
    private OnlineService onlineService;
    private BytesService bytesService;
    private String KEY_READ_BUFFER = "key_read_buffer";
    private String KEY_READ_Queue = "key_read_Queue";
    private String KEY_READ_THREAD = "key_read_thread";
    private String KEY_SENT_INFO = "key_sent_info";
    private boolean runReceived = true;
    private String bf_charset = "ISO-8859-1";
    private String charset = "UTF-8";
    private Dictionary props;
    private int anonymous_count = 3;
    private String universal_answer = "";
    private String universal_reply = "";
    private String universal_head = "";

    public ServerHandler(LogService logService, ActionService actionService, OnlineService onlineService, BytesService bytesService) {
        this.actionService = actionService;
        this.onlineService = onlineService;
        this.logger = logService.getLogger(this.getClass());
        this.bytesService = bytesService;
    }

    public void updated(Dictionary props) {
        this.props = props;
        try {
            this.anonymous_count = Integer.valueOf(this.props.get("anonymousCount") + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.universal_answer = props.get("msg.universal.answer") + "";
        this.universal_reply = props.get("msg.universal.reply") + "";
        this.universal_head = props.get("msg.universal.head") + "";
    }

    public void received(Session session, String line, byte[] bytes) throws Exception {
        Object per = null;
        HashMap<String, Object> rtn = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[" + session + "]received :" + ByteUtil.toHexString((byte[])bytes));
        }
        try {
            if (bytes == null || bytes.length == 0) {
                return;
            }
            if (null == session.getAttribute("binary")) {
                session.setAttribute("binary", (Object)true);
            }
            try {
                StringBuffer readBuffer = (StringBuffer)session.getAttribute(this.KEY_READ_BUFFER);
                readBuffer.append(new String(bytes, this.bf_charset));
                LinkedBlockingQueue receivedQueue = (LinkedBlockingQueue)session.getAttribute(this.KEY_READ_Queue);
                receivedQueue.add(new Object());
                if (session.getAttribute(this.KEY_READ_THREAD) == null) {
                    Thread receivedTh = new Thread((Runnable)new receivedRunable(readBuffer, receivedQueue, session), receivedRunable.class.getName());
                    session.setAttribute(this.KEY_READ_THREAD, (Object)receivedTh);
                    receivedTh.start();
                }
            }
            catch (Throwable e) {
                throw new RuntimeException("\u53c2\u6570\u683c\u5f0f\u4e0d\u6b63\u786e\uff01[" + ExceptionUtil.getCausedBySrcMsg((Throwable)e) + "] /n " + line + " /n " + per, e);
            }
        }
        catch (Throwable ex) {
            this.logger.error("received error\uff1a" + ExceptionUtil.getCausedBySrcMsg((Throwable)ex), ex);
            rtn = new HashMap<String, Object>();
            rtn.put("status", -110);
            rtn.put("excepion", ExceptionUtil.getCausedBySrcMsg((Throwable)ex));
            rtn.put("return_info", ExceptionUtil.getCausedBySrcMsg((Throwable)ex));
            rtn.put("command_id", 0);
            rtn.put("command_serial", 0);
            byte[] rtn1 = this.bytesService.encoded(null, (Object)this.universal_reply, rtn);
            byte[] command = ByteUtil.int2bytes((int)36865, (int)2);
            this.send(session, rtn1, command);
        }
    }

    private void send(Session session, byte[] source, byte[] command) {
        try {
            byte[] pack = new byte[source.length + 10];
            System.arraycopy(source, 0, pack, 8, source.length);
            System.arraycopy(command, 0, pack, 1, 2);
            System.arraycopy(ByteUtil.int2bytes((int)source.length, (int)2), 0, pack, 4, 2);
            int serial = 0;
            if (session.getAttribute("serial") != null) {
                serial = (Integer)session.getAttribute("serial");
            }
            System.arraycopy(ByteUtil.int2bytes((int)serial, (int)2), 0, pack, 6, 2);
            session.setAttribute("serial", (Object)serial++);
            pack[pack.length - 2] = Crc.crc((byte[])pack, (int)1, (int)(pack.length - 3));
            String ts = new String(pack, this.bf_charset);
            ts = ts.replace(new String(new byte[]{125}, this.bf_charset), new String(new byte[]{125, 1}, this.bf_charset));
            ts = ts.replace(new String(new byte[]{126}, this.bf_charset), new String(new byte[]{125, 2}, this.bf_charset));
            byte[] tb = ts.getBytes(this.bf_charset);
            tb[0] = 126;
            tb[tb.length - 1] = 126;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("[" + session.getAttribute("token") + "] send package :" + ByteUtil.toHexString((byte[])tb));
            }
            session.write(tb);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closed(Session session) throws Exception {
        this.logger.info("tcp closed " + session);
        try {
            Online online;
            String tokenid;
            if (session != null && !StringUtil.isEmptys((String)(tokenid = session.getAttribute("token") + "")) && (online = this.onlineService.getOnlineByToken(tokenid)) != null) {
                Object o = online.getO();
                Map po = null;
                if (o instanceof Map) {
                    po = (Map)o;
                    List list = (List)po.get(OnlineDataField._online_cs_session);
                    if (list != null) {
                        list.remove(session);
                    }
                    if (list == null || list.size() == 0) {
                        online.resetStatus(Type.tcp);
                    }
                }
            }
        }
        catch (Throwable e) {
            this.logger.error("closed session error\uff1a" + ExceptionUtil.getCausedBySrcMsg((Throwable)e), e);
        }
        finally {
            session.close();
        }
    }

    public void opened(Session session) throws Exception {
        this.logger.info("tcp opened " + session);
        if (session == null) {
            return;
        }
        if (null == session.getAttribute("binary")) {
            session.setAttribute("binary", (Object)true);
        }
        try {
            session.setAttribute(this.KEY_READ_BUFFER, (Object)new StringBuffer());
            session.setAttribute(this.KEY_READ_Queue, new LinkedBlockingQueue());
            HashMap<String, Object> rtn = new HashMap<String, Object>();
            rtn.put("status", 1);
            rtn.put("name", "massplat_leliao");
            rtn.put("version", "1.0.1");
            rtn.put("type", 1);
            rtn.put("binary", true);
            byte[] rtn1 = JSONUtil.parserToStr(rtn).toString().getBytes(this.charset);
            byte[] command = ByteUtil.int2bytes((int)36864, (int)2);
            this.send(session, rtn1, command);
        }
        catch (Throwable e) {
            this.logger.error("opened session error\uff1a" + ExceptionUtil.getCausedBySrcMsg((Throwable)e), e);
        }
    }

    public void idled(Session session) throws Exception {
        if (session != null && StringUtil.isEmptys((String)(session.getAttribute("token") + ""))) {
            this.logger.info("Close invalid connection:" + session);
            session.close();
        }
    }

    public void sent(Session session) throws Exception {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("tcp sent");
        }
        if (session.getAttribute(this.KEY_SENT_INFO) == null) {
            session.setAttribute(this.KEY_SENT_INFO, (Object)0);
        } else {
            int info = (Integer)session.getAttribute(this.KEY_SENT_INFO);
            if (info > this.anonymous_count && StringUtil.isEmptys((String)(session.getAttribute("token") + ""))) {
                this.logger.info("Close invalid connection:" + session);
                session.close();
            }
            if (info > 900000000) {
                info = 0;
            }
            session.setAttribute(this.KEY_SENT_INFO, (Object)(1 + info));
        }
    }

    public int getReaderIdleCount() {
        return 0;
    }

    static /* synthetic */ boolean access$100(ServerHandler x0) {
        return x0.runReceived;
    }

    static /* synthetic */ String access$200(ServerHandler x0) {
        return x0.bf_charset;
    }

    static /* synthetic */ String access$300(ServerHandler x0) {
        return x0.universal_head;
    }

    static /* synthetic */ Dictionary access$500(ServerHandler x0) {
        return x0.props;
    }

    static /* synthetic */ OnlineService access$600(ServerHandler x0) {
        return x0.onlineService;
    }

    static /* synthetic */ String access$700(ServerHandler x0) {
        return x0.universal_answer;
    }

    class asynchronismction
    implements Runnable {
        Map<Object, Object> rtn = null;
        Map<Object, Object> per = null;
        Session session = null;

        public asynchronismction(Session session, Map<Object, Object> per) {
            this.session = session;
            this.per = per;
        }

        @Override
        public void run() {
            Object command_id = MapUtil.get(this.per, (String)"data.command_id");
            Object command_serial = MapUtil.get(this.per, (String)"data.command_serial");
            try {
                long startTime = 0L;
                if (ServerHandler.this.logger.isDebugEnabled()) {
                    startTime = System.currentTimeMillis();
                    try {
                        ServerHandler.this.logger.debug(Thread.currentThread().getName() + "| per:" + this.per);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (this.per == null) {
                    this.per = new HashMap<Object, Object>();
                }
                this.per.put("client_type", Type.tcp);
                this.rtn = ServerHandler.this.actionService.request(this.per);
                if (ServerHandler.this.logger.isDebugEnabled()) {
                    ServerHandler.this.logger.debug(Thread.currentThread().getName() + "," + (System.currentTimeMillis() - startTime) + "|per:" + this.per + ", rtn:" + this.rtn);
                }
            }
            catch (Throwable ex) {
                ServerHandler.this.logger.error("received error\uff1a" + ExceptionUtil.getCausedBySrcMsg((Throwable)ex), ex);
                this.rtn = new HashMap<Object, Object>();
                this.rtn.put("status", -110);
                this.rtn.put("excepion", ExceptionUtil.getCausedBySrcMsg((Throwable)ex));
            }
            Object data = this.rtn.get("data");
            if (data instanceof Map) {
                this.rtn.put("return_info", JSONUtil.parserToStr((Map)((Map)data)));
            } else if (data instanceof List) {
                this.rtn.put("return_info", JSONUtil.parserToStr((List)((List)data)));
            } else {
                this.rtn.put("return_info", "{}");
            }
            this.rtn.put("command_id", command_id);
            this.rtn.put("command_serial", command_serial);
            byte[] rtn1 = ServerHandler.this.bytesService.encoded(null, (Object)ServerHandler.this.universal_reply, this.rtn);
            byte[] command = ByteUtil.int2bytes((int)36864, (int)2);
            ServerHandler.this.send(this.session, rtn1, command);
        }
    }

    class receivedRunable
    implements Runnable {
        StringBuffer receiveSb;
        LinkedBlockingQueue<Object> receivedQueue;
        Session session;
        char start = (char)126;
        char end = (char)126;
        int start_i = -1;

        public receivedRunable(StringBuffer receiveSb, LinkedBlockingQueue<Object> receivedQueue, Session session) {
            this.receiveSb = receiveSb;
            this.receivedQueue = receivedQueue;
            this.session = session;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            if (ServerHandler.access$000(ServerHandler.this).isDebugEnabled()) {
                ServerHandler.access$000(ServerHandler.this).debug("running receivedTh ....runReceived=" + ServerHandler.access$100(ServerHandler.this));
            }
            try {
                while (true) lbl-1000:
                // 8 sources

                {
                    if (!ServerHandler.access$100(ServerHandler.this)) {
                        if (ServerHandler.access$000(ServerHandler.this).isDebugEnabled() == false) return;
                        ServerHandler.access$000(ServerHandler.this).debug("stop receivedTh ....runReceived=" + ServerHandler.access$100(ServerHandler.this));
                        return;
                    }
                    if (ServerHandler.access$000(ServerHandler.this).isDebugEnabled()) {
                        ServerHandler.access$000(ServerHandler.this).debug(" receivedTh running");
                    }
                    this.start_i = this.receiveSb.indexOf(this.start + "");
                    if (this.start_i == -1) {
                        this.receivedQueue.take();
                        continue;
                    }
                    end_i = this.receiveSb.indexOf(this.end + "", this.start_i + 1);
                    if (end_i == -1) {
                        this.receivedQueue.take();
                        continue;
                    }
                    ++end_i;
                    try {
                        d = new HashMap<K, V>();
                        t_packet = this.receiveSb.substring(this.start_i, end_i).getBytes(ServerHandler.access$200(ServerHandler.this));
                        if (end_i == 2) {
                            this.receiveSb.deleteCharAt(0);
                        }
                        if (ServerHandler.access$000(ServerHandler.this).isDebugEnabled() && this.start_i > 1) {
                            ServerHandler.access$000(ServerHandler.this).debug("received package error [0," + this.start_i + "] :" + ByteUtil.toHexString((byte[])this.receiveSb.substring(0, this.start_i).getBytes(ServerHandler.access$200(ServerHandler.this))));
                        }
                        if (ServerHandler.access$000(ServerHandler.this).isDebugEnabled()) {
                            ServerHandler.access$000(ServerHandler.this).debug("received package[" + this.start_i + "," + end_i + "] :" + ByteUtil.toHexString((byte[])t_packet));
                        }
                        packet = new byte[t_packet.length - 2];
                        System.arraycopy(t_packet, 1, packet, 0, packet.length);
                        ts = new String(packet, ServerHandler.access$200(ServerHandler.this));
                        ts = ts.replace(new String(new byte[]{125, 2}, ServerHandler.access$200(ServerHandler.this)), new String(new byte[]{126}, ServerHandler.access$200(ServerHandler.this)));
                        ts = ts.replace(new String(new byte[]{125, 1}, ServerHandler.access$200(ServerHandler.this)), new String(new byte[]{125}, ServerHandler.access$200(ServerHandler.this)));
                        packet = ts.getBytes(ServerHandler.access$200(ServerHandler.this));
                        if (Crc.crc((byte[])packet, (int)0, (int)(packet.length - 1)) != packet[packet.length - 1]) {
                            this.receiveSb.delete(0, end_i - 1);
                            ServerHandler.access$000(ServerHandler.this).error("CRC error,error data:" + ByteUtil.toHexString((byte[])packet));
                        }
                        sr = ServerHandler.access$400(ServerHandler.this).decode(packet, (Object)ServerHandler.access$300(ServerHandler.this), d);
                        d.remove(BytesRuleField.sys_packet_index);
                        if (ServerHandler.access$000(ServerHandler.this).isDebugEnabled()) {
                            ServerHandler.access$000(ServerHandler.this).debug("[" + d.get("command_id") + "] decode head:" + d + ", sr=" + sr);
                            ServerHandler.access$000(ServerHandler.this).debug("[" + d.get("command_id") + "] data:" + ByteUtil.toHexString((byte[])((byte[])d.get("package_data"))));
                        }
                        if (StringUtil.isEmptys((String)(msg_type_regex = ServerHandler.access$500(ServerHandler.this).get("msg.type." + d.get("command_id")) + ""))) {
                            throw new RuntimeException("not found command ID [" + d.get("command_id") + "] ");
                        }
                        regex = msg_type_regex.startsWith("{") != false ? JSONUtil.parserStrToMap((String)msg_type_regex) : (msg_type_regex.startsWith("[") != false ? JSONUtil.parserStrToList((String)msg_type_regex) : msg_type_regex);
                        data = (byte[])d.get("package_data");
                        sr = ServerHandler.access$400(ServerHandler.this).decode(data, regex, d);
                        d.remove(BytesRuleField.sys_packet_index);
                        if (ServerHandler.access$000(ServerHandler.this).isDebugEnabled()) {
                            ServerHandler.access$000(ServerHandler.this).debug("[" + d.get("command_id") + "] decode data:" + d + ", sr=" + sr);
                        }
                        if (MapUtil.getInt(d, (String)"command_id") == 256) {
                            token_id = MapUtil.getString(d, (String)"token_id");
                            tag = MapUtil.getString(d, (String)"tag");
                            if (StringUtil.isEmptys((String)(this.session.getAttribute("token") + ""))) {
                                if (StringUtil.isEmptys((String)token_id)) {
                                    this.session.close();
                                    return;
                                }
                                online = ServerHandler.access$600(ServerHandler.this).getOnlineByToken(token_id);
                                if (online == null) {
                                    this.session.close();
                                    return;
                                }
                                o = online.getO();
                                po = null;
                                if (o instanceof Map) {
                                    po = (ConcurrentHashMap<String, ArrayList<E>>)o;
                                } else {
                                    po = new ConcurrentHashMap<String, ArrayList<E>>();
                                    online.setO(po);
                                }
                                list = (ArrayList<Session>)po.get(OnlineDataField._online_cs_session);
                                if (list == null) {
                                    list = new ArrayList<Session>();
                                    po.put(OnlineDataField._online_cs_session, list);
                                }
                                this.session.setAttribute("token", (Object)token_id);
                                this.session.setAttribute("tag", (Object)tag);
                                list.add(this.session);
                                online.setStatus(Type.tcp);
                            } else if (!this.session.getAttribute("token").equals(token_id)) {
                                this.session.close();
                                return;
                            }
                        } else if (MapUtil.getInt(d, (String)"command_id") == 1) {
                            this.receiveSb.delete(0, end_i);
                        }
                        per = new HashMap<Object, Object>();
                        per.put("tokenid", this.session.getAttribute("token"));
                        per.put("tag", this.session.getAttribute("tag"));
                        per.put("modulename", ServerHandler.access$500(ServerHandler.this).get("msg.modulename." + d.get("command_id")));
                        per.put("operation", ServerHandler.access$500(ServerHandler.this).get("msg.operation." + d.get("command_id")));
                        per.put("data", d);
                        if (ServerHandler.access$000(ServerHandler.this).isDebugEnabled()) {
                            ServerHandler.access$000(ServerHandler.this).debug("call :" + per);
                        }
                        if (MapUtil.getInt(d, (String)"command_id") != 256) {
                            new Thread((Runnable)new asynchronismction(this.session, per), asynchronismction.class.getName()).start();
                        }
                        rtn1 = ServerHandler.access$400(ServerHandler.this).encoded(null, (Object)ServerHandler.access$700(ServerHandler.this), d);
                        d.remove(BytesRuleField.sys_packet_index);
                        command = ByteUtil.int2bytes((int)36865, (int)2);
                        ServerHandler.access$800(ServerHandler.this, this.session, rtn1, command);
                        this.receiveSb.delete(0, end_i);
                    }
                    catch (Throwable e) {
                        ServerHandler.access$000(ServerHandler.this).error(e.getMessage(), e);
                        this.receiveSb.delete(0, end_i - 1);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable e) {
                ServerHandler.access$000(ServerHandler.this).error(e.getMessage(), e);
            }
            ** GOTO lbl-1000
        }
    }
}

