/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.service.action.tcp.bytes;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Dictionary;
import org.oiue.service.action.api.ActionService;
import org.oiue.service.action.tcp.bytes.ServerHandler;
import org.oiue.service.bytes.api.BytesService;
import org.oiue.service.log.LogService;
import org.oiue.service.log.Logger;
import org.oiue.service.online.OnlineService;
import org.oiue.service.osgi.FrameActivator;
import org.oiue.service.osgi.MulitServiceTrackerCustomizer;
import org.oiue.service.tcp.Handler;
import org.oiue.service.tcp.TcpService;

public class Activator
extends FrameActivator {
    public void start() throws Exception {
        this.start(new MulitServiceTrackerCustomizer(){
            private SocketAddress address;
            private TcpService tcpService;
            private ServerHandler handler;
            private Logger logger;

            public void removedService() {
                if (this.tcpService != null && this.address != null) {
                    this.tcpService.unregister(this.address);
                }
                this.address = null;
                this.tcpService = null;
            }

            public void addingService() {
                LogService logService = (LogService)Activator.this.getService(LogService.class);
                ActionService actionService = (ActionService)Activator.this.getService(ActionService.class);
                OnlineService onlineService = (OnlineService)Activator.this.getService(OnlineService.class);
                BytesService bytesService = (BytesService)Activator.this.getService(BytesService.class);
                this.tcpService = (TcpService)Activator.this.getService(TcpService.class);
                this.logger = logService.getLogger(((Object)((Object)this)).getClass());
                this.handler = new ServerHandler(logService, actionService, onlineService, bytesService);
            }

            public void updated(Dictionary<String, ?> props) {
                try {
                    if (this.address != null) {
                        this.tcpService.unregister(this.address);
                    }
                    int listenPort = Integer.parseInt(props.get("listenPort").toString());
                    String listenAddress = props.get("listenAddress").toString();
                    int idleTime = Integer.parseInt(props.get("idleTime").toString());
                    String charset = props.get("charset").toString();
                    this.address = new InetSocketAddress(listenAddress, listenPort);
                    this.tcpService.register(this.address, (Handler)this.handler, true, idleTime, charset);
                    this.handler.updated(props);
                }
                catch (Exception ex) {
                    this.logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }, new Class[]{LogService.class, ActionService.class, OnlineService.class, BytesService.class, TcpService.class});
    }

    public void stop() throws Exception {
    }
}

