/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.service.action.http.services;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.oiue.service.action.api.ActionService;
import org.oiue.service.action.http.services.ParseHtml;
import org.oiue.service.log.LogService;
import org.oiue.service.log.Logger;
import org.oiue.tools.exception.ExceptionUtil;
import org.oiue.tools.json.JSONUtil;
import org.oiue.tools.map.MapUtil;
import org.oiue.tools.string.StringUtil;

public class PostServlet
extends HttpServlet {
    private static final long serialVersionUID = -6327347468651806863L;
    private ActionService actionService;
    private Logger logger;
    private Dictionary properties;
    private boolean refererGrant = false;

    public PostServlet(ActionService actionService, LogService logService) {
        this.logger = logService.getLogger(((Object)((Object)this)).getClass());
        this.actionService = actionService;
    }

    public void updated(Dictionary props) {
        this.logger.info("updateConfigure", new Object[0]);
        this.properties = props;
        String c_referer = this.properties.get("Referer") + "";
        if (!StringUtil.isEmptys((String)c_referer)) {
            this.refererGrant = true;
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HashMap<String, Object> per = null;
        Map<String, Object> rtn = null;
        String perStr = null;
        String callBackFn = "";
        boolean authInHeader = false;
        try {
            try {
                String referer;
                String c_referer = this.properties.get("Referer") + "";
                if (this.refererGrant && ((referer = req.getHeader("Referer")) == null || !referer.trim().startsWith(c_referer))) {
                    throw new RuntimeException("\u53d1\u8d77\u5730\u5740\uff1a" + referer + ",\u7ad9\u70b9\u5730\u5740\uff1a" + c_referer);
                }
            }
            catch (Throwable e) {
                throw new RuntimeException("\u975e\u6cd5\u7684\u8bf7\u6c42\u6e90\u5730\u5740\uff01" + e.getMessage(), e);
            }
            try {
                String token;
                Map data;
                perStr = req.getParameter("parameter");
                try {
                    if (StringUtil.isEmptys((String)perStr)) {
                        StringBuffer jb = new StringBuffer();
                        String line = null;
                        BufferedReader reader = req.getReader();
                        while ((line = reader.readLine()) != null) {
                            jb.append(line);
                        }
                        perStr = jb.toString();
                    }
                }
                catch (Exception jb) {
                    // empty catch block
                }
                if (!StringUtil.isEmptys((String)perStr)) {
                    per = JSONUtil.parserStrToMap((String)perStr);
                }
                if ((per == null || per.size() == 0) && (data = ParseHtml.parseRequest(req)) != null && data.size() > 0) {
                    per = new HashMap();
                    per.put("token", data.remove("token"));
                    per.put("data", data);
                }
                if (per == null) {
                    per = new HashMap<String, Object>();
                    per.put("data", new HashMap());
                }
                if (!StringUtil.isEmptys((String)(token = req.getHeader("Authorization")))) {
                    int index = token.indexOf(" ");
                    if (index > 0) {
                        token = token.substring(index + 1);
                    }
                    authInHeader = true;
                    per.put("token", token);
                }
            }
            catch (Throwable e) {
                throw new RuntimeException("\u53c2\u6570\u683c\u5f0f\u4e0d\u6b63\u786e\uff01 /n " + perStr + " /n " + per, e);
            }
            String path = req.getPathInfo();
            String[] paths = path.split("/");
            if (paths.length < 3) {
                throw new RuntimeException("\u8bf7\u6c42\u5730\u5740\u683c\u5f0f\u4e0d\u6b63\u786e\uff08/version/modulename/operation\uff09\uff01 /n " + path);
            }
            per.put("version", paths[1]);
            per.put("modulename", paths[2]);
            per.put("operation", paths[3]);
            try {
                per.put("client_ip", this.getIpAddr(req));
            }
            catch (Exception e) {
                this.logger.error("\u83b7\u53d6\u5ba2\u6237\u7aefIP\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            }
            try {
                per.put("domain", req.getServerName());
            }
            catch (Exception e) {
                this.logger.error("\u83b7\u53d6\u8bbf\u95ee\u57df\u540d\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            }
            try {
                if ("login".equals(MapUtil.getString(per, (String)"modulename"))) {
                    HttpSession session = req.getSession(true);
                    per.put("Login_Image_Code", session.getAttribute("Login_Image_Code"));
                }
            }
            catch (Throwable e) {
                this.logger.error("\u5904\u7406\u767b\u5f55\u6a21\u5757\u9a8c\u8bc1\u7801\u5f02\u5e38\uff1a" + e.getMessage(), e);
            }
            try {
                callBackFn = per.get("callback") + "";
            }
            catch (Throwable e) {
                this.logger.error("\u5904\u7406Jsonp\u56de\u8c03\u5f02\u5e38\uff1a" + e.getMessage(), e);
            }
            long header = req.getDateHeader("If-Modified-Since");
            String previousToken = req.getHeader("If-None-Match");
            rtn = this.actionService.request(per);
        }
        catch (Throwable ex) {
            this.logger.error(ExceptionUtil.getCausedBySrcMsg((Throwable)ex), ex);
            rtn = new HashMap<String, Object>();
            rtn.put("status", -110);
            rtn.put("excepion", ExceptionUtil.getCausedBySrcMsg((Throwable)ex));
        }
        try {
            resp.setContentType("application/json");
            resp.setHeader("Access-Control-Allow-Origin", "*");
            resp.setHeader("Access-Control-Allow-Methods", "PUT, GET, POST, DELETE, OPTIONS");
            if (authInHeader) {
                resp.setHeader("Authorization", rtn.remove("token") + "");
            }
            resp.setCharacterEncoding("UTF-8");
            byte[] bytes = (StringUtil.isEmptys((String)callBackFn) ? JSONUtil.parserToStr(rtn) : callBackFn + "(" + JSONUtil.parserToStr(rtn) + ")").getBytes();
            resp.setContentLength(bytes.length);
            ServletOutputStream out = resp.getOutputStream();
            out.write(bytes);
            out.flush();
            out.close();
        }
        catch (Throwable e) {
            this.logger.error("\u8fd4\u56de\u6570\u636e\u5199\u5165\u5f02\u5e38\uff1a" + e.getMessage(), e);
        }
    }

    public boolean setRespHeaderCache(long adddays, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("myExpire", (Object)adddays);
        long adddaysM = adddays * 1000L;
        String maxAgeDirective = "max-age=" + adddays;
        response.setHeader("Cache-Control", maxAgeDirective);
        response.setStatus(200);
        response.addDateHeader("Last-Modified", System.currentTimeMillis());
        response.addDateHeader("Expires", System.currentTimeMillis() + adddaysM);
        return true;
    }

    public String getIpAddr(HttpServletRequest request) {
        String[] ips;
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if ((ips = ip.split(",")).length > 0) {
            ip = ips[0];
        }
        return ip;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }
}

