/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.service.action.http.services;

import java.io.IOException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.oiue.service.action.api.ActionService;
import org.oiue.service.action.http.services.ParseHtml;
import org.oiue.service.log.LogService;
import org.oiue.service.log.Logger;
import org.oiue.tools.exception.ExceptionUtil;
import org.oiue.tools.json.JSONUtil;
import org.oiue.tools.map.MapUtil;
import org.oiue.tools.string.StringUtil;

public class PostServlet
extends HttpServlet {
    private static final long serialVersionUID = -6327347468651806863L;
    private ActionService actionService;
    private Logger logger;
    private Dictionary properties;
    private boolean refererGrant = false;

    public PostServlet(ActionService actionService, LogService logService) {
        this.logger = logService.getLogger(((Object)((Object)this)).getClass());
        this.actionService = actionService;
    }

    public void updated(Dictionary props) {
        this.logger.info("updateConfigure");
        this.properties = props;
        String c_referer = this.properties.get("Referer") + "";
        if (!StringUtil.isEmptys((String)c_referer)) {
            this.refererGrant = true;
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map per = null;
        Map<String, Object> rtn = null;
        String perStr = null;
        String callBackFn = "";
        try {
            try {
                String referer;
                String c_referer = this.properties.get("Referer") + "";
                if (this.refererGrant && ((referer = req.getHeader("Referer")) == null || !referer.trim().startsWith(c_referer))) {
                    throw new RuntimeException("\u53d1\u8d77\u5730\u5740\uff1a" + referer + ",\u7ad9\u70b9\u5730\u5740\uff1a" + c_referer);
                }
            }
            catch (Throwable e) {
                throw new RuntimeException("\u975e\u6cd5\u7684\u8bf7\u6c42\u6e90\u5730\u5740\uff01" + e.getMessage(), e);
            }
            try {
                perStr = req.getParameter("parameter");
                if (!StringUtil.isEmptys((String)perStr)) {
                    per = JSONUtil.parserStrToMap((String)perStr);
                }
                if (per == null || per.size() == 0) {
                    per = ParseHtml.parseRequest(req);
                }
            }
            catch (Throwable e) {
                throw new RuntimeException("\u53c2\u6570\u683c\u5f0f\u4e0d\u6b63\u786e\uff01 /n " + perStr + " /n " + per, e);
            }
            String path = req.getPathInfo();
            String[] paths = path.split("/");
            per.put("version", paths[1]);
            per.put("modulename", paths[2]);
            per.put("operation", paths[3]);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("per:" + per);
            }
            try {
                per.put("client_ip", this.getIpAddr(req));
                if ("login".equals(MapUtil.getString((Map)per, (String)"modulename"))) {
                    HttpSession session = req.getSession(true);
                    per.put("Login_Image_Code", session.getAttribute("Login_Image_Code"));
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                callBackFn = per.get("callback") + "";
            }
            catch (Throwable e) {
                // empty catch block
            }
            long start = 0L;
            if (this.logger.isDebugEnabled()) {
                start = System.currentTimeMillis();
            }
            rtn = this.actionService.request(per);
            if (this.logger.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                this.logger.debug("action response time:" + (end - start));
            }
        }
        catch (Throwable ex) {
            this.logger.error("", ex);
            rtn = new HashMap<String, Object>();
            rtn.put("status", -110);
            rtn.put("excepion", ExceptionUtil.getCausedBySrcMsg((Throwable)ex));
        }
        try {
            resp.setContentType("application/json");
            resp.setCharacterEncoding("UTF-8");
            byte[] bytes = (StringUtil.isEmptys((String)callBackFn) ? JSONUtil.parserToStr(rtn) : callBackFn + "(" + JSONUtil.parserToStr(rtn) + ")").getBytes();
            resp.setContentLength(bytes.length);
            ServletOutputStream out = resp.getOutputStream();
            out.write(bytes);
            out.flush();
            out.close();
        }
        catch (Throwable e) {
            this.logger.error("" + e.getMessage(), e);
        }
    }

    public String getIpAddr(HttpServletRequest request) {
        String[] ips;
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if ((ips = ip.split(",")).length > 0) {
            ip = ips[0];
        }
        return ip;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }
}

