/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.service.action.http.resource;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.oiue.service.action.http.resource.Visit;
import org.oiue.service.cache.CacheServiceManager;
import org.oiue.service.log.LogService;
import org.oiue.service.log.Logger;
import org.oiue.service.odp.base.FactoryService;
import org.oiue.service.odp.res.api.IResource;
import org.oiue.service.template.TemplateService;

public class TemplateVisit
implements Visit {
    private static final long serialVersionUID = 1L;
    private FactoryService factoryService;
    private CacheServiceManager cacheService;
    private TemplateService templateService;
    private Logger logger;

    public TemplateVisit(FactoryService factoryService, CacheServiceManager cacheService, TemplateService templateService, LogService logService) {
        this.factoryService = factoryService;
        this.cacheService = cacheService;
        this.templateService = templateService;
        this.logger = logService.getLogger(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String domain = (String)request.getAttribute("domain");
        String resName = (String)request.getAttribute("resName");
        String resNameK = domain + ":" + resName;
        response.setCharacterEncoding("UTF-8");
        if (this.cacheService.contains("system_template", new String[]{resNameK})) {
            List attributes;
            HashMap<String, Object> map;
            IResource iresource;
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            parameter.put("token", request.getParameter("token"));
            parameter.put("user_name", request.getAttribute("user_name"));
            parameter.put("login_name", request.getAttribute("login_name"));
            Map menu = (Map)this.cacheService.get("system_menu", resNameK);
            HashMap events = new HashMap();
            try {
                iresource = (IResource)this.factoryService.getBmo(IResource.class.getName());
                map = new HashMap<String, Object>();
                map.put("model", "");
                map.put("domain", domain);
                map.put("user_id", request.getAttribute("user_id"));
                attributes = (List)iresource.callEvent("fm_system_query_attribute", null, map);
                if (attributes != null) {
                    for (Map attribute : attributes) {
                        if ("string".equals(attribute.get("type"))) {
                            parameter.put((String)attribute.get("name"), attribute.get("value"));
                            continue;
                        }
                        if (!"event_id".equals(attribute.get("type"))) continue;
                        events.put(attribute.get("name"), attribute.get("value"));
                    }
                }
            }
            catch (Throwable e) {
                this.logger.error(e.getMessage(), e);
            }
            try {
                iresource = (IResource)this.factoryService.getBmo(IResource.class.getName());
                map = new HashMap();
                map.put("model", resName);
                map.put("domain", domain);
                map.put("user_id", request.getAttribute("user_id"));
                attributes = (List)iresource.callEvent("fm_system_query_attribute", null, map);
                if (attributes != null) {
                    for (Map attribute : attributes) {
                        if ("string".equals(attribute.get("type"))) {
                            parameter.put((String)attribute.get("name"), attribute.get("value"));
                            continue;
                        }
                        if (!"event_id".equals(attribute.get("type"))) continue;
                        events.put(attribute.get("name"), attribute.get("value"));
                    }
                }
            }
            catch (Throwable e) {
                this.logger.error(e.getMessage(), e);
            }
            try {
                iresource = (IResource)this.factoryService.getBmo(IResource.class.getName());
                map = new HashMap();
                map.put("model", resName);
                map.put("domain", domain);
                map.put("user_id", request.getAttribute("user_id"));
                attributes = (List)iresource.callEvent("fm_system_query_r_attribute", null, map);
                if (attributes != null) {
                    for (Map attribute : attributes) {
                        if ("string".equals(attribute.get("type"))) {
                            parameter.put((String)attribute.get("name"), attribute.get("value"));
                            continue;
                        }
                        if (!"event_id".equals(attribute.get("type"))) continue;
                        events.put(attribute.get("name"), attribute.get("value"));
                    }
                }
            }
            catch (Throwable e) {
                this.logger.error(e.getMessage(), e);
            }
            try {
                LinkedList tempList = new LinkedList();
                tempList.addAll(events.entrySet());
                ListIterator itor = tempList.listIterator();
                Map.Entry entry = null;
                while (itor.hasNext()) {
                    entry = (Map.Entry)itor.next();
                    IResource iresource2 = (IResource)this.factoryService.getBmo(IResource.class.getName());
                    HashMap<String, Object> map2 = new HashMap<String, Object>();
                    map2.put("model", resName);
                    map2.put("domain", domain);
                    map2.put("user_id", request.getAttribute("user_id"));
                    if (menu != null) {
                        map2.put("menu_id", menu.get("menu_id"));
                    }
                    parameter.put((String)entry.getKey(), iresource2.callEvent(entry.getValue() + "", null, map2));
                }
            }
            catch (Throwable e) {
                this.logger.error(e.getMessage(), e);
            }
            try {
                parameter.put("resName", resName);
                this.templateService.render(request, response, parameter);
            }
            catch (Throwable e) {
                this.logger.error(e.getMessage(), e);
            }
            return;
        }
        this.logger.warn("\u627e\u4e0d\u5230\u6a21\u677f\u914d\u7f6e\uff01", new Object[0]);
        this.templateService.render(request, response, new HashMap());
    }
}

