/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.service.action.http.resource;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Dictionary;
import java.util.ResourceBundle;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.oiue.service.action.http.resource.FileVisit;
import org.oiue.service.action.http.resource.TemplateVisit;
import org.oiue.service.action.http.resource.Visit;
import org.oiue.service.cache.CacheServiceManager;
import org.oiue.service.log.LogService;
import org.oiue.service.log.Logger;
import org.oiue.service.odp.base.FactoryService;
import org.oiue.service.online.OnlineService;
import org.oiue.service.template.TemplateService;
import org.oiue.tools.string.StringUtil;
import org.osgi.service.http.HttpService;

public class ResourceServlet
implements Servlet {
    private static final String LSTRING_FILE = "javax.servlet.LocalStrings";
    private ResourceBundle lStrings = ResourceBundle.getBundle("javax.servlet.LocalStrings");
    private ServletConfig config;
    private TemplateService templateService;
    private FactoryService factoryService;
    private CacheServiceManager cacheService;
    private Logger logger;
    private LogService logService;

    public ResourceServlet(CacheServiceManager cacheService, OnlineService onlineService, FactoryService factoryService, LogService logService, TemplateService templateService, HttpService httpService) {
        this.factoryService = factoryService;
        this.templateService = templateService;
        this.cacheService = cacheService;
        this.logger = logService.getLogger(this.getClass());
        this.logService = logService;
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        try {
            if (req instanceof ServletRequestWrapper) {
                this.service(((ServletRequestWrapper)req).getRequest(), res);
            } else {
                this.service((HttpServletRequest)req, (HttpServletResponse)res);
            }
        }
        catch (Throwable e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            Visit fv = null;
            try {
                String type = (String)request.getAttribute("type");
                fv = !StringUtil.isEmptys((String)type) ? new TemplateVisit(this.factoryService, this.cacheService, this.templateService, this.logService) : new FileVisit(this.logService);
                fv.visit(request, response);
            }
            catch (FileNotFoundException e) {
                fv = new FileVisit(this.logService);
                request.setAttribute("domain_path", (Object)"/comm");
                request.setAttribute("resName", (Object)"notfound.html");
                fv.visit(request, response);
            }
        }
        catch (Throwable e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    public void init(ServletConfig config) throws ServletException {
        this.config = config;
    }

    public String getServletInfo() {
        return "";
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public void destroy() {
    }

    public ServletContext getServletContext() {
        ServletConfig sc = this.getServletConfig();
        if (sc == null) {
            throw new IllegalStateException(this.lStrings.getString("err.servlet_config_not_initialized"));
        }
        return sc.getServletContext();
    }

    public void updated(Dictionary<String, ?> props) {
    }
}

