/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.service.action.http.resource;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.oiue.service.action.http.resource.MimeTypes;
import org.oiue.service.log.LogService;
import org.oiue.service.log.Logger;
import org.oiue.service.template.TemplateService;
import org.osgi.service.http.HttpContext;

public class ResourceContext
implements HttpContext {
    HttpContext base;
    Logger logger;
    TemplateService templateService;
    private String root_path;

    public ResourceContext(TemplateService templateService, LogService logService, HttpContext base, String root_path) {
        this.logger = logService.getLogger(this.getClass());
        this.base = base;
        this.templateService = templateService;
        this.root_path = root_path;
    }

    public String getMimeType(String name) {
        try {
            String type = this.base.getMimeType(name);
            if (type == null) {
                type = MimeTypes.get().getByFile(name);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ManagedContext getMimeType:" + name + ":" + type, new Object[0]);
            }
            return type;
        }
        catch (Throwable e) {
            this.logger.error(e.getMessage(), e);
            return null;
        }
    }

    public URL getResource(String path) {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ManagedContext getResource:" + path, new Object[0]);
            }
            if (path != null) {
                path = path.trim();
            }
            URL url = new File(this.root_path + path).toURI().toURL();
            return url;
        }
        catch (Throwable e) {
            this.logger.error(e.getMessage(), e);
            return null;
        }
    }

    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            if (request instanceof ServletRequestWrapper) {
                ServletRequestWrapper srw = (ServletRequestWrapper)request;
                Request req = (Request)srw.getRequest();
                String path = req.getPathInfo();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("ManagedContext handleSecurity:" + path, new Object[0]);
                }
                if ("/".equals(path)) {
                    response.sendRedirect(path + (path.endsWith("/") ? "index.html" : "/index.html"));
                    return false;
                }
            }
        }
        catch (Throwable e) {
            this.logger.error(e.getMessage(), e);
        }
        return true;
    }
}

