/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.service.action.http.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.oiue.service.action.http.resource.Visit;
import org.oiue.service.log.LogService;
import org.oiue.service.log.Logger;

public class FileVisit
implements Visit {
    private static final long serialVersionUID = 1L;
    private Logger logger;

    public FileVisit(LogService logService) {
        this.logger = logService.getLogger(this.getClass());
    }

    @Override
    public void visit(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String domain_path = (String)request.getAttribute("domain_path");
        String resName = (String)request.getAttribute("resName");
        resName = resName.startsWith("/") ? resName : "/" + resName;
        ServletContext httpContext = (ServletContext)request.getAttribute("httpContext");
        URL url = httpContext.getResource(domain_path + resName);
        if (url == null) {
            response.sendError(404);
        } else {
            this.handle(request, response, url, resName);
        }
    }

    private void handle(HttpServletRequest req, HttpServletResponse res, URL url, String resName) throws IOException {
        long lastModified = this.getLastModified(url);
        if (lastModified != 0L) {
            res.setDateHeader("Last-Modified", lastModified);
        }
        if (!this.resourceModified(lastModified, req.getDateHeader("If-Modified-Since"))) {
            res.setStatus(304);
        } else {
            this.copyResource(url, res);
        }
    }

    private long getLastModified(URL url) {
        long lastModified = 0L;
        try {
            URLConnection conn = url.openConnection();
            lastModified = conn.getLastModified();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            File f;
            String filepath;
            if (lastModified == 0L && (filepath = url.getPath()) != null && (f = new File(filepath)).exists()) {
                lastModified = f.lastModified();
            }
        }
        catch (Throwable e) {
            this.logger.error(e.getMessage(), e);
        }
        return lastModified;
    }

    private boolean resourceModified(long resTimestamp, long modSince) {
        return (resTimestamp /= 1000L) == 0L || (modSince /= 1000L) == -1L || resTimestamp > modSince;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResource(URL url, HttpServletResponse res) throws IOException {
        URLConnection conn = null;
        OutputStream os = null;
        InputStream is = null;
        try {
            int n;
            conn = url.openConnection();
            is = conn.getInputStream();
            os = res.getOutputStream();
            int len = this.getContentLength(conn);
            if (len >= 0) {
                res.setContentLength(len);
            }
            byte[] buf = new byte[1024];
            while ((n = is.read(buf, 0, buf.length)) >= 0) {
                os.write(buf, 0, n);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    private int getContentLength(URLConnection conn) {
        File f;
        String path;
        int length = -1;
        length = conn.getContentLength();
        if (length < 0 && (path = conn.getURL().getPath()) != null && (f = new File(path)).length() < Integer.MAX_VALUE) {
            length = (int)f.length();
        }
        return length;
    }
}

