/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.service.action.http.resource;

import java.io.IOException;
import java.util.Dictionary;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.oiue.service.action.http.resource.ResourceContext;
import org.oiue.service.action.http.resource.ResourceServlet;
import org.oiue.service.cache.CacheServiceManager;
import org.oiue.service.log.LogService;
import org.oiue.service.log.Logger;
import org.oiue.service.odp.base.FactoryService;
import org.oiue.service.online.OnlineService;
import org.oiue.service.osgi.FrameActivator;
import org.oiue.service.osgi.MulitServiceTrackerCustomizer;
import org.oiue.service.template.TemplateService;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;

public class Activator
extends FrameActivator {
    public void start() throws Exception {
        this.start(new MulitServiceTrackerCustomizer(){
            private String url;
            private HttpService httpService;
            private ResourceServlet servlet;
            private TemplateService templateService;
            private LogService logService;
            private HttpContext httpContext;
            private Logger log;
            {
                this.url = Activator.this.getProperty("org.oiue.service.action.http.root") + "/";
            }

            public void removedService() {
                this.httpService.unregister(this.url);
            }

            public void addingService() {
                this.httpService = (HttpService)Activator.this.getService(HttpService.class);
                this.logService = (LogService)Activator.this.getService(LogService.class);
                this.templateService = (TemplateService)Activator.this.getService(TemplateService.class);
                FactoryService factoryService = (FactoryService)Activator.this.getService(FactoryService.class);
                CacheServiceManager cacheService = (CacheServiceManager)Activator.this.getService(CacheServiceManager.class);
                OnlineService onlineService = (OnlineService)Activator.this.getService(OnlineService.class);
                this.log = this.logService.getLogger(((Object)((Object)this)).getClass());
                this.servlet = new ResourceServlet(cacheService, onlineService, factoryService, this.logService, this.templateService, this.httpService);
            }

            public void updated(Dictionary<String, ?> props) {
                try {
                    this.servlet.updated(props);
                    this.log.info("\u7ed1\u5b9aurl\uff1a" + this.url, new Object[0]);
                    this.httpContext = new ResourceContext(this.templateService, this.logService, this.httpService.createDefaultHttpContext(), (String)props.get("root_path"));
                    this.httpService.registerServlet(this.url, (Servlet)this.servlet, props, this.httpContext);
                    this.httpService.registerServlet("/storefront/track", new Servlet(){

                        public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
                            log.debug(req.toString(), new Object[0]);
                        }

                        public void init(ServletConfig config) throws ServletException {
                        }

                        public String getServletInfo() {
                            return null;
                        }

                        public ServletConfig getServletConfig() {
                            return null;
                        }

                        public void destroy() {
                        }
                    }, null, null);
                    this.httpService.registerServlet("/storefront/page", new Servlet(){

                        public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
                            log.debug(req.toString(), new Object[0]);
                        }

                        public void init(ServletConfig config) throws ServletException {
                        }

                        public String getServletInfo() {
                            return null;
                        }

                        public ServletConfig getServletConfig() {
                            return null;
                        }

                        public void destroy() {
                        }
                    }, null, null);
                }
                catch (Exception e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                }
            }
        }, new Class[]{HttpService.class, TemplateService.class, LogService.class, FactoryService.class, OnlineService.class, CacheServiceManager.class});
    }

    public void stop() throws Exception {
    }
}

