/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.messages.xmpp;

import com.google.common.annotations.Beta;
import de.iwes.widgets.api.OgemaGuiService;
import de.iwes.widgets.api.messaging.listener.ReceivedMessage;
import de.iwes.widgets.api.widgets.localisation.OgemaLocale;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManager;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.ogema.core.application.Application;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.logging.OgemaLogger;
import org.ogema.core.resourcemanager.AccessPriority;
import org.ogema.core.resourcemanager.pattern.ResourcePatternAccess;
import org.ogema.messages.xmpp.ConfiguredSender;
import org.ogema.messages.xmpp.MyXmppMessageListener;
import org.ogema.messages.xmpp.XmppReceiverPattern;
import org.ogema.messages.xmpp.XmppSenderPattern;

@Component(immediate=true, specVersion="1.2")
@Service(value={Application.class, de.iwes.widgets.api.messaging.listener.MessageListener.class})
@Beta
public class XmppService
implements Application,
de.iwes.widgets.api.messaging.listener.MessageListener {
    private ResourcePatternAccess patternAccess;
    private OgemaLogger logger;
    private static final int packetReplyTimeout = 1000;
    private volatile ConfiguredSender configuredSender;
    private final MyXmppMessageListener messageListener = new MyXmppMessageListener();
    @Reference
    private OgemaGuiService guiService;

    public void start(ApplicationManager am) {
        this.patternAccess = am.getResourcePatternAccess();
        this.logger = am.getLogger();
    }

    public void newMessageAvailable(ReceivedMessage message, List<String> recipients) {
        this.prepareSending(message, recipients);
    }

    private void prepareSending(ReceivedMessage message, List<String> recipients) {
        if (this.patternAccess == null) {
            return;
        }
        ConfiguredSender sender = this.config();
        if (sender == null) {
            return;
        }
        List receivers = this.patternAccess.getPatterns(XmppReceiverPattern.class, AccessPriority.PRIO_LOWEST);
        if (receivers.isEmpty()) {
            this.logger.warn("No Xmpp-Receivers activated");
            return;
        }
        for (String receiver : recipients) {
            XmppReceiverPattern rec = XmppService.getReceiver(receiver, receivers);
            if (rec == null) {
                this.logger.warn("User " + receiver + " not found");
                continue;
            }
            String receiverAddress = rec.xmpp.getValue();
            this.createEntry(receiverAddress);
            this.sendXmppMessage(message, receiverAddress, sender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfiguredSender config() {
        List senders = this.patternAccess.getPatterns(XmppSenderPattern.class, AccessPriority.PRIO_LOWEST);
        if (senders.isEmpty()) {
            this.configuredSender = null;
            this.logger.error("No Xmpp-Sender configured, could not send xmpp-message");
            return null;
        }
        XmppSenderPattern sender = null;
        for (XmppSenderPattern pattern : senders) {
            if (!pattern.active.getValue()) continue;
            sender = pattern;
            break;
        }
        XmppService xmppService = this;
        synchronized (xmppService) {
            if (this.configuredSender != null) {
                if (sender.equals((Object)this.configuredSender.sender)) {
                    return this.configuredSender;
                }
                XmppService.disconnect(this.configuredSender);
                this.configuredSender = null;
            }
            ConnectionConfiguration newConfig = new ConnectionConfiguration(sender.xmpp.getValue().split("@")[1], sender.port.getValue());
            newConfig.setSASLAuthenticationEnabled(true);
            newConfig.setSecurityMode(ConnectionConfiguration.SecurityMode.enabled);
            XMPPConnection connection = new XMPPConnection(newConfig);
            try {
                connection.connect();
                connection.login(sender.xmpp.getValue().split("@")[0], sender.password.getValue());
                XmppService.setStatus(true, "online", this.configuredSender);
            }
            catch (Exception e) {
                try {
                    connection.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.logger.error("Could not connect to server", (Throwable)e);
                return null;
            }
            ChatManager chatManager = connection.getChatManager();
            this.configuredSender = new ConfiguredSender(sender, connection, chatManager);
            return this.configuredSender;
        }
    }

    private static void setStatus(boolean available, String status, ConfiguredSender sender) {
        Presence.Type type = available ? Presence.Type.available : Presence.Type.unavailable;
        Presence presence = new Presence(type);
        presence.setStatus(status);
        sender.connection.sendPacket((Packet)presence);
    }

    private void createEntry(String toUser) {
        Roster roster = this.configuredSender.connection.getRoster();
        try {
            roster.createEntry(toUser, toUser, null);
        }
        catch (XMPPException e) {
            e.printStackTrace();
        }
    }

    private void sendXmppMessage(ReceivedMessage ms, String toUser, ConfiguredSender sender) {
        String body = "Notification : " + ms.getOriginalMessage().message(null) + "\nSender : " + ms.getAppName() + "\nTime : " + new Date(ms.getTimestamp()).toString();
        Chat chat = sender.chatManager.createChat(toUser, (MessageListener)this.messageListener);
        try {
            chat.sendMessage(body);
        }
        catch (XMPPException e) {
            e.printStackTrace();
        }
    }

    private static void disconnect(ConfiguredSender sender) {
        if (sender.connection != null && sender.connection.isConnected()) {
            sender.connection.disconnect();
        }
    }

    public List<String> getKnownUsers() {
        if (this.patternAccess == null) {
            return Collections.emptyList();
        }
        List receivers = this.patternAccess.getPatterns(XmppReceiverPattern.class, AccessPriority.PRIO_LOWEST);
        ArrayList<String> users = new ArrayList<String>();
        for (XmppReceiverPattern pattern : receivers) {
            users.add(pattern.userName.getValue());
        }
        return users;
    }

    private static final XmppReceiverPattern getReceiver(String userName, List<XmppReceiverPattern> receivers) {
        for (XmppReceiverPattern pat : receivers) {
            if (!pat.userName.getValue().equals(userName)) continue;
            return pat;
        }
        return null;
    }

    public void stop(Application.AppStopReason arg0) {
        this.patternAccess = null;
        this.logger = null;
    }

    public String getId() {
        return "XMPP-connector";
    }

    public String getDescription(OgemaLocale locale) {
        return "XMPP-connector";
    }

    protected void bindGuiService(OgemaGuiService ogemaGuiService) {
        this.guiService = ogemaGuiService;
    }

    protected void unbindGuiService(OgemaGuiService ogemaGuiService) {
        if (this.guiService == ogemaGuiService) {
            this.guiService = null;
        }
    }
}

