/*
 * Decompiled with CFR 0.152.
 */
package de.iee.sema.remote.user.administration;

import de.iee.sema.remote.user.administration.EditPageInit;
import de.iee.sema.remote.user.administration.RemoteUserAdministration;
import de.iwes.widgets.api.extended.WidgetData;
import de.iwes.widgets.api.widgets.OgemaWidget;
import de.iwes.widgets.api.widgets.WidgetPage;
import de.iwes.widgets.api.widgets.dynamics.TriggeredAction;
import de.iwes.widgets.api.widgets.dynamics.TriggeringAction;
import de.iwes.widgets.api.widgets.html.HtmlItem;
import de.iwes.widgets.api.widgets.html.StaticTable;
import de.iwes.widgets.api.widgets.sessionmanagement.OgemaHttpRequest;
import de.iwes.widgets.html.alert.Alert;
import de.iwes.widgets.html.alert.AlertData;
import de.iwes.widgets.html.fileupload.FileUpload;
import de.iwes.widgets.html.fileupload.FileUploadData;
import de.iwes.widgets.html.fileupload.FileUploadListener;
import de.iwes.widgets.html.form.button.Button;
import de.iwes.widgets.html.form.label.Header;
import de.iwes.widgets.html.form.label.Label;
import de.iwes.widgets.html.textarea.TextArea;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ogema.core.application.ApplicationManager;
import org.osgi.service.condpermadmin.ConditionalPermissionAdmin;
import org.osgi.service.condpermadmin.ConditionalPermissionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionUpdate;
import org.slf4j.LoggerFactory;

class CreatePageInit {
    private final WidgetPage<?> page;
    private final Header header;
    private final Alert alert;
    private final Alert infoAlert;
    private final TextArea usersField;
    private final TextArea permsField;
    private final Label userLabel;
    private final Label permLabel;
    private final FileUpload usersUpload;
    private final FileUpload permsUpload;
    private final Button uploadButton;
    private final Button installButton;
    private final ConditionalPermissionAdmin cpa;

    CreatePageInit(WidgetPage<?> page, final ApplicationManager appMan, final ConditionalPermissionAdmin cpa) {
        this.page = page;
        this.cpa = cpa;
        this.header = new Header(page, "header", "Remote User Administation");
        this.header.addDefaultStyle(WidgetData.TEXT_ALIGNMENT_CENTERED);
        this.alert = new Alert(page, "alert", "");
        this.alert.setDefaultVisibility(false);
        this.infoAlert = new Alert(page, "infoAlert", "You can enter the usernames and permissions in the two text ares below manually or upload files containing these information. A permission could look like this (You have to replace the <value> entries with your needed information, it's also possible to enter multiple permissions, just add a new '()' after the example ResourcePermission with the needed information): allow { [<usertype (machine/natural)> \"{$user}\"] (org.ogema.accesscontrol.ResourcePermission \"path=<pathToResource>/*\" \"<needed permissions (read,write,addsub,create,activity)>)}");
        this.infoAlert.setDefaultVisibility(true);
        this.infoAlert.addDefaultStyle(AlertData.BOOTSTRAP_INFO);
        this.usersField = new TextArea(page, "usersField"){
            private static final long serialVersionUID = 1L;

            public void onGET(OgemaHttpRequest req) {
                this.setToolTip("You can enter the multiple usernames manually or upload a file", req);
            }
        };
        this.usersField.setDefaultWidth("100%");
        this.usersField.setDefaultText("");
        this.permsField = new TextArea(page, "permsField"){
            private static final long serialVersionUID = 1L;

            public void onGET(OgemaHttpRequest req) {
                this.setToolTip("You can enter the permissions manually or upload a file", req);
            }
        };
        this.permsField.setDefaultWidth("100%");
        this.permsField.setDefaultText("");
        this.userLabel = new Label(page, "userLabel", "Users: ");
        this.permLabel = new Label(page, "permLabel", "Permissions: ");
        this.usersUpload = new FileUpload(page, "upload", appMan);
        this.permsUpload = new FileUpload(page, "policies", appMan);
        this.uploadButton = new Button(page, "uploadButton"){
            private static final long serialVersionUID = 1L;

            public void onPOSTComplete(String data, OgemaHttpRequest req) {
                FileUploadListener userL = (fileItem, context, req2) -> {
                    try {
                        CreatePageInit.this.usersField.setText(fileItem.getString("UTF-8"), req);
                    }
                    catch (IOException e) {
                        CreatePageInit.this.alert.showAlert("User upload Failure: Reading in the userfile '" + fileItem.getName() + "' failed", false, req);
                    }
                };
                FileUploadListener permL = (fileItem, context, req2) -> {
                    try {
                        CreatePageInit.this.permsField.setText(fileItem.getString("UTF-8"), req);
                    }
                    catch (IOException e) {
                        CreatePageInit.this.alert.showAlert("Policy upload Failure: Reading in the file '" + fileItem.getName() + "' failed", false, req);
                    }
                };
                CreatePageInit.this.usersUpload.registerListener(userL, (Object)Float.valueOf(1.5f), req);
                CreatePageInit.this.permsUpload.registerListener(permL, (Object)Float.valueOf(1.5f), req);
            }
        };
        this.uploadButton.setDefaultText("Upload selected files");
        this.installButton = new Button(page, "installButton", true){
            private static final long serialVersionUID = 1L;

            public void onPOSTComplete(String data, OgemaHttpRequest req) {
                List permsList;
                String users = CreatePageInit.this.usersField.getText(req).trim();
                String perms = CreatePageInit.this.permsField.getText(req).trim();
                if (users.isEmpty() || perms.isEmpty()) {
                    CreatePageInit.this.alert.showAlert("Please upload files first", false, req);
                    return;
                }
                ArrayList<String> usersList = new ArrayList<String>();
                try (BufferedReader reader = new BufferedReader(new StringReader(users));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (CreatePageInit.isEmptyOrCommentLine(line = line.trim())) continue;
                        usersList.add(line);
                    }
                }
                catch (IOException e) {
                    CreatePageInit.this.alert.showAlert("Unexpected error " + e, false, req);
                    return;
                }
                if (usersList.isEmpty()) {
                    CreatePageInit.this.alert.showAlert("No users selected", false, req);
                    return;
                }
                try {
                    permsList = CreatePageInit.this.parseUserPolicies(perms, usersList);
                }
                catch (IOException e) {
                    CreatePageInit.this.alert.showAlert("Unexpected error " + e, false, req);
                    return;
                }
                if (permsList.isEmpty()) {
                    CreatePageInit.this.alert.showAlert("No permissions selected", false, req);
                    return;
                }
                this.createRestUsers(usersList.stream());
                CreatePageInit.installPolicies(permsList.stream(), cpa);
                CreatePageInit.this.alert.showAlert(permsList.size() + " policies installed", true, req);
            }

            private void createRestUsers(Stream<String> stream) {
                stream.forEach(gw -> {
                    ArrayList users = new ArrayList();
                    appMan.getAdministrationManager().getAllUsers().forEach(user -> users.add(user.getName()));
                    if (!users.contains(gw)) {
                        appMan.getAdministrationManager().createUserAccount(gw, false);
                    }
                });
            }
        };
        this.installButton.setDefaultText("Install user permissions");
        this.buildPage();
        this.setDependencies();
    }

    private final void buildPage() {
        StaticTable uploadTable = new StaticTable(2, 2);
        uploadTable.setContent(0, 0, (OgemaWidget)this.userLabel).setContent(0, 1, (OgemaWidget)this.usersUpload).setContent(1, 0, (OgemaWidget)this.permLabel).setContent(1, 1, (OgemaWidget)this.permsUpload);
        this.page.append((OgemaWidget)this.header).linebreak().append((OgemaWidget)this.infoAlert).append((OgemaWidget)this.alert).append((HtmlItem)uploadTable).append((OgemaWidget)this.uploadButton).append((OgemaWidget)this.usersField).append((OgemaWidget)this.permsField).append((OgemaWidget)this.installButton);
    }

    private final void setDependencies() {
        this.uploadButton.triggerAction((OgemaWidget)this.alert, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        this.uploadButton.triggerAction((OgemaWidget)this.usersUpload, TriggeringAction.POST_REQUEST, TriggeredAction.POST_REQUEST);
        this.uploadButton.triggerAction((OgemaWidget)this.permsUpload, TriggeringAction.POST_REQUEST, TriggeredAction.POST_REQUEST);
        this.uploadButton.triggerAction((OgemaWidget)this.alert, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        this.usersUpload.triggerAction((OgemaWidget)this.usersField, FileUploadData.UPLOAD_COMPLETED, TriggeredAction.GET_REQUEST);
        this.permsUpload.triggerAction((OgemaWidget)this.permsField, FileUploadData.UPLOAD_COMPLETED, TriggeredAction.GET_REQUEST);
        this.installButton.triggerAction((OgemaWidget)this.alert, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
    }

    static boolean isEmptyOrCommentLine(String line) {
        return line.isEmpty() || line.charAt(0) == '#' || line.startsWith("//");
    }

    private List<String> parseUserPolicies(String fileData, List<String> userList) throws IOException {
        try (BufferedReader reader = new BufferedReader(new StringReader(fileData));){
            String line;
            ArrayList<String> permInfos = new ArrayList<String>();
            String gwSpecificUserPolicy = null;
            while ((line = reader.readLine()) != null) {
                if (CreatePageInit.isEmptyOrCommentLine(line = line.trim())) continue;
                for (String gw : userList) {
                    gwSpecificUserPolicy = line.replace("{$user}", gw);
                    gwSpecificUserPolicy = gwSpecificUserPolicy.replaceFirst("(.*machine)[ \t]*\"([a-zA-Z_0-9]*)\"", "$1 \"urp:$2\"");
                    gwSpecificUserPolicy = gwSpecificUserPolicy.replaceFirst("(.*\\[)[ \t]*machine(.*)", "$1org.osgi.service.condpermadmin.BundleLocationCondition$2");
                    gwSpecificUserPolicy = gwSpecificUserPolicy + " " + EditPageInit.getValidPolicyID(CreatePageInit.getPolicyNames(this.cpa), gw);
                    permInfos.add(gwSpecificUserPolicy);
                }
            }
            ArrayList<String> arrayList = permInfos;
            return arrayList;
        }
    }

    static void installPolicies(Stream<String> permInfos, ConditionalPermissionAdmin cpa) {
        ConditionalPermissionUpdate cpu = cpa.newConditionalPermissionUpdate();
        List permInfoList = cpu.getConditionalPermissionInfos();
        permInfos.map(permInfo -> {
            ConditionalPermissionInfo cpi;
            try {
                cpi = cpa.newConditionalPermissionInfo(permInfo);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(RemoteUserAdministration.class).error(String.format("Error setting permission '%s'", permInfo), (Throwable)e);
                return null;
            }
            return cpi;
        }).filter(Objects::nonNull).forEach(permInfoList::add);
        cpu.commit();
    }

    static List<String> getPolicyNames(ConditionalPermissionAdmin cpa) {
        return cpa.newConditionalPermissionUpdate().getConditionalPermissionInfos().stream().map(ConditionalPermissionInfo::getName).collect(Collectors.toList());
    }
}

