/*
 * Decompiled with CFR 0.152.
 */
package de.iee.sema.remote.message.receiver.template;

import de.iee.sema.remote.message.receiver.model.RemoteMessage;
import de.iwes.widgets.api.widgets.WidgetPage;
import de.iwes.widgets.api.widgets.sessionmanagement.OgemaHttpRequest;
import de.iwes.widgets.html.complextable.DynamicTable;
import de.iwes.widgets.html.complextable.RowTemplate;
import de.iwes.widgets.html.form.label.Label;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ogema.tools.resource.util.ResourceUtils;

public class RemoteMessageTemplate
extends RowTemplate<RemoteMessage> {
    private static final String SENDER_COL = "sender";
    private static final String SUBJECT_COL = "subject";
    private static final String PRIO_COL = "prio";
    private static final String BODY_COL = "body";
    private final WidgetPage<?> page;

    public RemoteMessageTemplate(WidgetPage<?> page, DynamicTable<RemoteMessage> messageTable) {
        this.page = page;
        messageTable.setColumnSize(SENDER_COL, 1, null);
    }

    public String getLineId(RemoteMessage remoteMessage) {
        return ResourceUtils.getValidResourceName((String)remoteMessage.getName());
    }

    public Map<String, Object> getHeader() {
        LinkedHashMap<String, Object> header = new LinkedHashMap<String, Object>();
        header.put(SENDER_COL, "Sender");
        header.put(SUBJECT_COL, "Subject");
        header.put(PRIO_COL, "Prio");
        header.put(BODY_COL, "Body");
        return header;
    }

    public RowTemplate.Row addRow(RemoteMessage remoteMessage, OgemaHttpRequest req) {
        RowTemplate.Row row = new RowTemplate.Row();
        String lineId = this.getLineId(remoteMessage);
        Label sender = new Label(this.page, "sender_" + lineId, remoteMessage.sender().getValue());
        row.addCell(SENDER_COL, (Object)sender);
        Label subject = new Label(this.page, "subject_" + lineId, remoteMessage.subject().getValue());
        row.addCell(SUBJECT_COL, (Object)subject);
        Label prio = new Label(this.page, "prio_" + lineId, (long)remoteMessage.priority().getValue());
        row.addCell(PRIO_COL, (Object)prio);
        Label body = new Label(this.page, "body_" + lineId, remoteMessage.body().getValue());
        row.addCell(BODY_COL, (Object)body);
        return row;
    }
}

