/*
 * Decompiled with CFR 0.152.
 */
package de.iee.sema.remote.message.receiver.template;

import de.iee.sema.remote.message.receiver.model.ClientData;
import de.iwes.widgets.api.widgets.OgemaWidget;
import de.iwes.widgets.api.widgets.WidgetPage;
import de.iwes.widgets.api.widgets.dynamics.TriggeredAction;
import de.iwes.widgets.api.widgets.dynamics.TriggeringAction;
import de.iwes.widgets.api.widgets.sessionmanagement.OgemaHttpRequest;
import de.iwes.widgets.html.alert.Alert;
import de.iwes.widgets.html.buttonconfirm.ButtonConfirm;
import de.iwes.widgets.html.complextable.DynamicTable;
import de.iwes.widgets.html.complextable.RowTemplate;
import de.iwes.widgets.html.form.button.ButtonData;
import de.iwes.widgets.html.form.label.Label;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ogema.core.application.ApplicationManager;
import org.ogema.tools.resource.util.ResourceUtils;

public class ClientDataTemplate
extends RowTemplate<ClientData> {
    private static final String NAME_COL = "name";
    private static final String DELETE_COL = "delete";
    private static final String POPUP_COL = "popup";
    private final ApplicationManager appMan;
    private final WidgetPage<?> page;
    private final Alert alert;
    private final DynamicTable<ClientData> clientTable;

    public ClientDataTemplate(ApplicationManager appMan, WidgetPage<?> page, Alert alert, DynamicTable<ClientData> clientTable) {
        this.appMan = appMan;
        this.page = page;
        this.alert = alert;
        this.clientTable = clientTable;
    }

    public String getLineId(ClientData clientData) {
        return ResourceUtils.getValidResourceName((String)clientData.getName());
    }

    public Map<String, Object> getHeader() {
        LinkedHashMap<String, Object> header = new LinkedHashMap<String, Object>();
        header.put(NAME_COL, "Client name");
        header.put(DELETE_COL, "");
        header.put(POPUP_COL, "");
        return header;
    }

    public RowTemplate.Row addRow(final ClientData clientData, OgemaHttpRequest req) {
        RowTemplate.Row row = new RowTemplate.Row();
        String lineId = this.getLineId(clientData);
        final String clientName = clientData.userName().getValue();
        Label name = new Label(this.page, "clientDataName_" + lineId, clientData.userName().getValue());
        row.addCell(NAME_COL, (Object)name);
        ButtonConfirm deleteButton = new ButtonConfirm(this.page, "deleteButton_" + lineId, "Delete"){
            private static final long serialVersionUID = 1L;

            public void onPOSTComplete(String data, OgemaHttpRequest req) {
                clientData.delete();
                ClientDataTemplate.this.appMan.getAdministrationManager().removeUserAccount(clientName);
                ClientDataTemplate.this.alert.showAlert("User '" + clientName + "' successfully deleted", true, req);
            }
        };
        deleteButton.addDefaultStyle(ButtonData.BOOTSTRAP_RED);
        deleteButton.setDefaultConfirmPopupTitle("Delete client data: " + clientName);
        deleteButton.setDefaultConfirmMsg("Do you really want to delete '" + clientName + "'?");
        deleteButton.triggerAction(this.clientTable, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        deleteButton.triggerAction((OgemaWidget)this.alert, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        row.addCell(DELETE_COL, (Object)deleteButton);
        return row;
    }
}

