/*
 * Decompiled with CFR 0.152.
 */
package de.iee.sema.remote.message.receiver.gui;

import de.iee.sema.remote.message.receiver.gui.MessageOverviewPage;
import de.iee.sema.remote.message.receiver.model.RemoteMessage;
import de.iwes.widgets.api.extended.OgemaWidgetBase;
import de.iwes.widgets.api.extended.html.bricks.PageSnippet;
import de.iwes.widgets.api.messaging.MessagePriority;
import de.iwes.widgets.api.widgets.OgemaWidget;
import de.iwes.widgets.api.widgets.WidgetGroup;
import de.iwes.widgets.api.widgets.WidgetPage;
import de.iwes.widgets.api.widgets.dynamics.TriggeredAction;
import de.iwes.widgets.api.widgets.dynamics.TriggeringAction;
import de.iwes.widgets.api.widgets.html.HtmlItem;
import de.iwes.widgets.api.widgets.html.StaticTable;
import de.iwes.widgets.api.widgets.sessionmanagement.OgemaHttpRequest;
import de.iwes.widgets.html.form.label.Label;
import de.iwes.widgets.html.popup.Popup;
import de.iwes.widgets.html.popup.PopupData;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.function.Function;
import org.ogema.core.model.simple.IntegerResource;
import org.ogema.core.model.simple.SingleValueResource;
import org.ogema.core.model.simple.TimeResource;
import org.ogema.tools.resource.util.ValueResourceUtils;

public class RemoteMessagePopup
extends Popup {
    private static final long serialVersionUID = 1L;
    private final PageSnippet bodyContainer;
    private final Label timestampLabel;
    private final Label senderGWLabel;
    private final Label senderAppLabel;
    private final Label subjectLabel;
    private final Label bodyLabel;
    private final Label prioLabel;
    private final WidgetGroup widgets;

    public RemoteMessagePopup(WidgetPage<?> page, String id) {
        super(page, id, true);
        this.setTitle("Detailed Message Information", null);
        this.timestampLabel = new MessageLabel(page, "timestampLabel", message -> message.timestamp());
        this.senderGWLabel = new Label(page, "senderGWLabel"){
            private static final long serialVersionUID = 1L;

            public void onGET(OgemaHttpRequest req) {
                RemoteMessage rm = RemoteMessagePopup.this.getCurrentMessage(req);
                this.setText(rm == null ? "" : rm.getParent().getParent().getName(), req);
            }
        };
        this.senderAppLabel = new MessageLabel(page, "senderAppLabel", message -> message.sender());
        this.subjectLabel = new MessageLabel(page, "subjectLabel", message -> message.subject());
        this.bodyLabel = new MessageLabel(page, "bodyLabel", message -> message.body());
        this.prioLabel = new MessageLabel(page, "prioLabel", message -> message.priority());
        this.bodyContainer = new PageSnippet(page, "bodyContainer", true);
        LinkedList<Label> widgetsList = new LinkedList<Label>();
        widgetsList.add(this.timestampLabel);
        widgetsList.add(this.senderGWLabel);
        widgetsList.add(this.senderAppLabel);
        widgetsList.add(this.subjectLabel);
        widgetsList.add(this.bodyLabel);
        widgetsList.add(this.prioLabel);
        this.widgets = page.registerWidgetGroup("popupWidgets", widgetsList);
        this.setWidgets();
    }

    public PopupOptions createNewSession() {
        return new PopupOptions(this);
    }

    public PopupOptions getData(OgemaHttpRequest req) {
        return (PopupOptions)super.getData(req);
    }

    public RemoteMessage getCurrentMessage(OgemaHttpRequest req) {
        return this.getData(req).getCurrentMessage();
    }

    public void setCurrentMessage(RemoteMessage currentMessage, OgemaHttpRequest req) {
        this.getData(req).setCurrentMessage(currentMessage);
    }

    void initialize() {
        this.setBody((OgemaWidgetBase)this.bodyContainer, null);
        this.triggerAction(this.widgets, TriggeringAction.GET_REQUEST, TriggeredAction.GET_REQUEST);
        this.triggerAction((OgemaWidget)this, TriggeringAction.GET_REQUEST, TriggeredAction.SHOW_WIDGET);
    }

    private void setWidgets() {
        StaticTable table = new StaticTable(6, 2);
        table.setContent(0, 0, "Timestamp");
        table.setContent(1, 0, "Sender Gateway");
        table.setContent(2, 0, "Sender App");
        table.setContent(3, 0, "Subject");
        table.setContent(4, 0, "Message Body");
        table.setContent(5, 0, "Priority");
        table.setContent(0, 1, (OgemaWidget)this.timestampLabel);
        table.setContent(1, 1, (OgemaWidget)this.senderGWLabel);
        table.setContent(2, 1, (OgemaWidget)this.senderAppLabel);
        table.setContent(3, 1, (OgemaWidget)this.subjectLabel);
        table.setContent(4, 1, (OgemaWidget)this.bodyLabel);
        table.setContent(5, 1, (OgemaWidget)this.prioLabel);
        this.bodyContainer.append((HtmlItem)table, null);
    }

    public class PopupOptions
    extends PopupData {
        private RemoteMessage currentMessage;

        public PopupOptions(RemoteMessagePopup widget) {
            super((Popup)widget);
            this.currentMessage = null;
        }

        public RemoteMessage getCurrentMessage() {
            return this.currentMessage;
        }

        public void setCurrentMessage(RemoteMessage currentMessage) {
            this.currentMessage = currentMessage;
        }
    }

    private class MessageLabel
    extends Label {
        private final Function<RemoteMessage, SingleValueResource> valueProvider;

        public MessageLabel(WidgetPage<?> page, String id, Function<RemoteMessage, SingleValueResource> valueProvider) {
            super(page, id);
            this.valueProvider = valueProvider;
        }

        public void onGET(OgemaHttpRequest req) {
            RemoteMessage msg = RemoteMessagePopup.this.getCurrentMessage(req);
            this.setText(msg == null ? "" : this.convert(this.valueProvider.apply(msg)), req);
        }

        private String convert(SingleValueResource value) {
            if ("priority".equals(value.getName())) {
                int prio = ((IntegerResource)value).getValue();
                return Arrays.stream(MessagePriority.values()).filter(pr -> pr.getPriority() == prio).findAny().orElse(MessagePriority.LOW).name();
            }
            if (value instanceof TimeResource) {
                return MessageOverviewPage.getTimeString(((TimeResource)value).getValue());
            }
            return ValueResourceUtils.getValue((SingleValueResource)value);
        }
    }
}

