/*
 * Decompiled with CFR 0.152.
 */
package de.iee.sema.remote.message.receiver.gui;

import de.iee.sema.remote.message.receiver.model.ClientData;
import de.iee.sema.remote.message.receiver.template.ClientDataTemplate;
import de.iwes.widgets.api.extended.OgemaWidgetBase;
import de.iwes.widgets.api.extended.WidgetData;
import de.iwes.widgets.api.extended.html.bricks.PageSnippet;
import de.iwes.widgets.api.widgets.LazyWidgetPage;
import de.iwes.widgets.api.widgets.OgemaWidget;
import de.iwes.widgets.api.widgets.WidgetPage;
import de.iwes.widgets.api.widgets.WidgetStyle;
import de.iwes.widgets.api.widgets.dynamics.TriggeredAction;
import de.iwes.widgets.api.widgets.dynamics.TriggeringAction;
import de.iwes.widgets.api.widgets.html.HtmlItem;
import de.iwes.widgets.api.widgets.html.StaticTable;
import de.iwes.widgets.api.widgets.sessionmanagement.OgemaHttpRequest;
import de.iwes.widgets.html.alert.Alert;
import de.iwes.widgets.html.complextable.DynamicTable;
import de.iwes.widgets.html.complextable.RowTemplate;
import de.iwes.widgets.html.form.button.Button;
import de.iwes.widgets.html.form.button.ButtonData;
import de.iwes.widgets.html.form.checkbox.Checkbox2;
import de.iwes.widgets.html.form.checkbox.DefaultCheckboxEntry;
import de.iwes.widgets.html.form.label.Header;
import de.iwes.widgets.html.form.textfield.TextField;
import de.iwes.widgets.html.popup.Popup;
import java.io.FilePermission;
import java.io.IOException;
import java.security.AccessController;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ogema.accesscontrol.ResourcePermission;
import org.ogema.core.administration.UserAccount;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.model.ResourceList;
import org.ogema.core.model.simple.StringResource;
import org.ogema.tools.resource.util.ResourceUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.condpermadmin.ConditionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionAdmin;
import org.osgi.service.condpermadmin.ConditionalPermissionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionUpdate;
import org.osgi.service.permissionadmin.PermissionInfo;

@Component(service={LazyWidgetPage.class}, property={"org.ogema.widgets.page.baseurl=/de/iwes/ogema/apps/remotemessagereceiver", "org.ogema.widgets.page.pageurl=useroverview.html", "org.ogema.widgets.page.startpage=true", "org.ogema.widgets.page.menuentry=User Overview"})
public class MessageReceiverPage
implements LazyWidgetPage {
    private static final String CHECK_MSG_PERM = "msgPerm";
    private static final String CHECK_FILE_PERM = "filePerm";
    private static final String PROPERTY_ADDITIONAL_RESOURCES_CLIENT_SPECIFIC = "org.ogema.messaging.remotereceiver.ReourcePermissionPathsClientSpecific";
    private static final String PROPERTY_ADDITIONAL_RESOURCES_GLOBAL = "org.ogema.messaging.remotereceiver.ReourcePermissionPathsGlobal";
    private static final Collection<String> ADDITIONAL_RESOURCES_CLIENT_SPECIFIC;
    private static final Collection<String> ADDITIONAL_RESOURCES_GLOBAL;
    @Reference
    private ConditionalPermissionAdmin cpa;

    public void init(final ApplicationManager appMan, WidgetPage<?> page) {
        final ResourceList remoteMessages = (ResourceList)appMan.getResourceManagement().createResource("clientData", ResourceList.class);
        remoteMessages.setElementType(ClientData.class);
        remoteMessages.activate(true);
        Header header = new Header(page, "header", "Remote Receiver App - Users");
        header.addDefaultStyle(WidgetData.TEXT_ALIGNMENT_CENTERED);
        final Alert alert = new Alert(page, "alert", "");
        alert.setDefaultVisibility(false);
        DynamicTable<ClientData> clientDataTable = new DynamicTable<ClientData>(page, "clientDataTable", true){
            private static final long serialVersionUID = 1L;

            public void onGET(OgemaHttpRequest req) {
                List clientDatas = appMan.getResourceAccess().getResources(ClientData.class);
                this.updateRows(clientDatas, req);
            }
        };
        ClientDataTemplate clientDataTemplate = new ClientDataTemplate(appMan, page, alert, clientDataTable);
        clientDataTable.setRowTemplate((RowTemplate)clientDataTemplate);
        clientDataTable.setDefaultRowIdComparator(null);
        ArrayList<WidgetStyle> styles = new ArrayList<WidgetStyle>();
        styles.add(WidgetData.TEXT_ALIGNMENT_CENTERED);
        clientDataTable.setDefaultStyles(styles);
        Popup newPopup = new Popup(page, "newPopup", true);
        newPopup.setTitle("New client configuration", null);
        StaticTable newTable = new StaticTable(3, 2, new int[]{4, 8});
        PageSnippet newSnippet = new PageSnippet(page, "newSnippet", true);
        final TextField newNameTextField = new TextField(page, "newNameTextField");
        final TextField newPasswordTextField = new TextField(page, "newPasswordTextField");
        final Checkbox2 permCheck = new Checkbox2(page, "permCheck");
        permCheck.setDefaultCheckboxList(Arrays.asList(new DefaultCheckboxEntry(CHECK_MSG_PERM, "Add message permission", true), new DefaultCheckboxEntry(CHECK_FILE_PERM, "Add file upload permission", true)));
        permCheck.setDefaultToolTip("A message permissions allows the user to upload message resources via the OGEMA REST interface. The file permission allows the user to upload files for backup purposes.");
        newTable.setContent(0, 0, "Name");
        newTable.setContent(1, 0, "Password");
        newTable.setContent(0, 1, (OgemaWidget)newNameTextField);
        newTable.setContent(1, 1, (OgemaWidget)newPasswordTextField);
        newTable.setContent(2, 1, (OgemaWidget)permCheck);
        Button createNewButton = new Button(page, "createNewButton", "Create"){
            private static final long serialVersionUID = 1L;

            public void onPOSTComplete(String value, OgemaHttpRequest req) {
                String name = newNameTextField.getValue(req);
                String password = newPasswordTextField.getValue(req);
                if (!ResourceUtils.isValidResourcePath((String)name) || password.isEmpty() || name.contains("/")) {
                    alert.showAlert("Invalid user name", false, req);
                    return;
                }
                ClientData cd = (ClientData)((ClientData)remoteMessages.getSubResource(name, ClientData.class)).create();
                ((StringResource)cd.userName().create()).setValue(name);
                cd.messages().create();
                cd.activate(true);
                UserAccount account = appMan.getAdministrationManager().createUserAccount(name, false);
                account.setNewPassword(name, password);
                boolean addResourcePerm = permCheck.isChecked(MessageReceiverPage.CHECK_MSG_PERM, req);
                boolean addFilePerm = permCheck.isChecked(MessageReceiverPage.CHECK_FILE_PERM, req);
                ArrayList<Permission> perms = new ArrayList<Permission>();
                if (addResourcePerm) {
                    StringJoiner joiner = new StringJoiner(",");
                    joiner.add("read").add("write").add("activity").add("create").add("addsub");
                    ResourcePermission perm = new ResourcePermission("path=" + cd.getPath() + "/*", joiner.toString());
                    perms.add((Permission)perm);
                    ADDITIONAL_RESOURCES_CLIENT_SPECIFIC.stream().map(path -> new ResourcePermission("path=" + path + "/" + name + "/*", joiner.toString())).forEach(perms::add);
                    ADDITIONAL_RESOURCES_GLOBAL.stream().map(path -> new ResourcePermission("path=" + path, "read")).forEach(perms::add);
                }
                if (addFilePerm) {
                    try {
                        List filePermissions = this.getUploadServletConfigs().map(folder -> new FilePermission(folder + "/" + name + "/*", "read,write")).collect(Collectors.toList());
                        perms.addAll(filePermissions);
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        // empty catch block
                    }
                }
                if (!perms.isEmpty() && !this.addPermissions(MessageReceiverPage.this.cpa, perms, name)) {
                    appMan.getAdministrationManager().removeUserAccount(name);
                    alert.showAlert("could not create user, permission creation failed", false, req);
                } else {
                    alert.showAlert("New user " + name + " created", true, req);
                }
            }

            private final boolean addPermissions(ConditionalPermissionAdmin cpa, List<Permission> permissions, String userName) {
                boolean success = false;
                PermissionInfo[] infos = (PermissionInfo[])permissions.stream().map(perm -> new PermissionInfo(perm.getClass().getName(), perm.getName(), perm.getActions())).toArray(PermissionInfo[]::new);
                for (int i = 0; i < 5; ++i) {
                    ConditionalPermissionUpdate update = cpa.newConditionalPermissionUpdate();
                    ConditionalPermissionInfo info = cpa.newConditionalPermissionInfo(null, new ConditionInfo[]{new ConditionInfo("org.osgi.service.condpermadmin.BundleLocationCondition", new String[]{"urp:" + userName})}, infos, "allow");
                    update.getConditionalPermissionInfos().add(info);
                    if (!update.commit()) continue;
                    success = true;
                    break;
                }
                return success;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final Stream<String> getUploadServletConfigs() {
                BundleContext ctx = appMan.getAppID().getBundle().getBundleContext();
                ServiceReference caRef = ctx.getServiceReference(ConfigurationAdmin.class);
                if (caRef == null) {
                    return Stream.empty();
                }
                try {
                    ConfigurationAdmin ca = (ConfigurationAdmin)ctx.getService(caRef);
                    if (ca == null) {
                        Stream<String> stream = Stream.empty();
                        return stream;
                    }
                    Configuration[] configs = ca.listConfigurations("(service.pid=org.smartrplace.tools.UploadServlet)");
                    if (configs == null || configs.length == 0) {
                        Stream<String> stream = Stream.empty();
                        return stream;
                    }
                    Stream<String> stream = Arrays.stream(configs).map(config -> {
                        Object folder = config.getProperties().get("uploadFolder");
                        if (!(folder instanceof String)) {
                            return null;
                        }
                        String fold = (String)folder;
                        if (fold.endsWith("/")) {
                            fold = fold.substring(0, fold.length() - 1);
                        }
                        return fold;
                    }).filter(folder -> folder != null);
                    return stream;
                }
                catch (InvalidSyntaxException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    Stream<String> stream = Stream.empty();
                    return stream;
                }
                finally {
                    ctx.ungetService(caRef);
                }
            }
        };
        createNewButton.triggerAction((OgemaWidget)clientDataTable, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        createNewButton.triggerAction((OgemaWidget)newPopup, TriggeringAction.POST_REQUEST, TriggeredAction.HIDE_WIDGET);
        createNewButton.triggerAction((OgemaWidget)alert, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        createNewButton.addDefaultStyle(ButtonData.BOOTSTRAP_GREEN);
        newSnippet.append((HtmlItem)newTable, null);
        newSnippet.append((OgemaWidget)createNewButton, null);
        newPopup.setBody((OgemaWidgetBase)newSnippet, null);
        Button newButton = new Button(page, "newButton", "New receiver");
        newButton.triggerAction((OgemaWidget)newPopup, TriggeringAction.POST_REQUEST, TriggeredAction.SHOW_WIDGET);
        newButton.addDefaultStyle(ButtonData.BOOTSTRAP_GREEN);
        page.append((OgemaWidget)header).linebreak().append((OgemaWidget)alert).linebreak().append((OgemaWidget)clientDataTable).append((OgemaWidget)newButton).append((OgemaWidget)newPopup);
    }

    static {
        String addProp = AccessController.doPrivileged(() -> System.getProperty(PROPERTY_ADDITIONAL_RESOURCES_CLIENT_SPECIFIC));
        ADDITIONAL_RESOURCES_CLIENT_SPECIFIC = addProp == null ? Collections.emptyList() : (Collection)Arrays.stream(addProp.split(",")).map(String::trim).map(str -> {
            if (str.endsWith("/")) {
                str = str.substring(0, str.length() - 1);
            }
            return str;
        }).collect(Collectors.toList());
        String addPropGlobal = AccessController.doPrivileged(() -> System.getProperty(PROPERTY_ADDITIONAL_RESOURCES_GLOBAL));
        ADDITIONAL_RESOURCES_GLOBAL = addPropGlobal == null ? Collections.emptyList() : (Collection)Arrays.stream(addPropGlobal.split(",")).map(String::trim).map(str -> {
            if (str.endsWith("/")) {
                str = str.substring(0, str.length() - 1);
            }
            return str;
        }).collect(Collectors.toList());
    }
}

