/*
 * Decompiled with CFR 0.152.
 */
package de.iee.sema.remote.message.receiver.gui;

import de.iee.sema.remote.message.receiver.gui.RemoteMessagePopup;
import de.iee.sema.remote.message.receiver.model.RemoteMessage;
import de.iwes.widgets.api.extended.WidgetData;
import de.iwes.widgets.api.widgets.LazyWidgetPage;
import de.iwes.widgets.api.widgets.OgemaWidget;
import de.iwes.widgets.api.widgets.WidgetPage;
import de.iwes.widgets.api.widgets.dynamics.TriggeredAction;
import de.iwes.widgets.api.widgets.dynamics.TriggeringAction;
import de.iwes.widgets.api.widgets.sessionmanagement.OgemaHttpRequest;
import de.iwes.widgets.html.calendar.datepicker.Datepicker;
import de.iwes.widgets.html.datatable.DataTable;
import de.iwes.widgets.html.form.label.Header;
import de.iwes.widgets.html.multiselect.TemplateMultiselect;
import de.iwes.widgets.multiselect.extended.MultiSelectExtended;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.model.Resource;
import org.ogema.core.model.ResourceList;
import org.osgi.service.component.annotations.Component;

@Component(service={LazyWidgetPage.class}, property={"org.ogema.widgets.page.baseurl=/de/iwes/ogema/apps/remotemessagereceiver", "org.ogema.widgets.page.pageurl=messageoverview.html", "org.ogema.widgets.page.startpage=true", "org.ogema.widgets.page.menuentry=Message Overview"})
public class MessageOverviewPage
implements LazyWidgetPage {
    static final String TIMESTAMP = "timestamp";
    static final String SENDER_GW = "senderGW";
    static final String SENDER_APP = "senderApp";
    static final String SUBJECT = "subject";
    static final String BODY = "body";
    static final String PRIO = "priority";
    static final String TIMESTAMP_HEADLINE = "Timestamp";
    static final String SENDER_GW_HEADLINE = "Sender Gateway";
    static final String SENDER_APP_HEADLINE = "Sender App";
    static final String SUBJECT_HEADLINE = "Subject";
    static final String BODY_HEADLINE = "Message Body";
    static final String PRIO_HEADLINE = "Priority";
    private ApplicationManager appMan;
    private HashMap<Long, RemoteMessage> messages = new HashMap();
    private HashMap<Long, RemoteMessage> filteredMessages = new HashMap();
    private ArrayList<String> allGws = new ArrayList();
    private long startTime;
    private long endTime;

    public void init(ApplicationManager appMan, WidgetPage<?> page) {
        this.appMan = appMan;
        this.getAllRemoteMessages();
        this.getStartEndTimestamps();
        ResourceList clientDatas = (ResourceList)appMan.getResourceAccess().getResource("clientData");
        if (clientDatas != null) {
            clientDatas.getAllElements().forEach(element -> this.allGws.add(element.userName().getValue()));
        }
        Header header = new Header(page, "header", "Remote Receiver App - Messages");
        header.addDefaultStyle(WidgetData.TEXT_ALIGNMENT_CENTERED);
        final RemoteMessagePopup popup = new RemoteMessagePopup(page, "msgPopup");
        popup.initialize();
        MessageTable table = new MessageTable(page, "messagesTable"){
            private static final long serialVersionUID = 1L;

            public void onPOSTComplete(String data, OgemaHttpRequest req) {
                String currentId = this.getSelectedRow(req);
                RemoteMessage currentMessage = null;
                if (currentId != null) {
                    currentMessage = (RemoteMessage)MessageOverviewPage.this.messages.get(Long.parseLong(currentId));
                }
                popup.setCurrentMessage(currentMessage, req);
            }
        };
        table.triggerAction((OgemaWidget)popup, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        TemplateMultiselect<String> gwMultiSelect = new TemplateMultiselect<String>(page, "gwMultiSelect"){
            private static final long serialVersionUID = 1L;

            public void onGET(OgemaHttpRequest req) {
                MessageOverviewPage.this.allGws.forEach(gw -> this.addItem(gw, req));
            }
        };
        gwMultiSelect.setDefaultWidth("100%");
        gwMultiSelect.selectDefaultItems(null);
        MultiSelectExtended gwSelection = new MultiSelectExtended(page, "gwSelection", (TemplateMultiselect)gwMultiSelect, true, "", true, false);
        Datepicker startDatePicker = new Datepicker(page, "startDatePicker");
        startDatePicker.triggerAction((OgemaWidget)table, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        Datepicker endDatePicker = new Datepicker(page, "endDatePicker");
        endDatePicker.triggerAction((OgemaWidget)table, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        page.append((OgemaWidget)header).linebreak().append((OgemaWidget)gwSelection).append((OgemaWidget)startDatePicker).append((OgemaWidget)endDatePicker).append((OgemaWidget)table).linebreak().append((OgemaWidget)popup);
    }

    private void getStartEndTimestamps() {
        this.startTime = (Long)this.messages.keySet().stream().min(Long::compare).get();
        this.endTime = (Long)this.messages.keySet().stream().max(Long::compare).get();
    }

    private void getAllRemoteMessages() {
        for (RemoteMessage remoteMessage : this.appMan.getResourceAccess().getResources(RemoteMessage.class)) {
            this.messages.put(remoteMessage.timestamp().getValue(), remoteMessage);
        }
    }

    private HashMap<Long, RemoteMessage> filterMessages() {
        return this.filteredMessages;
    }

    private Map<String, Map<String, String>> getMessagesMap(Map<Long, RemoteMessage> originalMessages) {
        LinkedHashMap<String, Map<String, String>> result = new LinkedHashMap<String, Map<String, String>>();
        if (originalMessages == null) {
            return result;
        }
        for (Map.Entry<Long, RemoteMessage> entry : originalMessages.entrySet()) {
            long time = entry.getKey();
            RemoteMessage msg = entry.getValue();
            Resource parentParent = msg.getParent() != null ? msg.getParent().getParent() : null;
            String gw = parentParent != null ? parentParent.getName() : "Unknown";
            LinkedHashMap<String, String> columns = new LinkedHashMap<String, String>();
            columns.put(TIMESTAMP, MessageOverviewPage.getTimeString(time));
            columns.put(SENDER_GW, gw);
            columns.put(SENDER_APP, msg.sender().getValue());
            columns.put(SUBJECT, msg.subject().getValue());
            columns.put(PRIO, String.valueOf(msg.priority().getValue()));
            result.put(String.valueOf(time), columns);
        }
        return result;
    }

    private Map<String, String> getColumnTitles() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(TIMESTAMP, TIMESTAMP_HEADLINE);
        map.put(SENDER_GW, SENDER_GW_HEADLINE);
        map.put(SENDER_APP, SENDER_APP_HEADLINE);
        map.put(SUBJECT, SUBJECT_HEADLINE);
        map.put(PRIO, PRIO_HEADLINE);
        return map;
    }

    static String getTimeString(long tm) {
        Date date = new Date(tm);
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
    }

    class MessageTable
    extends DataTable {
        private static final long serialVersionUID = 1L;

        public MessageTable(WidgetPage<?> page, String id) {
            super(page, id);
        }

        public void onGET(OgemaHttpRequest req) {
            this.clear(req);
            Map rows = MessageOverviewPage.this.getMessagesMap(MessageOverviewPage.this.messages);
            this.addRows(rows, req);
            Map columns = MessageOverviewPage.this.getColumnTitles();
            this.setColumnTitles(columns, req);
        }
    }
}

