/*
 * Decompiled with CFR 0.152.
 */
package de.iee.sema.remote.message.connector;

import de.iee.sema.remote.message.forwarder.config.RemoteMessagePattern;
import de.iwes.widgets.api.messaging.Message;
import de.iwes.widgets.api.messaging.listener.MessageListener;
import de.iwes.widgets.api.messaging.listener.ReceivedMessage;
import de.iwes.widgets.api.widgets.localisation.OgemaLocale;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.ogema.core.application.Application;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.logging.OgemaLogger;
import org.ogema.core.resourcemanager.AccessPriority;
import org.ogema.core.resourcemanager.pattern.ResourcePatternAccess;
import org.ogema.serialization.jaxb.IntegerResource;
import org.ogema.serialization.jaxb.Resource;
import org.ogema.serialization.jaxb.StringResource;
import org.ogema.serialization.jaxb.TimeResource;
import org.osgi.service.component.annotations.Component;

@Component(service={Application.class, MessageListener.class})
public class RemoteMessageConnector
implements Application,
MessageListener {
    private ResourcePatternAccess patternAccess;
    private OgemaLogger logger;
    static final TrustStrategy TRUST_ALL = new TrustStrategy(){

        public boolean isTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            return true;
        }
    };

    public void start(ApplicationManager appMan) {
        this.patternAccess = appMan.getResourcePatternAccess();
        this.logger = appMan.getLogger();
    }

    public void newMessageAvailable(ReceivedMessage receivedMessage, List<String> recipients) {
        Message msg = receivedMessage.getOriginalMessage();
        StringResource subject = new StringResource();
        subject.setName("subject");
        subject.setType(org.ogema.core.model.simple.StringResource.class);
        subject.setValue(msg.title(null));
        subject.setDecorating(Boolean.valueOf(false));
        subject.setActive(Boolean.valueOf(true));
        StringResource message = new StringResource();
        message.setName("body");
        message.setType(org.ogema.core.model.simple.StringResource.class);
        message.setValue(msg.message(null));
        message.setDecorating(Boolean.valueOf(false));
        message.setActive(Boolean.valueOf(true));
        StringResource senderApp = new StringResource();
        senderApp.setName("sender");
        senderApp.setType(org.ogema.core.model.simple.StringResource.class);
        senderApp.setValue(receivedMessage.getAppId().getIDString());
        senderApp.setDecorating(Boolean.valueOf(false));
        senderApp.setActive(Boolean.valueOf(true));
        TimeResource timestamp = new TimeResource();
        long time = receivedMessage.getTimestamp();
        timestamp.setName("timestamp");
        timestamp.setType(org.ogema.core.model.simple.TimeResource.class);
        timestamp.setValue(time);
        timestamp.setDecorating(Boolean.valueOf(false));
        timestamp.setActive(Boolean.valueOf(true));
        IntegerResource prio = new IntegerResource();
        prio.setName("priority");
        prio.setType(org.ogema.core.model.simple.IntegerResource.class);
        prio.setValue(msg.priority().getPriority());
        prio.setDecorating(Boolean.valueOf(false));
        prio.setActive(Boolean.valueOf(true));
        Resource remoteMessage = new Resource();
        remoteMessage.setType("de.iee.sema.remote.message.receiver.model.RemoteMessage");
        remoteMessage.setName("message_" + time);
        remoteMessage.setDecorating(Boolean.valueOf(true));
        remoteMessage.setActive(Boolean.valueOf(true));
        List subResources = remoteMessage.getSubresources();
        subResources.add(subject);
        subResources.add(message);
        subResources.add(senderApp);
        subResources.add(timestamp);
        subResources.add(prio);
        StringWriter writer = new StringWriter();
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Resource.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.marshal((Object)remoteMessage, (Writer)writer);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        this.logger.debug("rest message (xml): " + writer.toString());
        List receivers = this.patternAccess.getPatterns(RemoteMessagePattern.class, AccessPriority.PRIO_LOWEST);
        CloseableHttpClient client = RemoteMessageConnector.getClient();
        for (String receiver : recipients) {
            RemoteMessagePattern rec = this.getReceiver(receiver, receivers);
            String restAddress = rec.restAddress.getValue();
            if (!restAddress.endsWith("/")) {
                restAddress = restAddress + "/";
            }
            String restUser = rec.restUser.getValue();
            String restUrl = restAddress + restUser + "/messages";
            this.logger.debug("rest adress: {}", (Object)restUrl);
            HttpPost post = new HttpPost(restUrl);
            post.setEntity((HttpEntity)new StringEntity(writer.getBuffer().toString(), ContentType.APPLICATION_XML));
            String auth0 = restUser + ":" + rec.restPassword.getValue();
            String auth1 = "Basic " + Base64.getEncoder().encodeToString(auth0.getBytes(StandardCharsets.UTF_8));
            post.setHeader("Authorization", auth1);
            try {
                CloseableHttpResponse resp = client.execute((HttpUriRequest)post);
                int code = resp.getStatusLine().getStatusCode();
                this.logger.debug("Remote message sent: Http-code: {}", (Object)code);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected static CloseableHttpClient getClient() {
        SSLContext ctx;
        try {
            ctx = SSLContexts.custom().loadTrustMaterial((org.apache.http.ssl.TrustStrategy)TRUST_ALL).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
        CloseableHttpClient httpClient = HttpClients.custom().setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).setSslcontext(ctx).build();
        return httpClient;
    }

    private RemoteMessagePattern getReceiver(String receiver, List<RemoteMessagePattern> receivers) {
        for (RemoteMessagePattern pat : receivers) {
            if (!pat.userName.getValue().equals(receiver)) continue;
            return pat;
        }
        return null;
    }

    public List<String> getKnownUsers() {
        if (this.patternAccess == null) {
            return Collections.emptyList();
        }
        List receivers = this.patternAccess.getPatterns(RemoteMessagePattern.class, AccessPriority.PRIO_LOWEST);
        ArrayList<String> users = new ArrayList<String>();
        for (RemoteMessagePattern pattern : receivers) {
            users.add(pattern.userName.getValue());
        }
        return users;
    }

    public String getId() {
        return "Remote-Message-connector";
    }

    public String getDescription(OgemaLocale locale) {
        return "This service serializes messages and forwards them to a given rest server";
    }

    public void stop(Application.AppStopReason arg0) {
        this.patternAccess = null;
        this.logger = null;
    }
}

