/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.apps.messaging.test;

import de.iwes.widgets.api.messaging.Message;
import de.iwes.widgets.api.messaging.MessagePriority;
import de.iwes.widgets.api.services.MessagingService;
import de.iwes.widgets.api.widgets.OgemaWidget;
import de.iwes.widgets.api.widgets.WidgetGroup;
import de.iwes.widgets.api.widgets.WidgetPage;
import de.iwes.widgets.api.widgets.dynamics.TriggeredAction;
import de.iwes.widgets.api.widgets.dynamics.TriggeringAction;
import de.iwes.widgets.api.widgets.html.HtmlItem;
import de.iwes.widgets.api.widgets.html.StaticTable;
import de.iwes.widgets.api.widgets.sessionmanagement.OgemaHttpRequest;
import de.iwes.widgets.html.alert.Alert;
import de.iwes.widgets.html.form.button.Button;
import de.iwes.widgets.html.form.dropdown.Dropdown;
import de.iwes.widgets.html.form.dropdown.DropdownOption;
import de.iwes.widgets.html.form.label.Header;
import de.iwes.widgets.html.form.label.HeaderData;
import de.iwes.widgets.html.form.label.Label;
import de.iwes.widgets.html.form.textfield.TextField;
import de.iwes.widgets.html.textarea.TextArea;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.concurrent.RejectedExecutionException;
import org.ogema.apps.messaging.test.MessageImpl;
import org.ogema.core.application.ApplicationManager;

public class PageBuilder {
    private final Header header;
    private final Alert alert;
    private final Label subjectLabel;
    private final Label bodyLabel;
    private final Label prioLabel;
    private final TextField subject;
    private final TextArea body;
    private final Dropdown prio;
    private final Button send;
    private final WidgetGroup dataGroup;

    public PageBuilder(WidgetPage<?> page, final MessagingService service, final ApplicationManager am) {
        this.header = new Header(page, "header", "Messaging Test");
        this.header.addDefaultStyle(HeaderData.CENTERED);
        page.append((OgemaWidget)this.header).linebreak();
        this.alert = new Alert(page, "alert", "");
        this.alert.setDefaultVisibility(false);
        page.append((OgemaWidget)this.alert).linebreak();
        this.subjectLabel = new Label(page, "subjectLabel", "Subject");
        this.bodyLabel = new Label(page, "bodyLabel", "Body");
        this.prioLabel = new Label(page, "prioLabel", "Priority");
        this.subject = new TextField(page, "subject");
        this.body = new TextArea(page, "body");
        this.prio = new Dropdown(page, "prio");
        ArrayList<DropdownOption> opts = new ArrayList<DropdownOption>();
        for (MessagePriority pr : MessagePriority.values()) {
            opts.add(PageBuilder.getOpt(pr.name()));
        }
        ((DropdownOption)opts.get(0)).select(true);
        this.prio.setDefaultOptions(opts);
        Comparator<DropdownOption> cmp = new Comparator<DropdownOption>(){

            @Override
            public int compare(DropdownOption o1, DropdownOption o2) {
                String b;
                String a = o1.id();
                if (a.equals(b = o2.id())) {
                    return 0;
                }
                MessagePriority prio1 = MessagePriority.valueOf((String)a);
                MessagePriority prio2 = MessagePriority.valueOf((String)b);
                return prio1.compareTo((Enum)prio2);
            }
        };
        this.prio.setComparator((Comparator)cmp);
        this.send = new Button(page, "send", "Send"){
            private static final long serialVersionUID = 1L;

            public void onPOSTComplete(String data, OgemaHttpRequest req) {
                String subj = PageBuilder.this.subject.getValue(req);
                String bod = PageBuilder.this.body.getText(req);
                MessagePriority pr = MessagePriority.LOW;
                try {
                    pr = MessagePriority.valueOf((String)PageBuilder.this.prio.getSelectedValue(req));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                MessageImpl msg = new MessageImpl(subj, bod, pr);
                try {
                    service.sendMessage(am, (Message)msg);
                    PageBuilder.this.alert.showAlert("Message sent", true, req);
                }
                catch (RejectedExecutionException e) {
                    PageBuilder.this.alert.showAlert("Message could not be sent: " + e, false, req);
                }
            }
        };
        ArrayList<Object> datawidgets = new ArrayList<Object>();
        datawidgets.add(this.subject);
        datawidgets.add(this.body);
        datawidgets.add(this.prio);
        this.dataGroup = page.registerWidgetGroup("dataGroup", datawidgets);
        this.dataGroup.setDefaultSendValueOnChange(false);
        StaticTable table = new StaticTable(4, 2, new int[]{2, 2});
        table.setContent(0, 0, (OgemaWidget)this.subjectLabel).setContent(0, 1, (OgemaWidget)this.subject).setContent(1, 0, (OgemaWidget)this.bodyLabel).setContent(1, 1, (OgemaWidget)this.body).setContent(2, 0, (OgemaWidget)this.prioLabel).setContent(2, 1, (OgemaWidget)this.prio).setContent(3, 1, (OgemaWidget)this.send);
        page.append((HtmlItem)table);
        this.setDependencies();
    }

    private void setDependencies() {
        this.send.triggerAction(this.dataGroup, TriggeringAction.PRE_POST_REQUEST, TriggeredAction.POST_REQUEST);
        this.send.triggerAction((OgemaWidget)this.alert, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
    }

    private static DropdownOption getOpt(String value) {
        return new DropdownOption(value, value, false);
    }
}

