/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.messaging.basic.services.config.template;

import de.iwes.widgets.api.extended.OgemaWidgetBase;
import de.iwes.widgets.api.extended.html.bricks.PageSnippet;
import de.iwes.widgets.api.widgets.OgemaWidget;
import de.iwes.widgets.api.widgets.WidgetPage;
import de.iwes.widgets.api.widgets.dynamics.TriggeredAction;
import de.iwes.widgets.api.widgets.dynamics.TriggeringAction;
import de.iwes.widgets.api.widgets.html.HtmlItem;
import de.iwes.widgets.api.widgets.html.StaticTable;
import de.iwes.widgets.api.widgets.sessionmanagement.OgemaHttpRequest;
import de.iwes.widgets.html.alert.Alert;
import de.iwes.widgets.html.buttonconfirm.ButtonConfirm;
import de.iwes.widgets.html.complextable.DynamicTable;
import de.iwes.widgets.html.complextable.RowTemplate;
import de.iwes.widgets.html.form.button.Button;
import de.iwes.widgets.html.form.button.ButtonData;
import de.iwes.widgets.html.form.label.Label;
import de.iwes.widgets.html.form.textfield.TextField;
import de.iwes.widgets.html.popup.Popup;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.logging.OgemaLogger;
import org.ogema.core.model.ResourceList;
import org.ogema.core.resourcemanager.ResourceAccess;
import org.ogema.messaging.basic.services.config.model.SmsConfiguration;
import org.ogema.tools.resource.util.ResourceUtils;

public class SmsTemplate
extends RowTemplate<SmsConfiguration> {
    protected final ResourceList<SmsConfiguration> list;
    protected final DynamicTable<SmsConfiguration> table;
    protected final Alert alert;
    protected final WidgetPage<?> page;
    protected final ApplicationManager am;
    protected final OgemaLogger logger;
    protected final ResourceAccess ra;

    public SmsTemplate(ResourceList<SmsConfiguration> list, ApplicationManager am, DynamicTable<SmsConfiguration> table, Alert alert, WidgetPage<?> page) {
        this.list = list;
        this.table = table;
        this.alert = alert;
        this.page = page;
        this.am = am;
        this.logger = am.getLogger();
        this.ra = am.getResourceAccess();
    }

    public Map<String, Object> getHeader() {
        LinkedHashMap<String, Object> smsHeader = new LinkedHashMap<String, Object>();
        smsHeader.put("nameColumn", "Name:");
        smsHeader.put("smsColumn", "Sms-email-address:");
        smsHeader.put("passwordColumn", "Password:");
        smsHeader.put("hostColumn", "Server-URL:");
        smsHeader.put("portColumn", "Port:");
        smsHeader.put("editPopupColumn", "");
        smsHeader.put("editColumn", "");
        smsHeader.put("deleteColumn", "");
        return smsHeader;
    }

    public String getLineId(SmsConfiguration object) {
        return ResourceUtils.getValidResourceName((String)object.userName().getValue());
    }

    public RowTemplate.Row addRow(final SmsConfiguration config, OgemaHttpRequest req) {
        RowTemplate.Row row = new RowTemplate.Row();
        final String id = this.getLineId(config);
        Label nameLabel = new Label(this.page, "nameLabel_" + id, true){

            public void onGET(OgemaHttpRequest req) {
                this.setText(config.userName().getValue(), req);
            }
        };
        row.addCell("nameColumn", (Object)nameLabel);
        Label smsLabel = new Label(this.page, "smsLabel_" + id, true){

            public void onGET(OgemaHttpRequest req) {
                this.setText(config.smsEmail().getValue(), req);
            }
        };
        row.addCell("smsColumn", (Object)smsLabel);
        Label passwordLabel = new Label(this.page, "passwordLabel_" + id, true){

            public void onGET(OgemaHttpRequest req) {
                this.setText(config.smsEmailPassword().getValue(), req);
            }
        };
        row.addCell("smsEmailPasswordColumn", (Object)passwordLabel);
        Label hostLabel = new Label(this.page, "hostLabel_" + id, true){

            public void onGET(OgemaHttpRequest req) {
                this.setText(config.smsEmailServer().getValue(), req);
            }
        };
        row.addCell("hostColumn", (Object)hostLabel);
        Label portLabel = new Label(this.page, "portLabel_" + id, true){

            public void onGET(OgemaHttpRequest req) {
                this.setText(String.valueOf(config.smsEmailPort().getValue()), req);
            }
        };
        row.addCell("portColumn", (Object)portLabel);
        Label editNameLabel = new Label(this.page, "editNameLabel_" + id, true);
        editNameLabel.setDefaultText("Name:");
        Label editSmsLabel = new Label(this.page, "editSmsLabel_" + id, true);
        editSmsLabel.setDefaultText("New sms-email-address:");
        Label editPasswordLabel = new Label(this.page, "editPasswordLabel_" + id, true);
        editPasswordLabel.setDefaultText("New password:");
        Label editHostLabel = new Label(this.page, "editHostLabel_" + id, true);
        editHostLabel.setDefaultText("New server-URL:");
        Label editPortLabel = new Label(this.page, "editPortLabel_" + id, true);
        editPortLabel.setDefaultText("New port:");
        final TextField editSmsTextField = new TextField(this.page, "smsTextField_" + id, true){

            public void onGET(OgemaHttpRequest req) {
                this.setValue(config.smsEmail().getValue(), req);
            }
        };
        final TextField editPasswordTextField = new TextField(this.page, "passwordTextField_" + id, true){

            public void onGET(OgemaHttpRequest req) {
                this.setValue(config.smsEmailPassword().getValue(), req);
            }
        };
        final TextField editHostTextField = new TextField(this.page, "hostTextField_" + id, true){

            public void onGET(OgemaHttpRequest req) {
                this.setValue(config.smsEmailServer().getValue(), req);
            }
        };
        final TextField editPortTextField = new TextField(this.page, "portTextField_" + id, true){

            public void onGET(OgemaHttpRequest req) {
                this.setValue(String.valueOf(config.smsEmailPort().getValue()), req);
            }
        };
        Popup editUserPopup = new Popup(this.page, "editUserPopup_" + id, true);
        editUserPopup.setTitle("Edit User", null);
        row.addCell("editPopupColumn", (Object)editUserPopup);
        Button editUserButton = new Button(this.page, "editSmsUserButton" + id);
        editUserButton.triggerAction(this.table, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        editUserButton.triggerAction((OgemaWidget)editUserPopup, TriggeringAction.POST_REQUEST, TriggeredAction.SHOW_WIDGET);
        editUserButton.triggerAction((OgemaWidget)editSmsTextField, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        editUserButton.triggerAction((OgemaWidget)editPasswordTextField, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        editUserButton.triggerAction((OgemaWidget)editHostTextField, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        editUserButton.triggerAction((OgemaWidget)editPortTextField, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        editUserButton.addDefaultStyle(ButtonData.BOOTSTRAP_GREEN);
        editUserButton.setDefaultText("Edit");
        row.addCell("editColumn", (Object)editUserButton);
        ButtonConfirm confirmSmsChangesButton = new ButtonConfirm(this.page, "confirmSmsChangesButton_" + id){

            public void onPOSTComplete(String data, OgemaHttpRequest req) {
                String smsRegex = "[A-Za-z0-9]+[A-Za-z0-9.-]*[@][A-Za-z0-9.-]+[.][a-zA-Z_0-9]+$";
                String serverRegex = "[A-Za-z0-9.-]+[.][A-Za-z0-9.-]+[.][a-zA-Z_0-9]+$";
                String portRegex = "[0-9]{1,5}$";
                String serverPort = editPortTextField.getValue(req);
                String sms = editSmsTextField.getValue(req);
                String host = editHostTextField.getValue(req);
                String pw = editPasswordTextField.getValue(req);
                int port = 70000;
                if (serverPort.matches(portRegex)) {
                    port = Integer.parseInt(serverPort);
                }
                if (port <= 65535 && sms.matches(smsRegex) && host.matches(serverRegex) && !pw.isEmpty()) {
                    config.smsEmail().setValue(sms);
                    config.smsEmailPassword().setValue(pw);
                    config.smsEmailServer().setValue(host);
                    config.smsEmailPort().setValue(port);
                    SmsTemplate.this.alert.showAlert("Changes on User '" + id + "' confirmed", true, req);
                } else {
                    if (port > 65535) {
                        SmsTemplate.this.alert.showAlert("Invalid Port", false, req);
                    }
                    if (!sms.matches(smsRegex)) {
                        SmsTemplate.this.alert.showAlert("Invalid sms-email-Address", false, req);
                    }
                    if (!host.matches(serverRegex)) {
                        SmsTemplate.this.alert.showAlert("Invalid server-URL", false, req);
                    }
                    if (pw.isEmpty()) {
                        SmsTemplate.this.alert.showAlert("No password entered", false, req);
                    }
                }
            }
        };
        confirmSmsChangesButton.triggerAction((OgemaWidget)smsLabel, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        confirmSmsChangesButton.triggerAction((OgemaWidget)editUserPopup, TriggeringAction.POST_REQUEST, TriggeredAction.HIDE_WIDGET);
        confirmSmsChangesButton.triggerAction((OgemaWidget)smsLabel, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        confirmSmsChangesButton.triggerAction((OgemaWidget)passwordLabel, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        confirmSmsChangesButton.triggerAction((OgemaWidget)hostLabel, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        confirmSmsChangesButton.triggerAction((OgemaWidget)portLabel, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        confirmSmsChangesButton.triggerAction((OgemaWidget)this.alert, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        confirmSmsChangesButton.setDefaultText("Save Changes");
        confirmSmsChangesButton.setDefaultConfirmPopupTitle("Edit " + id);
        confirmSmsChangesButton.setDefaultConfirmMsg("Accept changes ?");
        confirmSmsChangesButton.addDefaultStyle(ButtonData.BOOTSTRAP_GREEN);
        StaticTable editUserTable = new StaticTable(5, 2);
        editUserTable.setContent(0, 0, (OgemaWidget)editNameLabel);
        editUserTable.setContent(1, 0, (OgemaWidget)editSmsLabel);
        editUserTable.setContent(2, 0, (OgemaWidget)editPasswordLabel);
        editUserTable.setContent(3, 0, (OgemaWidget)editHostLabel);
        editUserTable.setContent(4, 0, (OgemaWidget)editPortLabel);
        editUserTable.setContent(0, 1, config.userName().getValue());
        editUserTable.setContent(1, 1, (OgemaWidget)editSmsTextField);
        editUserTable.setContent(2, 1, (OgemaWidget)editPasswordTextField);
        editUserTable.setContent(3, 1, (OgemaWidget)editHostTextField);
        editUserTable.setContent(4, 1, (OgemaWidget)editPortTextField);
        PageSnippet editUserSnippet = new PageSnippet(this.page, "editUserSnippet" + id, true);
        editUserSnippet.append((HtmlItem)editUserTable, null);
        editUserSnippet.append((OgemaWidget)confirmSmsChangesButton, null);
        editUserPopup.setBody((OgemaWidgetBase)editUserSnippet, null);
        ButtonConfirm deleteSmsUserButton = new ButtonConfirm(this.page, "deleteSmsUserButton_" + id){

            public void onPOSTComplete(String data, OgemaHttpRequest req) {
                config.delete();
                SmsTemplate.this.alert.showAlert("User '" + id + "' successfully deleted", true, req);
            }
        };
        deleteSmsUserButton.addDefaultStyle(ButtonData.BOOTSTRAP_RED);
        deleteSmsUserButton.setDefaultText("Delete");
        deleteSmsUserButton.setDefaultConfirmPopupTitle("Delete sms-user: " + id);
        deleteSmsUserButton.setDefaultConfirmMsg("Do you really want to delete '" + id + "' from this list ?");
        deleteSmsUserButton.triggerAction(this.table, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        deleteSmsUserButton.triggerAction((OgemaWidget)this.alert, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        row.addCell("deleteColumn", (Object)deleteSmsUserButton);
        return row;
    }
}

