/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.messaging.basic.services.config.template;

import de.iwes.widgets.api.extended.OgemaWidgetBase;
import de.iwes.widgets.api.extended.html.bricks.PageSnippet;
import de.iwes.widgets.api.widgets.OgemaWidget;
import de.iwes.widgets.api.widgets.WidgetPage;
import de.iwes.widgets.api.widgets.dynamics.TriggeredAction;
import de.iwes.widgets.api.widgets.dynamics.TriggeringAction;
import de.iwes.widgets.api.widgets.html.HtmlItem;
import de.iwes.widgets.api.widgets.html.StaticTable;
import de.iwes.widgets.api.widgets.sessionmanagement.OgemaHttpRequest;
import de.iwes.widgets.html.alert.Alert;
import de.iwes.widgets.html.buttonconfirm.ButtonConfirm;
import de.iwes.widgets.html.complextable.DynamicTable;
import de.iwes.widgets.html.complextable.RowTemplate;
import de.iwes.widgets.html.form.button.Button;
import de.iwes.widgets.html.form.button.ButtonData;
import de.iwes.widgets.html.form.label.Label;
import de.iwes.widgets.html.form.textfield.TextField;
import de.iwes.widgets.html.popup.Popup;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.logging.OgemaLogger;
import org.ogema.core.model.ResourceList;
import org.ogema.core.resourcemanager.ResourceAccess;
import org.ogema.core.resourcemanager.ResourceManagement;
import org.ogema.messaging.basic.services.config.model.ReceiverConfiguration;
import org.ogema.tools.resource.util.ResourceUtils;

public class ReceiverTemplate
extends RowTemplate<ReceiverConfiguration> {
    private final String EMAIL_REGEX = "[A-Za-z0-9.-]+[@][A-Za-z0-9.-]+[.][a-zA-Z_0-9]+$";
    private final String SMS_REGEX = "[0-9]+[A-Za-z0-9.-]+[@][A-Za-z0-9.-]+[.][a-zA-Z_0-9]+$";
    protected final ResourceList<ReceiverConfiguration> receiverConfigs;
    protected final DynamicTable<ReceiverConfiguration> receiverTable;
    protected final Alert alert;
    protected final WidgetPage<?> page;
    protected final ApplicationManager am;
    protected final OgemaLogger logger;
    protected final ResourceAccess ra;
    protected final ResourceManagement resMan;

    public ReceiverTemplate(ResourceList<ReceiverConfiguration> list, ApplicationManager am, DynamicTable<ReceiverConfiguration> table, Alert alert, WidgetPage<?> page) {
        this.receiverConfigs = list;
        this.receiverTable = table;
        this.alert = alert;
        this.page = page;
        this.am = am;
        this.logger = am.getLogger();
        this.ra = am.getResourceAccess();
        this.resMan = am.getResourceManagement();
    }

    public Map<String, Object> getHeader() {
        LinkedHashMap<String, Object> receiverHeader = new LinkedHashMap<String, Object>();
        receiverHeader.put("receiverNameColumn", "Name:");
        receiverHeader.put("receiverEMailColumn", "Email-address:");
        receiverHeader.put("receiverSmsColumn", "Sms-address:");
        receiverHeader.put("receiverXmppColumn", "Xmpp-address:");
        receiverHeader.put("receiverRESTColumn", "REST-address:");
        receiverHeader.put("receiverRESTUserColumn", "REST-user:");
        receiverHeader.put("receiverRESTPwColumn", "REST-password:");
        receiverHeader.put("editReceiverPopupColumn", "");
        receiverHeader.put("editReceiverButtonColumn", "");
        receiverHeader.put("deleteReceiverButtonColumn", "");
        return receiverHeader;
    }

    public String getLineId(ReceiverConfiguration object) {
        return ResourceUtils.getValidResourceName((String)object.userName().getValue());
    }

    public RowTemplate.Row addRow(final ReceiverConfiguration config, OgemaHttpRequest req) {
        RowTemplate.Row row = new RowTemplate.Row();
        final String id = this.getLineId(config);
        Label newReceiverNameLabel = new Label(this.page, "newReceiverNameLabel_" + id, true);
        newReceiverNameLabel.setDefaultText(config.userName().getValue());
        row.addCell("receiverNameColumn", (Object)newReceiverNameLabel);
        Label newEMailLabel = new Label(this.page, "newEMailLabel_" + id, true){

            public void onGET(OgemaHttpRequest req) {
                if (config.email().exists()) {
                    this.setText(config.email().getValue(), req);
                } else {
                    this.setText("", req);
                }
            }
        };
        row.addCell("receiverEMailColumn", (Object)newEMailLabel);
        Label newSmsLabel = new Label(this.page, "newSmsLabel_" + id, true){

            public void onGET(OgemaHttpRequest req) {
                if (config.sms().exists()) {
                    this.setText(config.sms().getValue(), req);
                } else {
                    this.setText("", req);
                }
            }
        };
        row.addCell("receiverSmsColumn", (Object)newSmsLabel);
        Label newXmppLabel = new Label(this.page, "newXmppLabel_" + id, true){

            public void onGET(OgemaHttpRequest req) {
                if (config.xmpp().exists()) {
                    this.setText(config.xmpp().getValue(), req);
                } else {
                    this.setText("", req);
                }
            }
        };
        newXmppLabel.setDefaultText(config.xmpp().getValue());
        row.addCell("receiverXmppColumn", (Object)newXmppLabel);
        Label newRESTLabel = new Label(this.page, "newRESTLabel_" + id, true){

            public void onGET(OgemaHttpRequest req) {
                if (config.remoteMessageRestUrl().exists()) {
                    this.setText(config.remoteMessageRestUrl().getValue(), req);
                } else {
                    this.setText("", req);
                }
            }
        };
        newRESTLabel.setDefaultText(config.remoteMessageRestUrl().getValue());
        row.addCell("receiverRESTColumn", (Object)newRESTLabel);
        Label newRESTUserLabel = new Label(this.page, "newRESTUserLabel_" + id, true){

            public void onGET(OgemaHttpRequest req) {
                if (config.remoteMessageUser().exists()) {
                    this.setText(config.remoteMessageUser().getValue(), req);
                } else {
                    this.setText("", req);
                }
            }
        };
        newRESTUserLabel.setDefaultText(config.remoteMessageUser().getValue());
        row.addCell("receiverRESTUserColumn", (Object)newRESTUserLabel);
        Label newRESTPwLabel = new Label(this.page, "newRESTPwLabel_" + id, true){

            public void onGET(OgemaHttpRequest req) {
                if (config.xmpp().exists()) {
                    this.setText(config.remoteMessagePassword().getValue(), req);
                } else {
                    this.setText("", req);
                }
            }
        };
        newRESTPwLabel.setDefaultText(config.remoteMessagePassword().getValue());
        row.addCell("receiverRESTPwColumn", (Object)newRESTPwLabel);
        Label editNameLabel = new Label(this.page, "editNameLabel_" + id, true);
        editNameLabel.setDefaultText("Name: ");
        Label editEMailLabel = new Label(this.page, "editEMailLabel_" + id, true);
        editEMailLabel.setDefaultText("New email-address: ");
        Label editSmsLabel = new Label(this.page, "editSmsLabel_" + id, true);
        editSmsLabel.setDefaultText("New sms-number: ");
        Label editXmppLabel = new Label(this.page, "editXmppLabel_" + id, true);
        editXmppLabel.setDefaultText("New xmpp-address: ");
        Label editRESTLabel = new Label(this.page, "editRESTLabel_" + id, true);
        editRESTLabel.setDefaultText("New rest-address: ");
        Label editRESTUserLabel = new Label(this.page, "editRESTUserLabel_" + id, true);
        editRESTUserLabel.setDefaultText("New rest-user: ");
        Label editRESTPwLabel = new Label(this.page, "editRESTPwLabel_" + id, true);
        editRESTPwLabel.setDefaultText("New rest-password: ");
        final TextField editEMailTextField = new TextField(this.page, "editEMailTextField_" + id, true){
            private static final long serialVersionUID = 1L;

            public void onGET(OgemaHttpRequest req) {
                if (config.email().exists()) {
                    this.setValue(config.email().getValue(), req);
                } else {
                    this.setValue("", req);
                }
            }
        };
        final TextField editSmsTextField = new TextField(this.page, "editSmsTextField_" + id, true){

            public void onGET(OgemaHttpRequest req) {
                if (config.sms().exists()) {
                    this.setValue(config.sms().getValue(), req);
                } else {
                    this.setValue("", req);
                }
            }
        };
        final TextField editXmppTextField = new TextField(this.page, "editXmppTextField_" + id, true){

            public void onGET(OgemaHttpRequest req) {
                if (config.xmpp().exists()) {
                    this.setValue(config.xmpp().getValue(), req);
                } else {
                    this.setValue("", req);
                }
            }
        };
        final TextField editRESTTextField = new TextField(this.page, "editRESTTextField_" + id, true){

            public void onGET(OgemaHttpRequest req) {
                if (config.remoteMessageRestUrl().exists()) {
                    this.setValue(config.remoteMessageRestUrl().getValue(), req);
                } else {
                    this.setValue("", req);
                }
            }
        };
        final TextField editRESTUserTextField = new TextField(this.page, "editRESTUserTextField_" + id, true){

            public void onGET(OgemaHttpRequest req) {
                if (config.remoteMessageUser().exists()) {
                    this.setValue(config.remoteMessageUser().getValue(), req);
                } else {
                    this.setValue("", req);
                }
            }
        };
        final TextField editRESTPwTextField = new TextField(this.page, "editRESTPwTextField_" + id, true){

            public void onGET(OgemaHttpRequest req) {
                if (config.remoteMessagePassword().exists()) {
                    this.setValue(config.remoteMessagePassword().getValue(), req);
                } else {
                    this.setValue("", req);
                }
            }
        };
        Popup editReceiverPopup = new Popup(this.page, "ediReceiverPopup_" + id, true);
        editReceiverPopup.setTitle("Edit receiver ", null);
        row.addCell("editReceiverPopupColumn", (Object)editReceiverPopup);
        StaticTable editReceiverTable = new StaticTable(7, 2);
        editReceiverTable.setContent(0, 0, (OgemaWidget)editNameLabel);
        editReceiverTable.setContent(1, 0, (OgemaWidget)editEMailLabel);
        editReceiverTable.setContent(2, 0, (OgemaWidget)editSmsLabel);
        editReceiverTable.setContent(3, 0, (OgemaWidget)editXmppLabel);
        editReceiverTable.setContent(4, 0, (OgemaWidget)editRESTLabel);
        editReceiverTable.setContent(5, 0, (OgemaWidget)editRESTUserLabel);
        editReceiverTable.setContent(6, 0, (OgemaWidget)editRESTPwLabel);
        editReceiverTable.setContent(0, 1, config.userName().getValue());
        editReceiverTable.setContent(1, 1, (OgemaWidget)editEMailTextField);
        editReceiverTable.setContent(2, 1, (OgemaWidget)editSmsTextField);
        editReceiverTable.setContent(3, 1, (OgemaWidget)editXmppTextField);
        editReceiverTable.setContent(4, 1, (OgemaWidget)editRESTTextField);
        editReceiverTable.setContent(5, 1, (OgemaWidget)editRESTUserTextField);
        editReceiverTable.setContent(6, 1, (OgemaWidget)editRESTPwTextField);
        Button editReceiverButton = new Button(this.page, "editReceiverButton" + id);
        editReceiverButton.triggerAction((OgemaWidget)editEMailTextField, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        editReceiverButton.triggerAction((OgemaWidget)editSmsTextField, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        editReceiverButton.triggerAction((OgemaWidget)editXmppTextField, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        editReceiverButton.triggerAction(this.receiverTable, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        editReceiverButton.triggerAction((OgemaWidget)editReceiverPopup, TriggeringAction.POST_REQUEST, TriggeredAction.SHOW_WIDGET);
        editReceiverButton.addDefaultStyle(ButtonData.BOOTSTRAP_GREEN);
        editReceiverButton.setDefaultText("Edit");
        row.addCell("editReceiverButtonColumn", (Object)editReceiverButton);
        ButtonConfirm confirmReceiverChangesButton = new ButtonConfirm(this.page, "confirmReceiverChangesButton_" + id){

            public void onPOSTComplete(String data, OgemaHttpRequest req) {
                String restPw;
                String restUser;
                String rest;
                String xmpp;
                String sms;
                String email = editEMailTextField.getValue(req).trim();
                if (this.changesAreValid(email, sms = editSmsTextField.getValue(req).trim(), xmpp = editXmppTextField.getValue(req).trim(), rest = editRESTTextField.getValue(req).trim(), restUser = editRESTUserTextField.getValue(req).trim(), restPw = editRESTPwTextField.getValue(req), req)) {
                    if (!email.isEmpty()) {
                        config.email().create();
                        config.email().setValue(email);
                        config.email().activate(true);
                    } else {
                        config.email().delete();
                    }
                    if (!sms.isEmpty()) {
                        config.sms().create();
                        config.sms().setValue(sms);
                        config.sms().activate(true);
                    } else {
                        config.sms().delete();
                    }
                    if (!xmpp.isEmpty()) {
                        config.xmpp().create();
                        config.xmpp().setValue(xmpp);
                        config.xmpp().activate(true);
                    } else {
                        config.xmpp().delete();
                    }
                    if (!rest.isEmpty()) {
                        config.remoteMessageRestUrl().create();
                        config.remoteMessageRestUrl().setValue(rest.endsWith("/") ? rest : rest + "/");
                        config.remoteMessageRestUrl().activate(true);
                    } else {
                        config.remoteMessageRestUrl().delete();
                    }
                    if (!restUser.isEmpty()) {
                        config.remoteMessageUser().create();
                        config.remoteMessageUser().setValue(restUser);
                        config.remoteMessageUser().activate(true);
                    } else {
                        config.remoteMessageUser().delete();
                    }
                    if (!restPw.isEmpty()) {
                        config.remoteMessagePassword().create();
                        config.remoteMessagePassword().setValue(restPw);
                        config.remoteMessagePassword().activate(true);
                    } else {
                        config.remoteMessagePassword().delete();
                    }
                    ReceiverTemplate.this.alert.showAlert("Changes on receiver '" + id + "' confirmed", true, req);
                }
            }

            public boolean changesAreValid(String email, String sms, String xmpp, String rest, String restUser, String restPw, OgemaHttpRequest req) {
                boolean emailAccepted = false;
                boolean smsAccepted = false;
                boolean xmppAccepted = false;
                boolean restAccepted = false;
                if (email.isEmpty() || email.matches("[A-Za-z0-9.-]+[@][A-Za-z0-9.-]+[.][a-zA-Z_0-9]+$")) {
                    emailAccepted = true;
                }
                if (sms.isEmpty() || sms.matches("[0-9]+[A-Za-z0-9.-]+[@][A-Za-z0-9.-]+[.][a-zA-Z_0-9]+$")) {
                    smsAccepted = true;
                }
                if (xmpp.isEmpty() || xmpp.matches("[A-Za-z0-9.-]+[@][A-Za-z0-9.-]+[.][a-zA-Z_0-9]+$")) {
                    xmppAccepted = true;
                }
                if (rest.isEmpty() && restUser.isEmpty() && restPw.isEmpty() || !restUser.isEmpty() && !restPw.isEmpty()) {
                    restAccepted = true;
                    try {
                        new URI(rest);
                    }
                    catch (Exception e) {
                        restAccepted = false;
                    }
                }
                if (emailAccepted && smsAccepted && xmppAccepted && restAccepted && restAccepted) {
                    return true;
                }
                if (!emailAccepted) {
                    ReceiverTemplate.this.alert.showAlert("Invalid email-address", false, req);
                } else if (!smsAccepted) {
                    ReceiverTemplate.this.alert.showAlert("Invalid sms-email-address. The address must have the format <Phonenumber-with-country-code-without beginning + or 0 signs>.<email-address of SMS-gateway>", false, req);
                } else if (!xmppAccepted) {
                    ReceiverTemplate.this.alert.showAlert("Invalid xmpp-address", false, req);
                } else if (!restAccepted) {
                    ReceiverTemplate.this.alert.showAlert("Invalid REST data. Enter values for all 3 inputfield or leave all empty.", false, req);
                } else {
                    ReceiverTemplate.this.alert.showAlert("Please enter atleast one address", false, req);
                }
                return false;
            }
        };
        confirmReceiverChangesButton.addDefaultStyle(ButtonData.BOOTSTRAP_GREEN);
        confirmReceiverChangesButton.setDefaultText("Save changes");
        confirmReceiverChangesButton.setDefaultConfirmPopupTitle("Edit '" + id + "'");
        confirmReceiverChangesButton.setDefaultConfirmMsg("Accept changes ?");
        confirmReceiverChangesButton.triggerAction((OgemaWidget)newEMailLabel, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        confirmReceiverChangesButton.triggerAction((OgemaWidget)newSmsLabel, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        confirmReceiverChangesButton.triggerAction((OgemaWidget)newXmppLabel, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        confirmReceiverChangesButton.triggerAction((OgemaWidget)newRESTLabel, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        confirmReceiverChangesButton.triggerAction((OgemaWidget)newRESTUserLabel, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        confirmReceiverChangesButton.triggerAction((OgemaWidget)newRESTPwLabel, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        confirmReceiverChangesButton.triggerAction(this.receiverTable, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        confirmReceiverChangesButton.triggerAction((OgemaWidget)this.alert, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        confirmReceiverChangesButton.triggerAction((OgemaWidget)editReceiverPopup, TriggeringAction.POST_REQUEST, TriggeredAction.HIDE_WIDGET);
        PageSnippet editReceiverSnippet = new PageSnippet(this.page, "editReceiverSnippet" + id, true);
        editReceiverSnippet.append((HtmlItem)editReceiverTable, null);
        editReceiverSnippet.append((OgemaWidget)confirmReceiverChangesButton, null);
        editReceiverPopup.setBody((OgemaWidgetBase)editReceiverSnippet, null);
        ButtonConfirm deleteReceiverButton = new ButtonConfirm(this.page, "deleteReceiverButton_" + id){

            public void onPOSTComplete(String data, OgemaHttpRequest req) {
                config.delete();
                ReceiverTemplate.this.receiverTable.removeRow(id, req);
                ReceiverTemplate.this.alert.showAlert("Receiver '" + id + "' successfully deleted", true, req);
            }
        };
        deleteReceiverButton.addDefaultStyle(ButtonData.BOOTSTRAP_RED);
        deleteReceiverButton.setDefaultText("Delete");
        deleteReceiverButton.setDefaultConfirmPopupTitle("Delete receiver '" + id + "'");
        deleteReceiverButton.setDefaultConfirmMsg("Do you really want to delete '" + id + "' from your list ?");
        deleteReceiverButton.triggerAction(this.receiverTable, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        deleteReceiverButton.triggerAction((OgemaWidget)this.alert, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        row.addCell("deleteReceiverButtonColumn", (Object)deleteReceiverButton);
        return row;
    }
}

