/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.apps.message.reader.gui;

import de.iwes.widgets.api.messaging.Message;
import de.iwes.widgets.api.messaging.listener.ReceivedMessage;
import de.iwes.widgets.api.widgets.OgemaWidget;
import de.iwes.widgets.api.widgets.WidgetPage;
import de.iwes.widgets.api.widgets.dynamics.TriggeredAction;
import de.iwes.widgets.api.widgets.dynamics.TriggeringAction;
import de.iwes.widgets.api.widgets.localisation.OgemaLocale;
import de.iwes.widgets.api.widgets.sessionmanagement.OgemaHttpRequest;
import de.iwes.widgets.html.datatable.DataTable;
import de.iwes.widgets.html.form.label.Header;
import de.iwes.widgets.html.form.label.HeaderData;
import de.iwes.widgets.messaging.MessageReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableMap;
import org.ogema.apps.message.reader.dictionary.MessagesDictionary;
import org.ogema.apps.message.reader.gui.MailPopup;

public class PageBuilder {
    private static final int MAX_MSG_LENGTH = 60;
    private static final int MAX_TITLE_LENGTH = 50;
    private final WidgetPage<MessagesDictionary> page;
    private final MessageReader mr;
    private final Header header;
    private final DataTable dataTable;
    private final MailPopup popup;

    public PageBuilder(final WidgetPage<MessagesDictionary> page, final MessageReader mr) {
        this.page = page;
        this.mr = mr;
        this.header = new Header(page, "mainPageHeader"){
            private static final long serialVersionUID = 1L;

            public void onGET(OgemaHttpRequest req) {
                MessagesDictionary dict = (MessagesDictionary)page.getDictionary(req);
                this.setText(dict.getTitle(), req);
            }
        };
        this.header.addDefaultStyle(HeaderData.CENTERED);
        page.append((OgemaWidget)this.header);
        this.popup = new MailPopup(page, "mailPopup");
        this.popup.initialize();
        this.dataTable = new MessageTable(page, "messagesTable"){
            private static final long serialVersionUID = 1L;

            public void onPOSTComplete(String data, OgemaHttpRequest req) {
                String currentId = this.getSelectedRow(req);
                ReceivedMessage currentMessage = null;
                if (currentId != null) {
                    currentMessage = mr.getMessage(Long.parseLong(currentId));
                }
                PageBuilder.this.popup.setCurrentMessage(currentMessage, req);
            }
        };
        this.dataTable.sortDefault(0, false);
        page.append((OgemaWidget)this.dataTable);
        page.append((OgemaWidget)this.popup);
        this.dataTable.triggerAction((OgemaWidget)this.popup, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
    }

    private Map<String, Map<String, String>> getMessagesMap(Map<Long, ReceivedMessage> originalMessages, OgemaLocale locale) {
        LinkedHashMap<String, Map<String, String>> result = new LinkedHashMap<String, Map<String, String>>();
        for (Map.Entry<Long, ReceivedMessage> entry : originalMessages.entrySet()) {
            long time = entry.getKey();
            ReceivedMessage msg = entry.getValue();
            Message omsg = msg.getOriginalMessage();
            LinkedHashMap<String, String> columns = new LinkedHashMap<String, String>();
            columns.put("time", PageBuilder.getTimeString(msg.getTimestamp()));
            columns.put("title", this.cutMsg(omsg.title(locale), 50));
            columns.put("msg", this.cutMsg(omsg.message(locale), 60));
            columns.put("prio", omsg.priority().name());
            columns.put("app", msg.getAppId().getIDString());
            columns.put("status", msg.getStatus().name());
            result.put(String.valueOf(time), columns);
        }
        return result;
    }

    private String cutMsg(String msg, int length) {
        if (msg == null || msg.length() < length) {
            return msg;
        }
        return msg.substring(0, length);
    }

    private Map<String, String> getColumnTitles(MessagesDictionary dict, OgemaLocale locale) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("time", dict.getColTitleTime());
        map.put("title", dict.getColTitleAbstract());
        map.put("msg", dict.getColTitleFull());
        map.put("prio", dict.getColTitlePrio());
        map.put("app", dict.getColTitleApp());
        map.put("status", dict.getColTitleStatuts());
        return map;
    }

    static String getTimeString(long tm) {
        Date date = new Date(tm);
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
    }

    class MessageTable
    extends DataTable {
        private static final long serialVersionUID = 1L;

        public MessageTable(WidgetPage<?> page, String id) {
            super(page, id);
        }

        public void onGET(OgemaHttpRequest req) {
            OgemaLocale locale = req.getLocale();
            this.clear(req);
            NavigableMap messages = PageBuilder.this.mr.getMessages(0L);
            Map rows = PageBuilder.this.getMessagesMap(messages, locale);
            this.addRows(rows, req);
            MessagesDictionary dict = (MessagesDictionary)PageBuilder.this.page.getDictionary(req);
            Map columns = PageBuilder.this.getColumnTitles(dict, locale);
            this.setColumnTitles(columns, req);
        }
    }
}

