/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.driver.zwave.manager;

import java.util.concurrent.atomic.AtomicReference;
import org.ogema.core.channelmanager.measurements.BooleanValue;
import org.ogema.core.channelmanager.measurements.ByteArrayValue;
import org.ogema.core.channelmanager.measurements.FloatValue;
import org.ogema.core.channelmanager.measurements.IntegerValue;
import org.ogema.core.channelmanager.measurements.StringValue;
import org.ogema.core.channelmanager.measurements.Value;
import org.ogema.driver.zwave.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zwave4j.Manager;
import org.zwave4j.ValueId;

public class NodeValue {
    private final String channelAddress;
    private ValueId valueid;
    private final Logger logger = LoggerFactory.getLogger((String)"zwave-driver");
    private Channel channel;
    private boolean hasListener = false;
    private Manager manager;

    public NodeValue(Manager manager, ValueId valueid, String channelAddress) {
        this.manager = manager;
        this.valueid = valueid;
        this.channelAddress = channelAddress;
        this.logger.debug("Channel Address: " + channelAddress);
    }

    public ValueId getValueid() {
        return this.valueid;
    }

    public String getChannelAddress() {
        return this.channelAddress;
    }

    public boolean readOnly() {
        return this.manager.isValueReadOnly(this.valueid);
    }

    public boolean writeOnly() {
        return this.manager.isValueWriteOnly(this.valueid);
    }

    public String getValueName() {
        return this.manager.getValueLabel(this.valueid);
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public void setListener(boolean b) {
        this.hasListener = b;
    }

    public Object getValue() {
        switch (this.valueid.getType()) {
            case BOOL: {
                AtomicReference b = new AtomicReference();
                this.manager.getValueAsBool(this.valueid, b);
                return b.get();
            }
            case BYTE: {
                AtomicReference bb = new AtomicReference();
                this.manager.getValueAsByte(this.valueid, bb);
                return bb.get();
            }
            case DECIMAL: {
                AtomicReference f = new AtomicReference();
                this.manager.getValueAsFloat(this.valueid, f);
                return f.get();
            }
            case INT: {
                AtomicReference i = new AtomicReference();
                this.manager.getValueAsInt(this.valueid, i);
                return i.get();
            }
            case LIST: {
                return null;
            }
            case SCHEDULE: {
                return null;
            }
            case SHORT: {
                AtomicReference s = new AtomicReference();
                this.manager.getValueAsShort(this.valueid, s);
                return s.get();
            }
            case STRING: {
                AtomicReference ss = new AtomicReference();
                this.manager.getValueAsString(this.valueid, ss);
                return ss.get();
            }
            case BUTTON: {
                return null;
            }
            case RAW: {
                AtomicReference sss = new AtomicReference();
                this.manager.getValueAsRaw(this.valueid, sss);
                return sss.get();
            }
        }
        return null;
    }

    public void setValue(Object value) {
        switch (this.valueid.getType()) {
            case BOOL: {
                this.manager.setValueAsBool(this.valueid, ((Boolean)value).booleanValue());
                break;
            }
            case BYTE: {
                this.manager.setValueAsByte(this.valueid, ((Byte)value).byteValue());
                break;
            }
            case DECIMAL: {
                this.manager.setValueAsFloat(this.valueid, ((Float)value).floatValue());
                break;
            }
            case INT: {
                this.manager.setValueAsInt(this.valueid, ((Integer)value).intValue());
                break;
            }
            case LIST: {
                this.manager.setValueListSelection(this.valueid, (String)value);
            }
            case SCHEDULE: {
                throw new UnsupportedOperationException();
            }
            case SHORT: {
                this.manager.setValueAsShort(this.valueid, ((Short)value).shortValue());
                break;
            }
            case STRING: {
                this.manager.setValueAsString(this.valueid, (String)value);
                break;
            }
            case BUTTON: {
                throw new UnsupportedOperationException();
            }
            case RAW: {
                this.manager.setValueAsRaw(this.valueid, (byte[])value);
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public Value getOGEMAValue() {
        switch (this.valueid.getType()) {
            case BOOL: {
                AtomicReference b = new AtomicReference();
                this.manager.getValueAsBool(this.valueid, b);
                return new BooleanValue(((Boolean)b.get()).booleanValue());
            }
            case BYTE: {
                AtomicReference bb = new AtomicReference();
                this.manager.getValueAsByte(this.valueid, bb);
                byte[] ba = new byte[]{0};
                ba[0] = (Byte)bb.get();
                return new ByteArrayValue(ba);
            }
            case DECIMAL: {
                AtomicReference f = new AtomicReference();
                this.manager.getValueAsFloat(this.valueid, f);
                return new FloatValue(((Float)f.get()).floatValue());
            }
            case INT: {
                AtomicReference i = new AtomicReference();
                this.manager.getValueAsInt(this.valueid, i);
                return new IntegerValue(((Integer)i.get()).intValue());
            }
            case LIST: {
                throw new UnsupportedOperationException();
            }
            case SCHEDULE: {
                throw new UnsupportedOperationException();
            }
            case SHORT: {
                AtomicReference s = new AtomicReference();
                this.manager.getValueAsShort(this.valueid, s);
                return new IntegerValue((int)((Short)s.get()).shortValue());
            }
            case STRING: {
                AtomicReference ss = new AtomicReference();
                this.manager.getValueAsString(this.valueid, ss);
                return new StringValue((String)ss.get());
            }
            case BUTTON: {
                throw new UnsupportedOperationException();
            }
            case RAW: {
                AtomicReference sss = new AtomicReference();
                this.manager.getValueAsRaw(this.valueid, sss);
                return new ByteArrayValue((byte[])sss.get());
            }
        }
        throw new UnsupportedOperationException();
    }

    public void setOGEMAValue(Value value) {
        switch (this.valueid.getType()) {
            case BOOL: {
                this.manager.setValueAsBool(this.valueid, value.getBooleanValue());
                break;
            }
            case BYTE: {
                this.manager.setValueAsByte(this.valueid, value.getByteArrayValue()[0]);
                break;
            }
            case DECIMAL: {
                this.manager.setValueAsFloat(this.valueid, value.getFloatValue());
                break;
            }
            case INT: {
                this.manager.setValueAsInt(this.valueid, value.getIntegerValue());
                break;
            }
            case LIST: {
                throw new UnsupportedOperationException();
            }
            case SCHEDULE: {
                throw new UnsupportedOperationException();
            }
            case SHORT: {
                this.manager.setValueAsShort(this.valueid, (short)(value.getIntegerValue() & 0xFFFF));
                break;
            }
            case STRING: {
                this.manager.setValueAsString(this.valueid, value.getStringValue());
                break;
            }
            case BUTTON: {
                throw new UnsupportedOperationException();
            }
            case RAW: {
                this.manager.setValueAsRaw(this.valueid, value.getByteArrayValue());
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public void valueChanged() {
        if (this.hasListener) {
            this.channel.updateListener();
        }
    }
}

