/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.driver.zwave.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ogema.core.channelmanager.driverspi.ChannelLocator;
import org.ogema.core.channelmanager.driverspi.ChannelScanListener;
import org.ogema.core.channelmanager.driverspi.DeviceLocator;
import org.ogema.core.channelmanager.measurements.Value;
import org.ogema.driver.zwave.manager.LocalDevice;
import org.ogema.driver.zwave.manager.NodeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zwave4j.Manager;
import org.zwave4j.ValueId;

public class Node {
    private final Logger logger = LoggerFactory.getLogger((String)"zwave-driver");
    private Map<String, NodeValue> values;
    private final short nodeId;
    private final String name;
    private final LocalDevice localDevice;
    private boolean ready = false;
    ArrayList<ChannelScanListener> chListeners;
    public DeviceLocator devLocator;

    public Node(LocalDevice localDevice, short nodeId, String nodeName) {
        this.nodeId = nodeId;
        this.localDevice = localDevice;
        this.name = nodeName;
        localDevice.getManager().setNodeName(localDevice.getHomeId(), nodeId, nodeName);
        this.values = new HashMap<String, NodeValue>();
        this.chListeners = new ArrayList();
    }

    public Map<String, NodeValue> getValues() {
        return this.values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValue(NodeValue nv) {
        this.logger.debug(String.format("NodeValue added to %s", this.name));
        this.logger.debug(String.format("%d ChannelScanListener registered", this.chListeners.size()));
        Node node = this;
        synchronized (node) {
            this.values.put(nv.getChannelAddress(), nv);
        }
        for (ChannelScanListener listener : this.chListeners) {
            try {
                ChannelLocator channel = new ChannelLocator(nv.getChannelAddress(), this.devLocator);
                if (channel == null) continue;
                listener.channelFound(channel);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public short getNodeId() {
        return this.nodeId;
    }

    public String getNodeName() {
        return this.name;
    }

    public String getProductString() {
        Manager manager = this.localDevice.getManager();
        long homeId = this.localDevice.getHomeId();
        return manager.getNodeManufacturerId(homeId, this.nodeId) + "." + manager.getNodeProductType(homeId, this.nodeId) + "." + manager.getNodeProductId(homeId, this.nodeId);
    }

    public String getProductName() {
        return this.localDevice.getManager().getNodeProductName(this.localDevice.getHomeId(), this.nodeId);
    }

    public String readNodeName() {
        return this.localDevice.getManager().getNodeName(this.localDevice.getHomeId(), this.nodeId);
    }

    public Manager getManager() {
        return this.localDevice.getManager();
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setReady(boolean ready) {
        this.ready = ready;
    }

    public void channelChanged(byte identifier, Value value) {
    }

    public String generateChannelAddress(ValueId valueid) {
        return (this.fillZero(valueid.getCommandClassId()) + ":" + this.fillZero(valueid.getInstance()) + ":" + this.fillZero(valueid.getIndex())).toUpperCase();
    }

    private String fillZero(short s) {
        StringBuilder tempString = new StringBuilder();
        tempString.append(Integer.toHexString(s & 0xFFFF));
        switch (tempString.length()) {
            case 0: {
                tempString.append("0000");
                break;
            }
            case 1: {
                tempString.insert(tempString.length() - 1, "000");
                break;
            }
            case 2: {
                tempString.insert(tempString.length() - 2, "00");
                break;
            }
            case 3: {
                tempString.insert(tempString.length() - 3, "0");
            }
        }
        return tempString.toString();
    }

    public synchronized void addChannelListener(ChannelScanListener listener) {
        this.logger.debug(String.format("ChannelListener added to Node %s", listener.toString()));
        this.chListeners.add(listener);
        Set<Map.Entry<String, NodeValue>> set = this.values.entrySet();
        for (Map.Entry<String, NodeValue> e : set) {
            NodeValue val = e.getValue();
            try {
                ChannelLocator channel = new ChannelLocator(val.getChannelAddress(), this.devLocator);
                if (channel == null) continue;
                listener.channelFound(channel);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

