/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.driver.zwave.manager;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.ogema.core.channelmanager.driverspi.DeviceListener;
import org.ogema.core.channelmanager.driverspi.DeviceLocator;
import org.ogema.driver.zwave.Activator;
import org.ogema.driver.zwave.ZWaveDriver;
import org.ogema.driver.zwave.manager.InputHandler;
import org.ogema.driver.zwave.manager.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zwave4j.Manager;
import org.zwave4j.NativeLibraryLoader;
import org.zwave4j.NotificationWatcher;
import org.zwave4j.Options;
import org.zwave4j.ZWave4j;

public class LocalDevice {
    public final Map<Short, Node> nodes;
    private final Options options;
    private final Manager manager;
    private final InputHandler inputHandler;
    private final Logger logger = LoggerFactory.getLogger((String)"zwave-driver");
    private long homeId;
    private boolean ready;
    private String waitingNodeName = null;
    private boolean isWaitingNodeName = false;
    ArrayList<DeviceListener> devListeners;
    ArrayList<Node> devices2Dispatch;
    private String ifaceName;
    ZWaveDriver driver;
    public Thread deviceEventDispatcher;
    private String driverPath;
    private static String OS = System.getProperty("os.name").toLowerCase();

    public LocalDevice(String port, ZWaveDriver drv) {
        this.driver = drv;
        this.nodes = new ConcurrentHashMap<Short, Node>();
        this.devListeners = new ArrayList();
        this.devices2Dispatch = new ArrayList();
        this.deviceEventDispatcher = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (Activator.bundleIsRunning) {
                    ZWaveDriver zWaveDriver = LocalDevice.this.driver;
                    synchronized (zWaveDriver) {
                        try {
                            DeviceLocator device;
                            LocalDevice.this.driver.wait();
                            int index = 0;
                            int size = LocalDevice.this.devices2Dispatch.size();
                            Node tempNode = null;
                            if (size > 0) {
                                tempNode = LocalDevice.this.devices2Dispatch.remove(index);
                            }
                            if ((device = tempNode.devLocator) == null) {
                                tempNode.devLocator = device = LocalDevice.this.driver.createDeviceLocator(LocalDevice.this.ifaceName, tempNode);
                            }
                            while (Activator.bundleIsRunning) {
                                ++index;
                                for (DeviceListener listener : LocalDevice.this.devListeners) {
                                    try {
                                        if (device == null) continue;
                                        LocalDevice.this.logger.debug(String.format("Device %s delivered via callback", device.toString()));
                                        listener.deviceAdded(device);
                                    }
                                    catch (Throwable t) {
                                        t.printStackTrace();
                                    }
                                }
                                if (index < size) {
                                    tempNode = LocalDevice.this.devices2Dispatch.remove(index);
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            }
        });
        this.deviceEventDispatcher.setName("zwave-eventdispatcher");
        this.deviceEventDispatcher.start();
        NativeLibraryLoader.loadLibrary((String)"zwave4j", ZWave4j.class);
        this.options = Options.create((String)"./config/zwave", (String)"./config/zwave_cache", (String)"");
        this.options.addOptionBool("ConsoleOutput", false);
        this.options.lock();
        this.manager = Manager.create();
        this.inputHandler = new InputHandler(this);
        this.manager.addWatcher((NotificationWatcher)this.inputHandler, null);
        this.ifaceName = port;
        if (OS.indexOf("win") >= 0) {
            port = "//./" + port;
        }
        this.manager.addDriver(port);
        this.driverPath = port;
    }

    public void restart() {
        this.manager.addDriver(this.driverPath);
    }

    public void printNodes() {
        Set<Map.Entry<Short, Node>> set = this.nodes.entrySet();
        for (Map.Entry<Short, Node> e : set) {
            System.out.print(e.getKey());
            System.out.print(":");
            System.out.print(e.getValue().readNodeName());
            System.out.print(", ");
            System.out.print(e.getValue().getProductName());
            System.out.print(", ");
            System.out.println(e.getValue().getProductString());
        }
    }

    public boolean isConnected() {
        return true;
    }

    public Manager getManager() {
        return this.manager;
    }

    public long getHomeId() {
        return this.homeId;
    }

    public void setHomeId(long homeId) {
        this.homeId = homeId;
    }

    public short getNodeId() {
        return this.manager.getControllerNodeId(this.homeId);
    }

    public void setReadyId() {
        this.ready = true;
    }

    public Map<Short, Node> getNodes() {
        return this.nodes;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setReady(boolean ready) {
        if (this.manager != null) {
            this.ready = ready;
            this.manager.writeConfig(this.homeId);
            boolean failed = false;
            for (Map.Entry<Short, Node> entry : this.nodes.entrySet()) {
                failed = this.manager.isNodeFailed(this.homeId, entry.getValue().getNodeId());
                if (failed) {
                    this.logger.error("Node " + entry.getKey() + " failed");
                    this.nodes.remove(entry.getKey());
                    continue;
                }
                this.logger.info("Node " + entry.getKey() + " ok");
            }
        }
    }

    public void enableInclusion(String nodeName) {
        this.waitingNodeName = nodeName;
        this.isWaitingNodeName = true;
        this.manager.addNode(this.homeId, false);
    }

    public String getWaitingNodeName() {
        this.isWaitingNodeName = false;
        return this.waitingNodeName;
    }

    public boolean isWaitingNodeName() {
        return this.isWaitingNodeName;
    }

    public void enableExclusion() {
        this.manager.removeNode(this.homeId);
    }

    public void close() {
        this.manager.removeDriver(this.driverPath);
    }

    public void resetController() {
        this.manager.resetController(this.homeId);
    }

    public void addDeviceListener(DeviceListener listener) {
        this.logger.debug("DeviceListener added to LocalDevice");
        this.devListeners.add(listener);
        Set<Map.Entry<Short, Node>> set = this.nodes.entrySet();
        for (Map.Entry<Short, Node> e : set) {
            Node tempNode = e.getValue();
            DeviceLocator device = this.driver.createDeviceLocator(this.ifaceName, tempNode);
            if (device == null) continue;
            listener.deviceAdded(device);
        }
    }

    public void removeDeviceListener(DeviceListener listener) {
        this.devListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(Node tempNode) {
        this.logger.debug(String.format("Node added to LocalDevice, %d Devicelistenrs registered.", this.devListeners.size()));
        this.nodes.put(tempNode.getNodeId(), tempNode);
        ZWaveDriver zWaveDriver = this.driver;
        synchronized (zWaveDriver) {
            this.devices2Dispatch.add(tempNode);
            this.driver.notify();
        }
    }

    public void removeNode(short nodeID) {
        this.logger.debug("Node removed from LocalDevice");
        Node node = this.nodes.remove(nodeID);
        if (node != null) {
            for (DeviceListener listener : this.devListeners) {
                DeviceLocator device = node.devLocator;
                if (device == null) continue;
                listener.deviceRemoved(device);
            }
        }
    }

    public void addDeviceListeners(ArrayList<DeviceListener> listeners) {
        this.logger.debug(String.format("%d DeviceListeners added to LocalDevice", listeners.size()));
        this.devListeners.addAll(listeners);
        for (DeviceListener l : this.devListeners) {
            Set<Map.Entry<Short, Node>> set = this.nodes.entrySet();
            for (Map.Entry<Short, Node> e : set) {
                Node tempNode = e.getValue();
                DeviceLocator device = this.driver.createDeviceLocator(this.ifaceName, tempNode);
                if (device == null) continue;
                this.logger.debug("\tDevice reported to DeviceListener");
                l.deviceAdded(device);
            }
        }
    }

    public void removeDeviceListeners(ArrayList<DeviceListener> devListeners) {
        devListeners = null;
    }
}

