/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.driver.zwave.manager;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.ogema.driver.zwave.manager.LocalDevice;
import org.ogema.driver.zwave.manager.Node;
import org.ogema.driver.zwave.manager.NodeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zwave4j.Manager;
import org.zwave4j.Notification;
import org.zwave4j.NotificationWatcher;
import org.zwave4j.ValueId;

public class InputHandler
implements NotificationWatcher {
    LocalDevice localDevice;
    private final Logger logger = LoggerFactory.getLogger((String)"zwave-driver");

    public InputHandler(LocalDevice localDevice) {
        this.localDevice = localDevice;
    }

    public void onNotification(Notification notification, Object context) {
        try {
            switch (notification.getType()) {
                case DRIVER_READY: {
                    this.logger.info(String.format("Driver ready\n\thome id: %d", notification.getHomeId()));
                    this.localDevice.setHomeId(notification.getHomeId());
                    break;
                }
                case DRIVER_FAILED: {
                    this.logger.info("Driver failed");
                    break;
                }
                case DRIVER_RESET: {
                    this.logger.info("Driver reset");
                    break;
                }
                case AWAKE_NODES_QUERIED: {
                    this.logger.info("Awake nodes queried");
                    break;
                }
                case ALL_NODES_QUERIED: {
                    this.logger.info("All nodes queried");
                    this.localDevice.setReady(true);
                    break;
                }
                case ALL_NODES_QUERIED_SOME_DEAD: {
                    this.logger.info("All nodes queried some dead");
                    break;
                }
                case POLLING_ENABLED: {
                    this.logger.info("Polling enabled");
                    break;
                }
                case POLLING_DISABLED: {
                    this.logger.info("Polling disabled");
                    break;
                }
                case NODE_NEW: {
                    this.logger.info(String.format("Node new\n\tnode id: %d", notification.getNodeId()));
                    break;
                }
                case NODE_ADDED: {
                    this.logger.info(String.format("Node added\n\tnode id: %d", notification.getNodeId()));
                    long home = notification.getHomeId();
                    short nodeId = notification.getNodeId();
                    if (nodeId == 0) break;
                    String name = "unknown";
                    name = nodeId == 1 ? "Network-Coordinator" : (this.localDevice.isWaitingNodeName() ? this.localDevice.getWaitingNodeName() : Manager.get().getNodeName(home, nodeId));
                    if (name == null || name.equals("")) {
                        Manager.get().removeNode(home);
                        break;
                    }
                    Node tempNode = new Node(this.localDevice, nodeId, name);
                    this.localDevice.addNode(tempNode);
                    break;
                }
                case NODE_REMOVED: {
                    short nodeId = notification.getNodeId();
                    this.logger.info(String.format("Node removed\n\tnode id: %d", nodeId));
                    this.localDevice.removeNode(nodeId);
                    break;
                }
                case ESSENTIAL_NODE_QUERIES_COMPLETE: {
                    System.out.println(String.format("Node essential queries complete\n\tnode id: %d", notification.getNodeId()));
                    this.localDevice.setReadyId();
                    break;
                }
                case NODE_QUERIES_COMPLETE: {
                    System.out.println(String.format("Node queries complete\n\tnode id: %d", notification.getNodeId()));
                    for (Map.Entry<Short, Node> pair : this.localDevice.getNodes().entrySet()) {
                        pair.getValue().setReady(true);
                    }
                    break;
                }
                case NODE_EVENT: {
                    System.out.println(String.format("Node event\n\tnode id: %d\n\tevent id: %d", notification.getNodeId(), notification.getEvent()));
                    break;
                }
                case NODE_NAMING: {
                    System.out.println(String.format("Node naming\n\tnode id: %d", notification.getNodeId()));
                    break;
                }
                case NODE_PROTOCOL_INFO: {
                    System.out.println(String.format("Node protocol info\n\tnode id: %d\n\ttype: %s", notification.getNodeId(), this.localDevice.getManager().getNodeType(notification.getHomeId(), notification.getNodeId())));
                    break;
                }
                case VALUE_ADDED: {
                    short nodeId = notification.getNodeId();
                    ValueId valueId = notification.getValueId();
                    this.logger.debug(String.format("Value added\n\tnode id: %d\n\tcommand class: %d\n\tinstance: %d\n\tindex: %d\n\tgenre: %s\n\ttype: %s\n\tlabel: %s\n\tvalue: %s", nodeId, notification.getValueId().getCommandClassId(), valueId.getInstance(), valueId.getIndex(), valueId.getGenre().name(), valueId.getType().name(), this.localDevice.getManager().getValueLabel(valueId), this.getValue(valueId)));
                    Node n = this.localDevice.getNodes().get(nodeId);
                    if (n == null) break;
                    NodeValue nv = new NodeValue(this.localDevice.getManager(), notification.getValueId(), n.generateChannelAddress(notification.getValueId()));
                    n.addValue(nv);
                    nv.valueChanged();
                    this.localDevice.getManager().refreshValue(valueId);
                    break;
                }
                case VALUE_REMOVED: {
                    System.out.println(String.format("Value removed\n\tnode id: %d\n\tcommand class: %d\n\tinstance: %d\n\tindex: %d", notification.getNodeId(), notification.getValueId().getCommandClassId(), notification.getValueId().getInstance(), notification.getValueId().getIndex()));
                    break;
                }
                case VALUE_CHANGED: {
                    short nodeId = notification.getNodeId();
                    ValueId valueId = notification.getValueId();
                    System.out.println(String.format("Value changed\n\tnode id: %d\n\tcommand class: %d\n\tinstance: %d\n\tindex: %d\n\tvalue: %s", nodeId, valueId.getCommandClassId(), valueId.getInstance(), valueId.getIndex(), this.getValue(valueId)));
                    Node nnn = this.localDevice.getNodes().get(nodeId);
                    nnn.getValues().get(nnn.generateChannelAddress(notification.getValueId())).valueChanged();
                    break;
                }
                case VALUE_REFRESHED: {
                    short nodeId = notification.getNodeId();
                    ValueId valueId = notification.getValueId();
                    System.out.println(String.format("Value refreshed\n\tnode id: %d\n\tcommand class: %d\n\tinstance: %d\n\tindex: %d\tvalue: %s", nodeId, valueId.getCommandClassId(), valueId.getInstance(), valueId.getIndex(), this.getValue(valueId)));
                    Node nnnn = this.localDevice.getNodes().get(nodeId);
                    nnnn.getValues().get(nnnn.generateChannelAddress(notification.getValueId())).valueChanged();
                    break;
                }
                case GROUP: {
                    System.out.println(String.format("Group\n\tnode id: %d\n\tgroup id: %d", notification.getNodeId(), notification.getGroupIdx()));
                    break;
                }
                case SCENE_EVENT: {
                    System.out.println(String.format("Scene event\n\tscene id: %d", notification.getSceneId()));
                    break;
                }
                case CREATE_BUTTON: {
                    System.out.println(String.format("Button create\n\tbutton id: %d", notification.getButtonId()));
                    break;
                }
                case DELETE_BUTTON: {
                    System.out.println(String.format("Button delete\n\tbutton id: %d", notification.getButtonId()));
                    break;
                }
                case BUTTON_ON: {
                    System.out.println(String.format("Button on\n\tbutton id: %d", notification.getButtonId()));
                    break;
                }
                case BUTTON_OFF: {
                    System.out.println(String.format("Button off\n\tbutton id: %d", notification.getButtonId()));
                    break;
                }
                case NOTIFICATION: {
                    this.logger.info(notification.getNotification().toString());
                    break;
                }
                case CONTROLLER_COMMAND: {
                    this.logger.info("Controller_Command");
                    break;
                }
                case DRIVER_REMOVED: {
                    this.logger.info("DRIVER_REMOVED");
                    break;
                }
                default: {
                    System.out.println(notification.getType().name());
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private Object getValue(ValueId valueId) {
        switch (valueId.getType()) {
            case BOOL: {
                AtomicReference b = new AtomicReference();
                Manager.get().getValueAsBool(valueId, b);
                return b.get();
            }
            case BYTE: {
                AtomicReference bb = new AtomicReference();
                Manager.get().getValueAsByte(valueId, bb);
                return bb.get();
            }
            case DECIMAL: {
                AtomicReference f = new AtomicReference();
                Manager.get().getValueAsFloat(valueId, f);
                return f.get();
            }
            case INT: {
                AtomicReference i = new AtomicReference();
                Manager.get().getValueAsInt(valueId, i);
                return i.get();
            }
            case LIST: {
                return null;
            }
            case SCHEDULE: {
                return null;
            }
            case SHORT: {
                AtomicReference s = new AtomicReference();
                Manager.get().getValueAsShort(valueId, s);
                return s.get();
            }
            case STRING: {
                AtomicReference ss = new AtomicReference();
                Manager.get().getValueAsString(valueId, ss);
                return ss.get();
            }
            case BUTTON: {
                return null;
            }
            case RAW: {
                AtomicReference sss = new AtomicReference();
                Manager.get().getValueAsRaw(valueId, sss);
                return sss.get();
            }
        }
        return null;
    }
}

