/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.driver.zwave;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ogema.core.channelmanager.driverspi.ChannelDriver;
import org.ogema.core.channelmanager.driverspi.ChannelLocator;
import org.ogema.core.channelmanager.driverspi.ChannelScanListener;
import org.ogema.core.channelmanager.driverspi.ChannelUpdateListener;
import org.ogema.core.channelmanager.driverspi.DeviceListener;
import org.ogema.core.channelmanager.driverspi.DeviceLocator;
import org.ogema.core.channelmanager.driverspi.DeviceScanListener;
import org.ogema.core.channelmanager.driverspi.NoSuchChannelException;
import org.ogema.core.channelmanager.driverspi.NoSuchDeviceException;
import org.ogema.core.channelmanager.driverspi.NoSuchInterfaceException;
import org.ogema.core.channelmanager.driverspi.SampledValueContainer;
import org.ogema.core.channelmanager.driverspi.ValueContainer;
import org.ogema.core.channelmanager.measurements.Value;
import org.ogema.core.hardwaremanager.HardwareDescriptor;
import org.ogema.core.hardwaremanager.HardwareListener;
import org.ogema.core.hardwaremanager.HardwareManager;
import org.ogema.core.hardwaremanager.UsbHardwareDescriptor;
import org.ogema.driver.zwave.Activator;
import org.ogema.driver.zwave.Channel;
import org.ogema.driver.zwave.Connection;
import org.ogema.driver.zwave.Device;
import org.ogema.driver.zwave.manager.LocalDevice;
import org.ogema.driver.zwave.manager.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZWaveDriver
implements ChannelDriver,
HardwareListener {
    private final Logger logger = LoggerFactory.getLogger((String)"zwave-driver");
    private final Map<String, Connection> connectionsMap;
    private final Map<ChannelUpdateListener, List<Channel>> listenerMap;
    private final String driverId = "zwave-driver";
    private final String description = "OGEMA ZWave Driver";
    ArrayList<DeviceListener> devListeners;
    private LocalDevice mainLocal;
    private final Object connectionLock = new Object();
    private HardwareManager hwMngr;

    public ZWaveDriver(HardwareManager hwMngr) {
        this.connectionsMap = new HashMap<String, Connection>();
        this.listenerMap = new HashMap<ChannelUpdateListener, List<Channel>>();
        this.devListeners = new ArrayList();
        this.hwMngr = hwMngr;
        hwMngr.addListener((HardwareListener)this);
    }

    protected void addConnection(Connection con) {
        this.mainLocal = con.getLocalDevice();
        this.connectionsMap.put(con.getInterfaceId(), con);
        con.getLocalDevice().addDeviceListeners(this.devListeners);
    }

    protected void removeConnection(String interfaceId) {
        Connection con = this.connectionsMap.remove(interfaceId);
        con.getLocalDevice().removeDeviceListeners(this.devListeners);
    }

    protected Map<String, Connection> getConnections() {
        return this.connectionsMap;
    }

    protected Connection findConnection(String interfaceId) {
        return this.connectionsMap.get(interfaceId);
    }

    public String getDriverId() {
        return "zwave-driver";
    }

    public String getDescription() {
        return "OGEMA ZWave Driver";
    }

    public void startDeviceScan(String interfaceId, String filter, DeviceScanListener listener) throws UnsupportedOperationException, NoSuchInterfaceException, IOException {
        boolean success = false;
        if (interfaceId != null) {
            Connection connection = this.connectionsMap.get(interfaceId);
            if (connection.getLocalDevice().isReady()) {
                for (Map.Entry<Short, Node> deviceEntry : connection.getLocalDevice().getNodes().entrySet()) {
                    Node node = deviceEntry.getValue();
                    if (!node.isReady() || node.getNodeId() == connection.getLocalDevice().getNodeId()) continue;
                    String parameters = node.getProductString() + ":" + node.getProductName();
                    DeviceLocator deviceLocator = new DeviceLocator("zwave-driver", interfaceId, node.getNodeName(), parameters);
                    this.logger.debug("\nDevice found:\nAddress = " + deviceLocator.getDeviceAddress() + "\nDeviceParameters = " + deviceLocator.getParameters());
                    listener.deviceFound(deviceLocator);
                    success = true;
                }
            }
        } else {
            Set<Map.Entry<String, Connection>> connections = this.connectionsMap.entrySet();
            if (connections.size() <= 0) {
                this.logger.debug("Currently there are no connections alive to ZWave coordinator hardware.");
            } else {
                for (Map.Entry<String, Connection> con : connections) {
                    if (!con.getValue().getLocalDevice().isReady()) continue;
                    for (Map.Entry<Short, Node> deviceEntry : con.getValue().getLocalDevice().getNodes().entrySet()) {
                        Node node = deviceEntry.getValue();
                        if (!node.isReady() || node.getNodeId() == con.getValue().getLocalDevice().getNodeId()) continue;
                        String parameters = node.getProductString() + ":" + node.getProductName();
                        DeviceLocator deviceLocator = new DeviceLocator("zwave-driver", con.getValue().getInterfaceId(), node.getNodeName(), parameters);
                        this.logger.debug("\nDevice found:\nAddress = " + deviceLocator.getDeviceAddress() + "\nDeviceParameters = " + deviceLocator.getParameters());
                        listener.deviceFound(deviceLocator);
                        success = true;
                    }
                }
            }
        }
        listener.finished(success, null);
    }

    public void abortDeviceScan(String interfaceId, String filter) {
        throw new UnsupportedOperationException();
    }

    public void startChannelScan(DeviceLocator device, ChannelScanListener listener) {
        String params = device.getParameters();
        String id = params.substring(params.lastIndexOf(58) + 1, params.length());
        this.mainLocal.printNodes();
        Node node = this.mainLocal.nodes.get(Short.valueOf(id));
        this.logger.debug(String.format("ChannelScanListener registered for node %d", Short.valueOf(id)));
        node.addChannelListener(listener);
    }

    public List<ChannelLocator> getChannelList(DeviceLocator device) throws UnsupportedOperationException {
        return this.connectionsMap.get(device.getInterfaceName()).findDevice(device).getChannelLocators();
    }

    public void readChannels(List<SampledValueContainer> channels) throws UnsupportedOperationException, IOException {
        for (SampledValueContainer container : channels) {
            ChannelLocator channelLocator = container.getChannelLocator();
            try {
                Connection con = this.findConnection(channelLocator.getDeviceLocator().getInterfaceName());
                Device dev = con.findDevice(channelLocator.getDeviceLocator());
                Channel channel = dev.findChannel(channelLocator);
                container.setSampledValue(channel.readValue(con));
            }
            catch (NullPointerException e) {
                throw new IOException("Unknown channel: " + channelLocator, e);
            }
        }
    }

    public void listenChannels(List<SampledValueContainer> channels, ChannelUpdateListener listener) throws UnsupportedOperationException, NoSuchDeviceException, NoSuchChannelException, IOException {
        this.logger.debug("listenChannels");
        List<Channel> channelList = this.listenerMap.get(listener);
        if (channelList == null) {
            channelList = new ArrayList<Channel>();
        }
        for (SampledValueContainer container : channels) {
            ChannelLocator channelLocator = container.getChannelLocator();
            try {
                DeviceLocator dev = channelLocator.getDeviceLocator();
                Channel channel = this.findConnection(dev.getInterfaceName()).findDevice(dev).findChannel(channelLocator);
                channel.setEventListener(container, listener);
                channelList.add(channel);
            }
            catch (NullPointerException e) {
                throw new IOException("Unknown channel: " + channelLocator, e);
            }
        }
        this.listenerMap.put(listener, channelList);
    }

    public void writeChannels(List<ValueContainer> channels) throws UnsupportedOperationException, IOException, NoSuchDeviceException, NoSuchChannelException {
        for (ValueContainer container : channels) {
            ChannelLocator channelLocator = container.getChannelLocator();
            try {
                Connection con = this.findConnection(channelLocator.getDeviceLocator().getInterfaceName());
                Device dev = con.findDevice(channelLocator.getDeviceLocator());
                Channel channel = dev.findChannel(channelLocator);
                channel.writeValue(con, container.getValue());
            }
            catch (NullPointerException e) {
                throw new IOException("Unknown channel: " + channelLocator, e);
            }
        }
    }

    public void channelAdded(ChannelLocator channel) {
        Channel chan;
        DeviceLocator device = channel.getDeviceLocator();
        String iface = device.getInterfaceName();
        Connection con = this.findConnection(iface);
        if (con == null) {
            return;
        }
        Device dev = con.findDevice(device);
        if (dev == null) {
            dev = new Device(device, con);
            con.addDevice(dev);
        }
        if ((chan = dev.findChannel(channel)) == null) {
            chan = new Channel(channel, dev);
            dev.addChannel(chan);
        }
    }

    public void channelRemoved(ChannelLocator channel) {
        DeviceLocator device = channel.getDeviceLocator();
        Connection con = this.findConnection(device.getInterfaceName());
        Device dev = con.findDevice(device);
        Channel chan = null;
        chan = dev.findChannel(channel);
        if (chan != null) {
            dev.removeChannel(chan);
        }
    }

    public void hardwareAdded(HardwareDescriptor descriptor) {
        this.logger.debug("hardware added: " + descriptor.getIdentifier().toString());
        this.establishConnection();
    }

    public void hardwareRemoved(HardwareDescriptor descriptor) {
        Connection con;
        this.logger.debug("hardware removed: " + descriptor.getIdentifier().toString());
        String portName = ((UsbHardwareDescriptor)descriptor).getPortName();
        if (portName != null && (con = this.connectionsMap.get(portName)) != null) {
            con.close();
        }
    }

    public void shutdown() {
    }

    public void addDeviceListener(DeviceListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener object mustn't be null!");
        }
        this.devListeners.add(listener);
        Set<Map.Entry<String, Connection>> connections = this.connectionsMap.entrySet();
        for (Map.Entry<String, Connection> con : connections) {
            LocalDevice dev = con.getValue().getLocalDevice();
            dev.addDeviceListener(listener);
        }
    }

    public void removeDeviceListener(DeviceListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener object mustn't be null!");
        }
        this.devListeners.remove(listener);
        Set<Map.Entry<String, Connection>> connections = this.connectionsMap.entrySet();
        for (Map.Entry<String, Connection> con : connections) {
            LocalDevice dev = con.getValue().getLocalDevice();
            dev.removeDeviceListener(listener);
        }
    }

    public DeviceLocator createDeviceLocator(String ifaceName, Node node) {
        String prodString = node.getProductString();
        String prodName = node.getProductName();
        String nodeName = node.readNodeName();
        int tries = 5;
        while (tries-- > 0) {
            prodName = node.getProductName();
            prodString = node.getProductString();
            if (!prodName.equals("") && !prodString.equals("..")) break;
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.logger.debug(String.format("CreateDeviceLocator: ProductString = %s, ProductName = %s, NodeName = %s", prodString, prodName, nodeName));
        if (prodName.equals("") || prodName == null) {
            return null;
        }
        String parameters = prodString + ":" + prodName + ":" + node.getNodeId();
        DeviceLocator deviceLocator = new DeviceLocator("zwave-driver", ifaceName, nodeName, parameters);
        return deviceLocator;
    }

    public void establishConnection() {
        final String portName = this.getPortName(this.hwMngr);
        Connection con = this.connectionsMap.get(portName);
        if (con == null && portName != null) {
            final ZWaveDriver driver = this;
            Thread connectThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Connection con = new Connection(portName, ZWaveDriver.this.connectionLock, ZWaveDriver.this.hwMngr, driver);
                    Object object = ZWaveDriver.this.connectionLock;
                    synchronized (object) {
                        while (!con.hasConnection() && Activator.bundleIsRunning) {
                            try {
                                ZWaveDriver.this.connectionLock.wait();
                            }
                            catch (InterruptedException ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                    ZWaveDriver.this.addConnection(con);
                }
            };
            connectThread.setName("zwave-connect");
            connectThread.start();
        } else if (con != null) {
            con.getLocalDevice().restart();
        } else {
            this.logger.info("No portname could be determined!");
        }
    }

    String getPortName(HardwareManager hwMngr) {
        String portName = System.getProperty("org.ogema.driver.zwave.portname");
        if (portName == null) {
            HardwareDescriptor descr;
            String hardwareDesriptors = System.getProperty("org.ogema.driver.zwave.hardware-descriptor", ".+:0658:0200:");
            this.logger.info(String.format("No device file specified on the command line. The Hardware descriptor %s is used instead.", hardwareDesriptors));
            Collection descriptors = hwMngr.getHardwareDescriptors(hardwareDesriptors);
            Iterator iterator = descriptors.iterator();
            while (iterator.hasNext() && (portName = ((UsbHardwareDescriptor)(descr = (HardwareDescriptor)iterator.next())).getPortName()) == null) {
            }
        }
        this.logger.info(String.format("Port name detected %s", portName));
        return portName;
    }

    public void writeChannel(ChannelLocator channelLocator, Value value) throws UnsupportedOperationException, IOException, NoSuchDeviceException, NoSuchChannelException {
        try {
            Connection con = this.findConnection(channelLocator.getDeviceLocator().getInterfaceName());
            Device dev = con.findDevice(channelLocator.getDeviceLocator());
            Channel channel = dev.findChannel(channelLocator);
            channel.writeValue(con, value);
        }
        catch (NullPointerException e) {
            throw new IOException("Unknown channel: " + channelLocator, e);
        }
    }
}

