/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.driver.zwave;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.felix.service.command.Descriptor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.ogema.driver.zwave.Channel;
import org.ogema.driver.zwave.Connection;
import org.ogema.driver.zwave.Device;
import org.ogema.driver.zwave.ZWaveDriver;
import org.ogema.driver.zwave.manager.Node;
import org.ogema.driver.zwave.manager.NodeValue;
import org.ogema.driverconfig.LLDriverInterface;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zwave4j.Manager;
import org.zwave4j.ValueGenre;
import org.zwave4j.ValueType;

public class ShellCommands
implements LLDriverInterface {
    private ZWaveDriver driver;
    private final Logger logger = LoggerFactory.getLogger((String)"zwave-driver");
    private final ServiceRegistration<LLDriverInterface> srLLDriver;
    private final ServiceRegistration<ShellCommands> srCommands;

    public ShellCommands(ZWaveDriver driver, BundleContext context) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put("osgi.command.scope", "zwave");
        props.put("osgi.command.function", new String[]{"showNetwork", "showAllCreatedChannels", "showClusterDetails", "showDeviceDetails", "addConnection", "showHardware", "addConnectionViaPort", "enableInclusion", "enableExclusion", "resetController", "sendFrame", "cacheDevices", "readDevConfig", "setDevConfig", "listSupportedConfigs", "showConfigs", "writeConfig"});
        this.driver = driver;
        this.srCommands = context.registerService(ShellCommands.class, (Object)this, props);
        this.srLLDriver = context.registerService(LLDriverInterface.class, (Object)this, null);
    }

    void close() {
        try {
            this.srCommands.unregister();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.srLLDriver.unregister();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Descriptor(value="Enables Inclusion.")
    public void enableInclusion(String interfaceId, String nodeName) {
        Connection connection = this.driver.findConnection(interfaceId);
        if (connection != null) {
            if (nodeName.length() <= 16) {
                connection.getLocalDevice().enableInclusion(nodeName);
            } else {
                this.logger.error("Node name must have 16 characters or less!");
            }
        } else {
            this.logger.error("InterfaceId seems not to be valid!");
        }
    }

    @Descriptor(value="Enables Exclusion.")
    public void enableExclusion(String interfaceId) {
        Connection connection = this.driver.findConnection(interfaceId);
        if (connection != null) {
            connection.getLocalDevice().enableExclusion();
        } else {
            this.logger.error("InterfaceId seems not to be valid!");
        }
    }

    @Descriptor(value="Reset the USB-Configurator.")
    public void resetController(String interfaceId) {
        Connection connection = this.driver.findConnection(interfaceId);
        if (connection != null) {
            connection.getLocalDevice().resetController();
        } else {
            this.logger.error("InterfaceId seems not to be valid!");
        }
    }

    @Descriptor(value="Show details related to the coordinator hardware.")
    public JSONObject showHardware() {
        JSONObject subobj = new JSONObject();
        JSONArray arr = new JSONArray();
        JSONObject obj = new JSONObject();
        Set<Map.Entry<String, Connection>> connections = this.driver.getConnections().entrySet();
        if (connections.size() <= 0) {
            this.logger.debug("Currently there are no connections alive to ZWave coordinator hardware.");
        }
        for (Map.Entry<String, Connection> connection : connections) {
            long homeId = connection.getValue().getLocalDevice().getHomeId();
            short nodeId = connection.getValue().getLocalDevice().getManager().getControllerNodeId(connection.getValue().getLocalDevice().getHomeId());
            try {
                obj.put("Interface", (Object)connection.getValue().getInterfaceId());
                obj.put("nodeid", (int)nodeId);
                obj.put("name", (Object)(connection.getValue().getLocalDevice().getManager().getNodeManufacturerName(homeId, nodeId) + " " + connection.getValue().getLocalDevice().getManager().getNodeProductName(homeId, nodeId)));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        arr.put((Object)obj);
        try {
            subobj.put("coordinators", (Object)arr);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return subobj;
    }

    @Descriptor(value="Show a list of all devices in the neighborhood of the coordinator device.")
    public JSONObject showNetwork() {
        JSONObject connection = new JSONObject();
        JSONObject result = new JSONObject();
        JSONArray devices = new JSONArray();
        JSONArray connections = new JSONArray();
        Iterator<Map.Entry<String, Connection>> connectionsIt = this.driver.getConnections().entrySet().iterator();
        try {
            while (connectionsIt.hasNext()) {
                Map.Entry<String, Connection> connectionsEntry = connectionsIt.next();
                for (Map.Entry<Short, Node> devicesEntry : connectionsEntry.getValue().getLocalDevice().getNodes().entrySet()) {
                    Node node = devicesEntry.getValue();
                    JSONObject dev = new JSONObject();
                    dev.put("nodeId", (int)node.getNodeId());
                    dev.put("nodeName", (Object)node.getNodeName());
                    dev.put("networkAddress", (Object)node.getNodeName());
                    dev.put("deviceType", (Object)node.getManager().getNodeType(connectionsEntry.getValue().getLocalDevice().getHomeId(), node.getNodeId()));
                    String name = node.getManager().getNodeProductName(connectionsEntry.getValue().getLocalDevice().getHomeId(), node.getNodeId());
                    if (name == null) {
                        name = "unknown";
                    }
                    dev.put("deviceName", (Object)name);
                    String manu = node.getManager().getNodeManufacturerName(connectionsEntry.getValue().getLocalDevice().getHomeId(), node.getNodeId());
                    if (manu == null) {
                        manu = "unknown";
                    }
                    dev.put("manufacturerId", (Object)manu);
                    dev.put("ready", node.isReady());
                    devices.put((Object)dev);
                }
                connection.put("interfaceName", (Object)connectionsEntry.getValue().getInterfaceId());
                connection.put("devices", (Object)devices);
                connections.put((Object)connection);
            }
            result.put("driverId", (Object)this.driver.getDriverId());
            result.put("busses", (Object)connections);
        }
        catch (JSONException e1) {
            e1.printStackTrace();
        }
        return result;
    }

    @Descriptor(value="Shows Details of a Device.")
    public JSONArray showDeviceDetails(String interfaceId, String nodeName) {
        JSONArray arr = new JSONArray();
        JSONObject obj = new JSONObject();
        Connection connection = this.driver.findConnection(interfaceId);
        if (connection != null) {
            Node node = connection.getLocalDevice().getNodes().get(Short.valueOf(nodeName));
            try {
                obj.put("device", (Object)node.getNodeName());
                System.out.println("    # Device:" + node.getNodeName());
                JSONArray attrarr = new JSONArray();
                for (Map.Entry<String, NodeValue> valueEntry : node.getValues().entrySet()) {
                    NodeValue nodeValue = valueEntry.getValue();
                    JSONObject val = new JSONObject();
                    System.out.println("        # Channel Address: " + nodeValue.getChannelAddress());
                    val.put("address", (Object)nodeValue.getChannelAddress());
                    System.out.println("        # Channelname: " + nodeValue.getValueName());
                    val.put("channelname", (Object)nodeValue.getValueName());
                    System.out.println();
                    attrarr.put((Object)val);
                }
                obj.put("valuechannels", (Object)attrarr);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            this.logger.error("InterfaceId seems not to be valid!");
        }
        arr.put((Object)obj);
        return arr;
    }

    @Descriptor(value="Returns all created channel Strings.")
    public JSONArray showAllCreatedChannels() {
        JSONArray result = new JSONArray();
        try {
            for (Map.Entry<String, Connection> connectionsEntry : this.driver.getConnections().entrySet()) {
                for (Map.Entry<Short, Device> devicesEntry : connectionsEntry.getValue().getDevices().entrySet()) {
                    Device device = devicesEntry.getValue();
                    for (Map.Entry<String, Channel> channelsEntry : device.getChannels().entrySet()) {
                        JSONObject devicesChannel = new JSONObject();
                        System.out.println("          # Channel: " + channelsEntry.getValue().getChannelLocator());
                        devicesChannel.put("channel", (Object)channelsEntry.getValue().getChannelLocator());
                        result.put((Object)devicesChannel);
                    }
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void addConnection(String hardwareIdentifier) {
    }

    public void addConnectionViaPort(String portName) {
    }

    public JSONObject showClusterDetails(String interfaceId, String device, String endpoint, String clusterId) {
        return null;
    }

    public JSONObject showNetwork(String option) {
        return this.showNetwork();
    }

    public String whichTech() {
        return "ZWave";
    }

    public String whichID() {
        return this.driver.getDriverId();
    }

    public JSONObject cacheDevices() {
        JSONObject obj = new JSONObject();
        try {
            obj.put("status", (Object)"Cache function is not yet implemented for Zwave!");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return obj;
    }

    public JSONObject scanForDevices() {
        JSONObject obj = new JSONObject();
        try {
            obj.put("status", (Object)"Inclusion enabled. Please start pairing the device.");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return obj;
    }

    @Descriptor(value="Shows all possible configs of a device/node.")
    public JSONArray showConfigs(String interfaceId, short deviceAddress) {
        JSONArray arr = new JSONArray();
        Connection connection = this.driver.findConnection(interfaceId);
        if (connection != null) {
            Node node = connection.getLocalDevice().getNodes().get(deviceAddress);
            String partialNodeAddress = interfaceId + ":" + node.getNodeName() + ":";
            if (node.isReady()) {
                for (Map.Entry<String, NodeValue> valueEntry : node.getValues().entrySet()) {
                    if (!valueEntry.getValue().getValueid().getGenre().equals((Object)ValueGenre.CONFIG) && !valueEntry.getValue().getValueid().getGenre().equals((Object)ValueGenre.SYSTEM)) continue;
                    JSONObject obj = new JSONObject();
                    try {
                        obj.put("channelAddress", (Object)(partialNodeAddress + valueEntry.getValue().getChannelAddress()));
                        obj.put("label", (Object)Manager.get().getValueLabel(valueEntry.getValue().getValueid()));
                        obj.put("help", (Object)Manager.get().getValueHelp(valueEntry.getValue().getValueid()));
                        if (valueEntry.getValue().getValueid().getType() == ValueType.LIST) {
                            ArrayList list = new ArrayList();
                            Manager.get().getValueListItems(valueEntry.getValue().getValueid(), list);
                            JSONArray listArray = new JSONArray();
                            for (String s : list) {
                                listArray.put((Object)s);
                            }
                            obj.put("valueList", (Object)listArray);
                            AtomicReference val = new AtomicReference();
                            Manager.get().getValueListSelectionString(valueEntry.getValue().getValueid(), val);
                            obj.put("selection", val.get());
                        } else {
                            obj.put("value", valueEntry.getValue().getValue());
                        }
                        obj.put("valueMin", Manager.get().getValueMin(valueEntry.getValue().getValueid()));
                        obj.put("valueMax", Manager.get().getValueMax(valueEntry.getValue().getValueid()));
                        obj.put("valueUnits", (Object)Manager.get().getValueUnits(valueEntry.getValue().getValueid()));
                        obj.put("readonly", Manager.get().isValueReadOnly(valueEntry.getValue().getValueid()));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    arr.put((Object)obj);
                }
            }
        } else {
            this.logger.error("InterfaceId seems not to be valid!");
        }
        return arr;
    }

    @Descriptor(value="Set a config with ChannelAddress COM3:nodeID:CommandClass:Instance:Index (e.g. COM3:12:XXXX:XXXX:XXXX.")
    public void writeConfig(String channelAddress, String value) {
        NodeValue nodeValue;
        Node node;
        String[] ca = channelAddress.split(":");
        Connection connection = this.driver.findConnection(ca[0]);
        if (!(connection == null || (node = connection.getLocalDevice().getNodes().get(Short.valueOf(ca[1]))) == null || (nodeValue = node.getValues().get(ca[2] + ":" + ca[3] + ":" + ca[4])) == null || nodeValue.getValueid().getGenre() != ValueGenre.SYSTEM && nodeValue.getValueid().getGenre() != ValueGenre.CONFIG || nodeValue.readOnly())) {
            nodeValue.setValue(value);
        }
    }
}

