/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.driver.zwave;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ogema.core.channelmanager.driverspi.ChannelLocator;
import org.ogema.core.channelmanager.driverspi.DeviceLocator;
import org.ogema.driver.zwave.Channel;
import org.ogema.driver.zwave.Connection;
import org.ogema.driver.zwave.manager.Node;

public class Device {
    private final DeviceLocator locator;
    private short deviceId;
    private Map<String, Channel> channels;
    private Connection con;

    public Device(DeviceLocator deviceLocator, Connection connection) {
        this.con = connection;
        this.locator = deviceLocator;
        this.channels = new HashMap<String, Channel>();
        String params = deviceLocator.getParameters();
        String id = params.substring(params.lastIndexOf(58) + 1, params.length());
        this.deviceId = Short.valueOf(id);
    }

    public List<ChannelLocator> getChannelLocators() {
        ArrayList<ChannelLocator> tempList = new ArrayList<ChannelLocator>();
        for (Map.Entry<String, Channel> channel : this.channels.entrySet()) {
            tempList.add(channel.getValue().getChannelLocator());
        }
        return tempList;
    }

    public Channel findChannel(ChannelLocator channelLocator) {
        return this.channels.get(channelLocator.getChannelAddress());
    }

    public void addChannel(Channel chan) {
        this.channels.put(chan.getChannelLocator().getChannelAddress(), chan);
    }

    public void removeChannel(Channel chan) {
        this.channels.remove(chan.getChannelLocator().getChannelAddress());
    }

    public Map<String, Channel> getChannels() {
        return this.channels;
    }

    public Node getNode() {
        return this.con.getLocalDevice().getNodes().get(this.deviceId);
    }

    public DeviceLocator getDeviceLocator() {
        return this.locator;
    }

    public Short getDeviceId() {
        return this.deviceId;
    }
}

