/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.driver.zwave;

import java.util.HashMap;
import java.util.Map;
import org.ogema.core.channelmanager.driverspi.DeviceLocator;
import org.ogema.core.hardwaremanager.HardwareManager;
import org.ogema.driver.zwave.Device;
import org.ogema.driver.zwave.ZWaveDriver;
import org.ogema.driver.zwave.manager.LocalDevice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection {
    private String interfaceId;
    private final Map<Short, Device> devices;
    private LocalDevice localDevice;
    private final Logger logger = LoggerFactory.getLogger((String)"zwave-driver");
    private boolean hasConnection = false;
    private final Object connectionLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection(String portName, Object lock, HardwareManager hwMngr, ZWaveDriver driver) {
        this.connectionLock = lock;
        this.devices = new HashMap<Short, Device>();
        this.localDevice = new LocalDevice(portName, driver);
        if (this.localDevice.isConnected()) {
            Object object = this.connectionLock;
            synchronized (object) {
                this.hasConnection = true;
            }
            this.interfaceId = portName;
        }
    }

    public Device findDevice(DeviceLocator device) {
        String params = device.getParameters();
        String id = params.substring(params.lastIndexOf(58) + 1, params.length());
        short deviceId = Short.valueOf(id);
        return this.devices.get(deviceId);
    }

    public void addDevice(Device dev) {
        this.devices.put(dev.getDeviceId(), dev);
        this.logger.info("Device added: " + dev.getDeviceId());
    }

    public LocalDevice getLocalDevice() {
        return this.localDevice;
    }

    public Map<Short, Device> getDevices() {
        return this.devices;
    }

    public void close() {
        this.localDevice.close();
    }

    public boolean hasConnection() {
        return this.hasConnection;
    }

    public String getInterfaceId() {
        return this.interfaceId;
    }
}

