/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.driver.zwave;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.ogema.core.channelmanager.driverspi.ChannelLocator;
import org.ogema.core.channelmanager.driverspi.ChannelUpdateListener;
import org.ogema.core.channelmanager.driverspi.SampledValueContainer;
import org.ogema.core.channelmanager.measurements.Quality;
import org.ogema.core.channelmanager.measurements.SampledValue;
import org.ogema.core.channelmanager.measurements.Value;
import org.ogema.driver.zwave.Connection;
import org.ogema.driver.zwave.Device;
import org.ogema.driver.zwave.manager.NodeValue;

public class Channel {
    private NodeValue nodeValue;
    private SampledValueContainer sampledValueContainer;
    private ChannelUpdateListener channelEventListener;
    private List<SampledValueContainer> sampledValueContainerList = new ArrayList<SampledValueContainer>();
    private ChannelLocator locator;

    public Channel(ChannelLocator locator, Device dev) {
        this.locator = locator;
        String[] splitAddress = locator.getChannelAddress().split(":");
        String channelAddress = splitAddress[0] + ":" + splitAddress[1] + ":" + splitAddress[2];
        this.nodeValue = dev.getNode().getValues().get(channelAddress);
    }

    public SampledValue readValue(Connection connection) throws IOException, UnsupportedOperationException {
        return new SampledValue(this.nodeValue.getOGEMAValue(), System.currentTimeMillis(), Quality.GOOD);
    }

    public void writeValue(Connection connection, Value value) throws IOException, UnsupportedOperationException {
        if (this.nodeValue.readOnly()) {
            throw new UnsupportedOperationException();
        }
        this.nodeValue.setOGEMAValue(value);
    }

    public void setEventListener(SampledValueContainer container, ChannelUpdateListener listener) throws IOException, UnsupportedOperationException {
        this.nodeValue.setChannel(this);
        this.nodeValue.setListener(true);
        this.sampledValueContainer = container;
        this.channelEventListener = listener;
        this.sampledValueContainerList.add(container);
    }

    public void removeUpdateListener() {
        this.nodeValue.setListener(false);
        this.channelEventListener = null;
        this.sampledValueContainerList.clear();
        this.sampledValueContainer = null;
    }

    public void updateListener() {
        if (!this.nodeValue.writeOnly()) {
            this.sampledValueContainer.setSampledValue(new SampledValue(this.nodeValue.getOGEMAValue(), System.currentTimeMillis(), Quality.GOOD));
            this.channelEventListener.channelsUpdated(this.sampledValueContainerList);
        }
    }

    public ChannelLocator getChannelLocator() {
        return this.locator;
    }
}

