/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.driver.zwave;

import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.ogema.core.channelmanager.driverspi.ChannelDriver;
import org.ogema.core.hardwaremanager.HardwareManager;
import org.ogema.driver.zwave.Connection;
import org.ogema.driver.zwave.ShellCommands;
import org.ogema.driver.zwave.ZWaveDriver;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@Component(specVersion="1.2")
public class Activator {
    private static ZWaveDriver driver;
    private ServiceRegistration<?> registration;
    @Reference
    private HardwareManager hardwareManager;
    public static volatile boolean bundleIsRunning;
    public ShellCommands sc;

    @Activate
    public synchronized void activate(BundleContext context, Map<String, Object> config) throws Exception {
        bundleIsRunning = true;
        if (driver == null) {
            driver = new ZWaveDriver(this.hardwareManager);
        }
        driver.establishConnection();
        this.registration = context.registerService(ChannelDriver.class, (Object)driver, null);
        this.sc = new ShellCommands(driver, context);
    }

    @Deactivate
    public synchronized void deactivate(Map<String, Object> config) throws Exception {
        bundleIsRunning = false;
        for (Map.Entry<String, Connection> entry : driver.getConnections().entrySet()) {
            entry.getValue().close();
        }
        if (this.registration != null) {
            this.registration.unregister();
        }
        if (this.sc != null) {
            this.sc.close();
        }
        this.sc = null;
    }

    protected void bindHardwareManager(HardwareManager hardwareManager) {
        this.hardwareManager = hardwareManager;
    }

    protected void unbindHardwareManager(HardwareManager hardwareManager) {
        if (this.hardwareManager == hardwareManager) {
            this.hardwareManager = null;
        }
    }
}

