/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.driver.hmhl.pattern;

import org.ogema.core.model.Resource;
import org.ogema.core.model.simple.BooleanResource;
import org.ogema.core.model.simple.FloatResource;
import org.ogema.core.model.units.TemperatureResource;
import org.ogema.core.model.units.VoltageResource;
import org.ogema.core.resourcemanager.AccessMode;
import org.ogema.core.resourcemanager.AccessPriority;
import org.ogema.core.resourcemanager.pattern.ResourcePattern;
import org.ogema.model.devices.buildingtechnology.Thermostat;

public class ThermostatPattern
extends ResourcePattern<Thermostat> {
    public final TemperatureResource currentTemperature;
    public final TemperatureResource remoteDesiredTemperature;
    public final VoltageResource batteryVoltage;
    public FloatResource batteryCharge;
    public final FloatResource valvePosition;
    public final BooleanResource isSwitchControllable;
    public final TemperatureResource localDesiredTemperature;

    public ThermostatPattern(Resource res) {
        super(res);
        this.currentTemperature = ((Thermostat)this.model).temperatureSensor().reading();
        this.remoteDesiredTemperature = ((Thermostat)this.model).temperatureSensor().deviceFeedback().setpoint();
        this.batteryVoltage = ((Thermostat)this.model).battery().internalVoltage().reading();
        this.batteryCharge = ((Thermostat)this.model).battery().chargeSensor().reading();
        this.valvePosition = ((Thermostat)this.model).valve().setting().stateFeedback();
        this.isSwitchControllable = ((Thermostat)this.model).valve().setting().controllable();
        this.localDesiredTemperature = ((Thermostat)this.model).temperatureSensor().settings().setpoint();
    }

    public void init() {
        this.currentTemperature.setKelvin(0.0f);
        this.remoteDesiredTemperature.setCelsius(20.0f);
        this.batteryVoltage.setValue(3.0f);
        this.valvePosition.setValue(0.0f);
        this.isSwitchControllable.setValue(false);
        this.localDesiredTemperature.setValue(20.0f);
        this.currentTemperature.requestAccessMode(AccessMode.EXCLUSIVE, AccessPriority.PRIO_HIGHEST);
        this.remoteDesiredTemperature.requestAccessMode(AccessMode.EXCLUSIVE, AccessPriority.PRIO_HIGHEST);
        this.batteryVoltage.requestAccessMode(AccessMode.EXCLUSIVE, AccessPriority.PRIO_HIGHEST);
        this.valvePosition.requestAccessMode(AccessMode.EXCLUSIVE, AccessPriority.PRIO_HIGHEST);
        this.isSwitchControllable.requestAccessMode(AccessMode.EXCLUSIVE, AccessPriority.PRIO_HIGHEST);
    }
}

