/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.driver.hmhl.devices;

import org.ogema.core.application.ApplicationManager;
import org.ogema.core.channelmanager.driverspi.DeviceLocator;
import org.ogema.core.channelmanager.measurements.Value;
import org.ogema.core.model.Resource;
import org.ogema.core.model.simple.FloatResource;
import org.ogema.core.model.simple.StringResource;
import org.ogema.core.resourcemanager.AccessMode;
import org.ogema.core.resourcemanager.AccessPriority;
import org.ogema.core.resourcemanager.ResourceAccess;
import org.ogema.driver.hmhl.HM_hlConfig;
import org.ogema.driver.hmhl.HM_hlDevice;
import org.ogema.driver.hmhl.HM_hlDriver;
import org.ogema.model.sensors.StateOfChargeSensor;
import org.ogema.model.sensors.WaterDetector;
import org.ogema.tools.resource.util.ResourceUtils;

public class WaterSensor
extends HM_hlDevice {
    private StringResource highWater;
    private FloatResource batteryStatus;

    public WaterSensor(HM_hlDriver driver, ApplicationManager appManager, HM_hlConfig config) {
        super(driver, appManager, config);
    }

    public WaterSensor(HM_hlDriver driver, ApplicationManager appManager, DeviceLocator deviceLocator) {
        super(driver, appManager, deviceLocator);
        this.addMandatoryChannels();
    }

    @Override
    protected void parseValue(Value value, String channelAddress) {
        switch (channelAddress) {
            case "ATTRIBUTE:0001": {
                this.highWater.setValue(value.getStringValue());
                this.highWater.activate(true);
                break;
            }
            case "ATTRIBUTE:0002": {
                this.batteryStatus.setValue(value.getFloatValue());
                this.batteryStatus.activate(true);
            }
        }
    }

    private void addMandatoryChannels() {
        HM_hlConfig attributeConfig = new HM_hlConfig();
        attributeConfig.driverId = this.hm_hlConfig.driverId;
        attributeConfig.interfaceId = this.hm_hlConfig.interfaceId;
        attributeConfig.deviceAddress = this.hm_hlConfig.deviceAddress;
        attributeConfig.channelAddress = "ATTRIBUTE:0001";
        attributeConfig.timeout = -1L;
        attributeConfig.resourceName = this.hm_hlConfig.resourceName + "_HighWater";
        attributeConfig.chLocator = this.addChannel(attributeConfig);
        attributeConfig = new HM_hlConfig();
        attributeConfig.driverId = this.hm_hlConfig.driverId;
        attributeConfig.interfaceId = this.hm_hlConfig.interfaceId;
        attributeConfig.deviceAddress = this.hm_hlConfig.deviceAddress;
        attributeConfig.channelAddress = "ATTRIBUTE:0002";
        attributeConfig.timeout = -1L;
        attributeConfig.resourceName = this.hm_hlConfig.resourceName + "_BatteryStatus";
        attributeConfig.chLocator = this.addChannel(attributeConfig);
        WaterDetector threeStateDevice = (WaterDetector)this.resourceManager.createResource(this.hm_hlConfig.resourceName, WaterDetector.class);
        this.highWater = (StringResource)threeStateDevice.reading().create();
        this.highWater.requestAccessMode(AccessMode.EXCLUSIVE, AccessPriority.PRIO_HIGHEST);
        StateOfChargeSensor eSens = (StateOfChargeSensor)threeStateDevice.battery().chargeSensor().create();
        this.batteryStatus = (FloatResource)eSens.reading().create();
        this.batteryStatus.requestAccessMode(AccessMode.EXCLUSIVE, AccessPriority.PRIO_HIGHEST);
        ResourceUtils.activateComplexResources((Resource)threeStateDevice, (boolean)true, (ResourceAccess)this.appManager.getResourceAccess());
    }

    @Override
    protected void unifyResourceName(HM_hlConfig config) {
        config.resourceName = config.resourceName + "_Water_Detector_" + config.deviceAddress.replace(':', '_');
    }

    @Override
    protected void terminate() {
        this.removeChannels();
    }
}

