/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.driver.hmhl.devices;

import org.ogema.core.application.ApplicationManager;
import org.ogema.core.channelmanager.ChannelConfiguration;
import org.ogema.core.channelmanager.driverspi.DeviceLocator;
import org.ogema.core.channelmanager.measurements.FloatValue;
import org.ogema.core.channelmanager.measurements.Value;
import org.ogema.core.model.Resource;
import org.ogema.core.model.units.TemperatureResource;
import org.ogema.core.resourcemanager.ResourceAccess;
import org.ogema.core.resourcemanager.ResourceValueListener;
import org.ogema.core.resourcemanager.pattern.ResourcePatternAccess;
import org.ogema.driver.hmhl.HM_hlConfig;
import org.ogema.driver.hmhl.HM_hlDevice;
import org.ogema.driver.hmhl.HM_hlDriver;
import org.ogema.driver.hmhl.pattern.ThermostatPattern;
import org.ogema.tools.resource.util.ResourceUtils;

public class Thermostat
extends HM_hlDevice
implements ResourceValueListener<TemperatureResource> {
    private final ResourcePatternAccess patAcc;
    private ThermostatPattern device;

    public Thermostat(HM_hlDriver driver, ApplicationManager appManager, HM_hlConfig config) {
        super(driver, appManager, config);
        this.patAcc = appManager.getResourcePatternAccess();
        this.device = (ThermostatPattern)this.patAcc.createResource(appManager.getResourceManagement().getUniqueResourceName(this.hm_hlConfig.resourceName), ThermostatPattern.class);
        this.activate(this.device);
    }

    public Thermostat(HM_hlDriver driver, ApplicationManager appManager, DeviceLocator deviceLocator) {
        super(driver, appManager, deviceLocator);
        this.patAcc = appManager.getResourcePatternAccess();
        this.device = (ThermostatPattern)this.patAcc.createResource(appManager.getResourceManagement().getUniqueResourceName(this.hm_hlConfig.resourceName), ThermostatPattern.class);
        this.activate(this.device);
        this.addMandatoryChannels();
    }

    @Override
    protected void parseValue(Value value, String channelAddress) {
        switch (channelAddress) {
            case "ATTRIBUTE:0001": {
                this.device.remoteDesiredTemperature.setCelsius(value.getFloatValue());
                this.device.remoteDesiredTemperature.activate(true);
                break;
            }
            case "ATTRIBUTE:0002": {
                this.device.currentTemperature.setCelsius(value.getFloatValue());
                this.device.currentTemperature.activate(true);
                break;
            }
            case "ATTRIBUTE:0003": {
                this.device.valvePosition.setValue(value.getFloatValue());
                this.device.valvePosition.activate(true);
                break;
            }
            case "ATTRIBUTE:0004": {
                this.device.batteryVoltage.setValue(value.getFloatValue());
                this.device.batteryVoltage.activate(true);
            }
        }
    }

    private void activate(ThermostatPattern device) {
        ResourceUtils.activateComplexResources((Resource)device.model, (boolean)true, (ResourceAccess)this.appManager.getResourceAccess());
        ((org.ogema.model.devices.buildingtechnology.Thermostat)device.model).valve().setting().controllable().setValue(false);
        ((org.ogema.model.devices.buildingtechnology.Thermostat)device.model).valve().setting().controllable().activate(false);
    }

    private void addMandatoryChannels() {
        HM_hlConfig attributeConfig = new HM_hlConfig();
        attributeConfig.driverId = this.hm_hlConfig.driverId;
        attributeConfig.interfaceId = this.hm_hlConfig.interfaceId;
        attributeConfig.deviceAddress = this.hm_hlConfig.deviceAddress;
        attributeConfig.channelAddress = "ATTRIBUTE:0001";
        attributeConfig.timeout = -1L;
        attributeConfig.resourceName = this.hm_hlConfig.resourceName + "_DesiredTemperature";
        attributeConfig.chLocator = this.addChannel(attributeConfig);
        attributeConfig = new HM_hlConfig();
        attributeConfig.driverId = this.hm_hlConfig.driverId;
        attributeConfig.interfaceId = this.hm_hlConfig.interfaceId;
        attributeConfig.deviceAddress = this.hm_hlConfig.deviceAddress;
        attributeConfig.channelAddress = "ATTRIBUTE:0002";
        attributeConfig.timeout = -1L;
        attributeConfig.resourceName = this.hm_hlConfig.resourceName + "_CurrentTemperature";
        attributeConfig.chLocator = this.addChannel(attributeConfig);
        attributeConfig = new HM_hlConfig();
        attributeConfig.driverId = this.hm_hlConfig.driverId;
        attributeConfig.interfaceId = this.hm_hlConfig.interfaceId;
        attributeConfig.deviceAddress = this.hm_hlConfig.deviceAddress;
        attributeConfig.channelAddress = "ATTRIBUTE:0003";
        attributeConfig.timeout = -1L;
        attributeConfig.resourceName = this.hm_hlConfig.resourceName + "_ValvePosition";
        attributeConfig.chLocator = this.addChannel(attributeConfig);
        attributeConfig = new HM_hlConfig();
        attributeConfig.driverId = this.hm_hlConfig.driverId;
        attributeConfig.interfaceId = this.hm_hlConfig.interfaceId;
        attributeConfig.deviceAddress = this.hm_hlConfig.deviceAddress;
        attributeConfig.channelAddress = "ATTRIBUTE:0004";
        attributeConfig.timeout = -1L;
        attributeConfig.resourceName = this.hm_hlConfig.resourceName + "_BatteryStatus";
        attributeConfig.chLocator = this.addChannel(attributeConfig);
        HM_hlConfig commandConfig = new HM_hlConfig();
        commandConfig.driverId = this.hm_hlConfig.driverId;
        commandConfig.interfaceId = this.hm_hlConfig.interfaceId;
        commandConfig.channelAddress = "COMMAND:01";
        commandConfig.timeout = -1L;
        commandConfig.resourceName = this.hm_hlConfig.resourceName + "_DesiredTemp";
        commandConfig.chLocator = this.addChannel(commandConfig);
        this.device.localDesiredTemperature.addValueListener((ResourceValueListener)this, false);
    }

    @Override
    protected void unifyResourceName(HM_hlConfig config) {
        config.resourceName = config.resourceName + "_RadiatorValve_" + config.deviceAddress.replace(':', '_');
    }

    public void resourceChanged(TemperatureResource res) {
        float localDesiredTemp = res.getCelsius();
        ChannelConfiguration locator = (ChannelConfiguration)this.commandChannel.get("COMMAND:01");
        this.writeToChannel(locator, (Value)new FloatValue(localDesiredTemp));
    }

    @Override
    protected void terminate() {
        this.removeChannels();
    }
}

