/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.driver.hmhl.devices;

import org.ogema.core.application.ApplicationManager;
import org.ogema.core.channelmanager.driverspi.DeviceLocator;
import org.ogema.core.channelmanager.measurements.Value;
import org.ogema.core.model.Resource;
import org.ogema.core.model.simple.FloatResource;
import org.ogema.core.model.simple.IntegerResource;
import org.ogema.core.model.units.TemperatureResource;
import org.ogema.core.resourcemanager.AccessMode;
import org.ogema.core.resourcemanager.AccessPriority;
import org.ogema.core.resourcemanager.ResourceAccess;
import org.ogema.driver.hmhl.HM_hlConfig;
import org.ogema.driver.hmhl.HM_hlDevice;
import org.ogema.driver.hmhl.HM_hlDriver;
import org.ogema.model.devices.sensoractordevices.SensorDevice;
import org.ogema.model.devices.storage.ElectricityStorage;
import org.ogema.model.sensors.HumiditySensor;
import org.ogema.model.sensors.StateOfChargeSensor;
import org.ogema.model.sensors.TemperatureSensor;
import org.ogema.tools.resource.util.ResourceUtils;

public class THSensor
extends HM_hlDevice {
    private FloatResource humidity;
    Status_hum humidityEnabled = Status_hum.UNKNOWN;
    private TemperatureResource temperature;
    private FloatResource batteryStatus;
    private SensorDevice thDevice;

    public THSensor(HM_hlDriver driver, ApplicationManager appManager, HM_hlConfig config) {
        super(driver, appManager, config);
    }

    public THSensor(HM_hlDriver driver, ApplicationManager appManager, DeviceLocator deviceLocator) {
        super(driver, appManager, deviceLocator);
        this.addMandatoryChannels();
    }

    @Override
    protected void parseValue(Value value, String channelAddress) {
        switch (channelAddress) {
            case "ATTRIBUTE:0001": {
                this.temperature.setCelsius(value.getFloatValue());
                this.temperature.activate(true);
                break;
            }
            case "ATTRIBUTE:0002": {
                if (this.humidityEnabled == Status_hum.UNKNOWN) {
                    float hum = 0.0f;
                    try {
                        hum = value.getFloatValue();
                    }
                    catch (NullPointerException e) {
                        this.humidityEnabled = Status_hum.DISABLED;
                    }
                    if (this.humidityEnabled == Status_hum.DISABLED) break;
                    this.enableHumidity();
                    this.humidity.setValue(hum * 0.01f);
                    this.humidity.activate(false);
                    break;
                }
                if (this.humidityEnabled != Status_hum.ENABLED) break;
                this.humidity.setValue(value.getFloatValue() * 0.01f);
                this.humidity.activate(false);
                break;
            }
            case "ATTRIBUTE:0003": {
                this.batteryStatus.setValue(value.getFloatValue());
                this.batteryStatus.activate(true);
            }
        }
    }

    private void addMandatoryChannels() {
        HM_hlConfig attributeConfig = new HM_hlConfig();
        attributeConfig.driverId = this.hm_hlConfig.driverId;
        attributeConfig.interfaceId = this.hm_hlConfig.interfaceId;
        attributeConfig.deviceAddress = this.hm_hlConfig.deviceAddress;
        attributeConfig.channelAddress = "ATTRIBUTE:0001";
        attributeConfig.timeout = -1L;
        attributeConfig.resourceName = this.hm_hlConfig.resourceName + "_Temperature";
        attributeConfig.chLocator = this.addChannel(attributeConfig);
        attributeConfig = new HM_hlConfig();
        attributeConfig.driverId = this.hm_hlConfig.driverId;
        attributeConfig.interfaceId = this.hm_hlConfig.interfaceId;
        attributeConfig.deviceAddress = this.hm_hlConfig.deviceAddress;
        attributeConfig.channelAddress = "ATTRIBUTE:0002";
        attributeConfig.timeout = -1L;
        attributeConfig.resourceName = this.hm_hlConfig.resourceName + "_Humidity";
        attributeConfig.chLocator = this.addChannel(attributeConfig);
        attributeConfig = new HM_hlConfig();
        attributeConfig.driverId = this.hm_hlConfig.driverId;
        attributeConfig.interfaceId = this.hm_hlConfig.interfaceId;
        attributeConfig.deviceAddress = this.hm_hlConfig.deviceAddress;
        attributeConfig.channelAddress = "ATTRIBUTE:0003";
        attributeConfig.timeout = -1L;
        attributeConfig.resourceName = this.hm_hlConfig.resourceName + "_BatteryStatus";
        attributeConfig.chLocator = this.addChannel(attributeConfig);
        this.thDevice = (SensorDevice)this.resourceManager.createResource(this.hm_hlConfig.resourceName, SensorDevice.class);
        this.thDevice.sensors().create();
        TemperatureSensor tSensor = (TemperatureSensor)this.thDevice.sensors().addDecorator("temperatureSensor", TemperatureSensor.class);
        this.temperature = (TemperatureResource)tSensor.reading().create();
        this.temperature.requestAccessMode(AccessMode.EXCLUSIVE, AccessPriority.PRIO_HIGHEST);
        ElectricityStorage battery = (ElectricityStorage)this.thDevice.electricityStorage().create();
        IntegerResource batteryType = (IntegerResource)battery.type().create();
        batteryType.setValue(1);
        batteryType.activate(false);
        StateOfChargeSensor eSens = (StateOfChargeSensor)battery.chargeSensor().create();
        this.batteryStatus = (FloatResource)eSens.reading().create();
        this.batteryStatus.requestAccessMode(AccessMode.EXCLUSIVE, AccessPriority.PRIO_HIGHEST);
        ResourceUtils.activateComplexResources((Resource)this.thDevice, (boolean)true, (ResourceAccess)this.appManager.getResourceAccess());
    }

    private void enableHumidity() {
        this.humidityEnabled = Status_hum.ENABLED;
        HumiditySensor hSensor = (HumiditySensor)this.thDevice.sensors().addDecorator("humiditySensor", HumiditySensor.class);
        this.humidity = (FloatResource)hSensor.reading().create();
        this.humidity.requestAccessMode(AccessMode.EXCLUSIVE, AccessPriority.PRIO_HIGHEST);
        hSensor.activate(false);
    }

    @Override
    protected void unifyResourceName(HM_hlConfig config) {
        config.resourceName = config.resourceName + "_THSensor_" + config.deviceAddress.replace(':', '_');
    }

    @Override
    protected void terminate() {
        this.removeChannels();
    }

    public static enum Status_hum {
        DISABLED,
        UNKNOWN,
        ENABLED;

    }
}

