/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.driver.hmhl.devices;

import org.ogema.core.application.ApplicationManager;
import org.ogema.core.channelmanager.driverspi.DeviceLocator;
import org.ogema.core.channelmanager.measurements.Value;
import org.ogema.core.model.Resource;
import org.ogema.core.model.simple.BooleanResource;
import org.ogema.core.model.simple.FloatResource;
import org.ogema.core.resourcemanager.AccessMode;
import org.ogema.core.resourcemanager.AccessPriority;
import org.ogema.core.resourcemanager.ResourceAccess;
import org.ogema.driver.hmhl.HM_hlConfig;
import org.ogema.driver.hmhl.HM_hlDevice;
import org.ogema.driver.hmhl.HM_hlDriver;
import org.ogema.model.sensors.SmokeDetector;
import org.ogema.model.sensors.StateOfChargeSensor;
import org.ogema.tools.resource.util.ResourceUtils;

public class SmokeSensor
extends HM_hlDevice {
    private BooleanResource smokeAlert;
    private FloatResource batteryStatus;

    public SmokeSensor(HM_hlDriver driver, ApplicationManager appManager, HM_hlConfig config) {
        super(driver, appManager, config);
    }

    public SmokeSensor(HM_hlDriver driver, ApplicationManager appManager, DeviceLocator dl) {
        super(driver, appManager, dl);
        this.addMandatoryChannels();
    }

    @Override
    protected void parseValue(Value value, String channelAddress) {
        switch (channelAddress) {
            case "ATTRIBUTE:0001": {
                this.smokeAlert.setValue(value.getBooleanValue());
                this.smokeAlert.activate(true);
                break;
            }
            case "ATTRIBUTE:0002": {
                this.batteryStatus.setValue(value.getFloatValue());
                this.batteryStatus.activate(true);
            }
        }
    }

    private void addMandatoryChannels() {
        HM_hlConfig attributeConfig = new HM_hlConfig();
        attributeConfig.driverId = this.hm_hlConfig.driverId;
        attributeConfig.interfaceId = this.hm_hlConfig.interfaceId;
        attributeConfig.deviceAddress = this.hm_hlConfig.deviceAddress;
        attributeConfig.channelAddress = "ATTRIBUTE:0001";
        attributeConfig.timeout = -1L;
        attributeConfig.resourceName = this.hm_hlConfig.resourceName + "SmokeDetector";
        attributeConfig.chLocator = this.addChannel(attributeConfig);
        attributeConfig = new HM_hlConfig();
        attributeConfig.driverId = this.hm_hlConfig.driverId;
        attributeConfig.interfaceId = this.hm_hlConfig.interfaceId;
        attributeConfig.deviceAddress = this.hm_hlConfig.deviceAddress;
        attributeConfig.channelAddress = "ATTRIBUTE:0002";
        attributeConfig.timeout = -1L;
        attributeConfig.resourceName = this.hm_hlConfig.resourceName + "_BatteryStatus";
        attributeConfig.chLocator = this.addChannel(attributeConfig);
        SmokeDetector smokeDetector = (SmokeDetector)this.resourceManager.createResource(this.hm_hlConfig.resourceName, SmokeDetector.class);
        this.smokeAlert = (BooleanResource)smokeDetector.reading().create();
        this.smokeAlert.requestAccessMode(AccessMode.EXCLUSIVE, AccessPriority.PRIO_HIGHEST);
        StateOfChargeSensor eSens = (StateOfChargeSensor)smokeDetector.battery().chargeSensor().create();
        this.batteryStatus = (FloatResource)eSens.reading().create();
        this.batteryStatus.requestAccessMode(AccessMode.EXCLUSIVE, AccessPriority.PRIO_HIGHEST);
        ResourceUtils.activateComplexResources((Resource)smokeDetector, (boolean)true, (ResourceAccess)this.appManager.getResourceAccess());
    }

    @Override
    protected void unifyResourceName(HM_hlConfig config) {
        config.resourceName = config.resourceName + "_Smoke_" + config.deviceAddress.replace(':', '_');
    }

    @Override
    protected void terminate() {
        this.removeChannels();
    }
}

